/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicOperatorType;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFunctionOperator
extends FunctionOperator {
    protected String value;
    private Logger logger = LoggerFactory.getLogger(BasicFunctionOperator.class);
    private BasicOperatorType funcToken;

    public BasicFunctionOperator(int tokenIntType, PartialPath path, String value) throws SQLParserException {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.BASIC_FUNC;
        this.funcToken = BasicOperatorType.getBasicOpBySymbol(tokenIntType);
        this.singlePath = path;
        this.value = value;
        this.isLeaf = true;
        this.isSingle = true;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void reverseFunc() {
        int intType = SQLConstant.reverseWords.get(this.tokenIntType);
        this.setTokenIntType(intType);
        this.funcToken = BasicOperatorType.getBasicOpBySymbol(intType);
    }

    @Override
    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws LogicalOperatorException, MetadataException {
        IUnaryExpression ret;
        TSDataType type = pathTSDataTypeHashMap.get(this.singlePath);
        if (type == null) {
            throw new MetadataException("given seriesPath:{" + this.singlePath.getFullPath() + "} don't exist in metadata");
        }
        switch (type) {
            case INT32: {
                ret = this.funcToken.getUnaryExpression(this.singlePath, Integer.valueOf(this.value));
                break;
            }
            case INT64: {
                ret = this.funcToken.getUnaryExpression(this.singlePath, Long.valueOf(this.value));
                break;
            }
            case BOOLEAN: {
                ret = this.funcToken.getUnaryExpression(this.singlePath, Boolean.valueOf(this.value));
                break;
            }
            case FLOAT: {
                ret = this.funcToken.getUnaryExpression(this.singlePath, Float.valueOf(this.value));
                break;
            }
            case DOUBLE: {
                ret = this.funcToken.getUnaryExpression(this.singlePath, Double.valueOf(this.value));
                break;
            }
            case TEXT: {
                ret = this.funcToken.getUnaryExpression(this.singlePath, this.value.startsWith("'") && this.value.endsWith("'") || this.value.startsWith("\"") && this.value.endsWith("\"") ? new Binary(this.value.substring(1, this.value.length() - 1)) : new Binary(this.value));
                break;
            }
            default: {
                throw new LogicalOperatorException(type.toString(), "");
            }
        }
        return new Pair((Object)ret, (Object)this.singlePath.getFullPath());
    }

    @Override
    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.singlePath.getFullPath(), this.tokenSymbol, this.value, ", single\n"});
        return sc.toString();
    }

    @Override
    public BasicFunctionOperator copy() {
        BasicFunctionOperator ret;
        try {
            ret = new BasicFunctionOperator(this.tokenIntType, new PartialPath((String[])this.singlePath.getNodes().clone()), this.value);
        }
        catch (SQLParserException e) {
            this.logger.error("error copy:", (Throwable)e);
            return null;
        }
        ret.tokenSymbol = this.tokenSymbol;
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        ret.pathSet = this.pathSet;
        return ret;
    }

    @Override
    public String toString() {
        return "[" + this.singlePath.getFullPath() + this.tokenSymbol + this.value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicFunctionOperator that = (BasicFunctionOperator)o;
        return Objects.equals(this.singlePath, that.singlePath) && Objects.equals(this.value, that.value) && this.funcToken == that.funcToken;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.singlePath, this.value, this.funcToken});
    }
}

