/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionMergeTaskPoolManager;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.merge.task.RecoverMergeTask;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.BatchInsertionException;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.utils.CopyOnReadLinkedList;
import org.apache.iotdb.db.utils.FileUtils;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupProcessor {
    public static final String MERGING_MODIFICATION_FILE_NAME = "merge.mods";
    private static final String FAIL_TO_UPGRADE_FOLDER = "Failed to move {} to upgrade folder";
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final int MERGE_MOD_START_VERSION_NUM = 1;
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupProcessor.class);
    private final boolean enableMemControl = this.config.isEnableMemControl();
    private static final int POS_ALREADY_EXIST = -2;
    private static final int POS_OVERLAP = -3;
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, TsFileProcessor> workSequenceTsFileProcessors = new TreeMap();
    private final TreeMap<Long, TsFileProcessor> workUnsequenceTsFileProcessors = new TreeMap();
    private volatile boolean compactionMergeWorking = false;
    private List<TsFileResource> upgradeSeqFileList = new LinkedList<TsFileResource>();
    private CopyOnReadLinkedList<TsFileProcessor> closingSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private List<TsFileResource> upgradeUnseqFileList = new LinkedList<TsFileResource>();
    private CopyOnReadLinkedList<TsFileProcessor> closingUnSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private Map<Long, Map<String, Long>> latestTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> partitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> newlyFlushedPartitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<String, Long> globalLatestFlushedTimeForEachDevice = new HashMap<String, Long>();
    private String storageGroupName;
    private File storageGroupSysDir;
    private TsFileManagement tsFileManagement;
    private HashMap<Long, VersionController> timePartitionIdVersionControllerMap = new HashMap();
    private long dataTTL = Long.MAX_VALUE;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private TsFileFlushPolicy fileFlushPolicy;
    private Map<Long, Set<Long>> partitionDirectFileVersions = new HashMap<Long, Set<Long>>();
    private Map<Long, Long> partitionMaxFileVersions = new HashMap<Long, Long>();
    private StorageGroupInfo storageGroupInfo = new StorageGroupInfo(this);
    private boolean isReady = false;
    private List<CloseFileListener> customCloseFileListeners = Collections.emptyList();
    private List<FlushListener> customFlushListeners = Collections.emptyList();

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public StorageGroupProcessor(String systemDir, String storageGroupName, TsFileFlushPolicy fileFlushPolicy) throws StorageGroupProcessorException {
        this.storageGroupName = storageGroupName;
        this.fileFlushPolicy = fileFlushPolicy;
        this.storageGroupSysDir = SystemFileFactory.INSTANCE.getFile(systemDir, storageGroupName);
        if (this.storageGroupSysDir.mkdirs()) {
            logger.info("Storage Group system Directory {} doesn't exist, create it", (Object)this.storageGroupSysDir.getPath());
        } else if (!this.storageGroupSysDir.exists()) {
            logger.error("create Storage Group system Directory {} failed", (Object)this.storageGroupSysDir.getPath());
        }
        this.tsFileManagement = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy().getTsFileManagement(storageGroupName, this.storageGroupSysDir.getAbsolutePath());
        this.recover();
    }

    private Map<Long, List<TsFileResource>> splitResourcesByPartition(List<TsFileResource> resources) {
        HashMap<Long, List<TsFileResource>> ret = new HashMap<Long, List<TsFileResource>>();
        for (TsFileResource resource : resources) {
            ret.computeIfAbsent(resource.getTimePartition(), l -> new ArrayList()).add(resource);
        }
        return ret;
    }

    private void recover() throws StorageGroupProcessorException {
        logger.info("recover Storage Group  {}", (Object)this.storageGroupName);
        try {
            long partitionNum;
            Pair<List<TsFileResource>, List<TsFileResource>> seqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllSequenceFileFolders());
            List tmpSeqTsFiles = (List)seqTsFilesPair.left;
            List oldSeqTsFiles = (List)seqTsFilesPair.right;
            this.upgradeSeqFileList.addAll(oldSeqTsFiles);
            Pair<List<TsFileResource>, List<TsFileResource>> unseqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            List tmpUnseqTsFiles = (List)unseqTsFilesPair.left;
            List oldUnseqTsFiles = (List)unseqTsFilesPair.right;
            this.upgradeUnseqFileList.addAll(oldUnseqTsFiles);
            Map<Long, List<TsFileResource>> partitionTmpSeqTsFiles = this.splitResourcesByPartition(tmpSeqTsFiles);
            Map<Long, List<TsFileResource>> partitionTmpUnseqTsFiles = this.splitResourcesByPartition(tmpUnseqTsFiles);
            for (List<TsFileResource> value : partitionTmpSeqTsFiles.values()) {
                this.recoverTsFiles(value, true);
            }
            for (List<TsFileResource> value : partitionTmpUnseqTsFiles.values()) {
                this.recoverTsFiles(value, false);
            }
            String taskName = this.storageGroupName + "-" + System.currentTimeMillis();
            File mergingMods = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, MERGING_MODIFICATION_FILE_NAME);
            if (mergingMods.exists()) {
                this.tsFileManagement.mergingModification = new ModificationFile(mergingMods.getPath());
            }
            RecoverMergeTask recoverMergeTask = new RecoverMergeTask(new ArrayList<TsFileResource>(this.tsFileManagement.getTsFileList(true)), this.tsFileManagement.getTsFileList(false), this.storageGroupSysDir.getPath(), this.tsFileManagement::mergeEndAction, taskName, IoTDBDescriptor.getInstance().getConfig().isForceFullMerge(), this.storageGroupName);
            logger.info("{} a RecoverMergeTask {} starts...", (Object)this.storageGroupName, (Object)taskName);
            recoverMergeTask.recoverMerge(IoTDBDescriptor.getInstance().getConfig().isContinueMergeAfterReboot());
            if (!IoTDBDescriptor.getInstance().getConfig().isContinueMergeAfterReboot()) {
                mergingMods.delete();
            }
            this.tsFileManagement.recover();
            for (TsFileResource resource : this.tsFileManagement.getTsFileList(true)) {
                partitionNum = resource.getTimePartition();
                this.partitionDirectFileVersions.computeIfAbsent(partitionNum, p -> new HashSet()).addAll(resource.getHistoricalVersions());
                this.updatePartitionFileVersion(partitionNum, Collections.max(resource.getHistoricalVersions()));
            }
            for (TsFileResource resource : this.tsFileManagement.getTsFileList(false)) {
                partitionNum = resource.getTimePartition();
                this.partitionDirectFileVersions.computeIfAbsent(partitionNum, p -> new HashSet()).addAll(resource.getHistoricalVersions());
                this.updatePartitionFileVersion(partitionNum, Collections.max(resource.getHistoricalVersions()));
            }
            this.updateLatestFlushedTime();
        }
        catch (IOException | MetadataException e) {
            throw new StorageGroupProcessorException(e);
        }
        for (TsFileResource resource : this.tsFileManagement.getTsFileList(true)) {
            long timePartitionId = resource.getTimePartition();
            HashMap<String, Long> endTimeMap = new HashMap<String, Long>();
            for (Map.Entry<String, Integer> entry : resource.getDeviceToIndexMap().entrySet()) {
                String deviceId = entry.getKey();
                int index = entry.getValue();
                long endTime = resource.getEndTime(index);
                endTimeMap.put(deviceId, endTime);
            }
            this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).putAll(endTimeMap);
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).putAll(endTimeMap);
            this.globalLatestFlushedTimeForEachDevice.putAll(endTimeMap);
        }
    }

    private void updatePartitionFileVersion(long partitionNum, long fileVersion) {
        long oldVersion = this.partitionMaxFileVersions.getOrDefault(partitionNum, 0L);
        if (fileVersion > oldVersion) {
            this.partitionMaxFileVersions.put(partitionNum, fileVersion);
        }
    }

    private void updateLatestFlushedTime() throws IOException {
        SimpleFileVersionController versionController = new SimpleFileVersionController(this.storageGroupSysDir.getPath());
        long currentVersion = versionController.currVersion();
        for (TsFileResource resource : this.upgradeSeqFileList) {
            for (Map.Entry<String, Integer> entry : resource.getDeviceToIndexMap().entrySet()) {
                String deviceId = entry.getKey();
                int index = entry.getValue();
                long endTime = resource.getEndTime(index);
                long endTimePartitionId = StorageEngine.getTimePartition(endTime);
                this.latestTimeForEachDevice.computeIfAbsent(endTimePartitionId, l -> new HashMap()).put(deviceId, endTime);
                this.globalLatestFlushedTimeForEachDevice.put(deviceId, endTime);
                for (long partitionId = StorageEngine.getTimePartition(resource.getStartTime(index)); partitionId <= endTimePartitionId; ++partitionId) {
                    File versionFile;
                    this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, l -> new HashMap()).put(deviceId, Long.MAX_VALUE);
                    if (this.timePartitionIdVersionControllerMap.containsKey(partitionId)) continue;
                    File directory = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, String.valueOf(partitionId));
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    if (!(versionFile = SystemFileFactory.INSTANCE.getFile(directory, "Version-" + currentVersion)).createNewFile()) {
                        logger.warn("Version file {} has already been created ", (Object)versionFile);
                    }
                    this.timePartitionIdVersionControllerMap.put(partitionId, new SimpleFileVersionController(this.storageGroupSysDir.getPath(), partitionId));
                }
            }
        }
    }

    private VersionController getVersionControllerByTimePartitionId(long timePartitionId) {
        return this.timePartitionIdVersionControllerMap.computeIfAbsent(timePartitionId, id -> {
            try {
                return new SimpleFileVersionController(this.storageGroupSysDir.getPath(), timePartitionId);
            }
            catch (IOException e) {
                logger.error("can't build a version controller for time partition {}", (Object)timePartitionId);
                return null;
            }
        });
    }

    private Pair<List<TsFileResource>, List<TsFileResource>> getAllFiles(List<String> folders) throws IOException {
        ArrayList tsFiles = new ArrayList();
        ArrayList upgradeFiles = new ArrayList();
        for (String baseDir : folders) {
            File[] subFiles;
            File fileFolder = this.fsFactory.getFile(baseDir, this.storageGroupName);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            this.continueFailedRenames(fileFolder, ".merge");
            File[] oldTsfileArray = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".tsfile");
            File[] oldResourceFileArray = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".resource");
            File[] oldModificationFileArray = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".mods");
            File upgradeFolder = this.fsFactory.getFile(fileFolder, "upgrade");
            if (oldTsfileArray.length != 0 || oldResourceFileArray.length != 0) {
                if (upgradeFolder.mkdirs()) {
                    logger.info("Upgrade Directory {} doesn't exist, create it", (Object)upgradeFolder.getPath());
                } else if (!upgradeFolder.exists()) {
                    logger.error("Create upgrade Directory {} failed", (Object)upgradeFolder.getPath());
                }
                for (File file : oldTsfileArray) {
                    if (file.renameTo(this.fsFactory.getFile(upgradeFolder, file.getName()))) continue;
                    logger.error(FAIL_TO_UPGRADE_FOLDER, (Object)file);
                }
                for (File file : oldResourceFileArray) {
                    if (file.renameTo(this.fsFactory.getFile(upgradeFolder, file.getName()))) continue;
                    logger.error(FAIL_TO_UPGRADE_FOLDER, (Object)file);
                }
                for (File file : oldModificationFileArray) {
                    if (file.renameTo(this.fsFactory.getFile(upgradeFolder, file.getName()))) continue;
                    logger.error(FAIL_TO_UPGRADE_FOLDER, (Object)file);
                }
                Collections.addAll(upgradeFiles, this.fsFactory.listFilesBySuffix(upgradeFolder.getAbsolutePath(), ".tsfile"));
            } else if (upgradeFolder.exists()) {
                Collections.addAll(upgradeFiles, this.fsFactory.listFilesBySuffix(upgradeFolder.getAbsolutePath(), ".tsfile"));
            }
            if ((subFiles = fileFolder.listFiles()) == null) continue;
            for (File partitionFolder : subFiles) {
                if (!partitionFolder.isDirectory()) {
                    logger.warn("{} is not a directory.", (Object)partitionFolder.getAbsolutePath());
                    continue;
                }
                if (partitionFolder.getName().equals("upgrade")) continue;
                this.continueFailedRenames(partitionFolder, ".temp");
                this.continueFailedRenames(partitionFolder, ".merge");
                Collections.addAll(tsFiles, this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile"));
            }
        }
        tsFiles.sort(this::compareFileName);
        ArrayList ret = new ArrayList();
        tsFiles.forEach(f -> ret.add(new TsFileResource((File)f)));
        upgradeFiles.sort(this::compareFileName);
        ArrayList<TsFileResource> upgradeRet = new ArrayList<TsFileResource>();
        for (File f2 : upgradeFiles) {
            TsFileResource fileResource = new TsFileResource(f2);
            fileResource.setClosed(true);
            fileResource.deserialize();
            upgradeRet.add(fileResource);
        }
        return new Pair(ret, upgradeRet);
    }

    private void continueFailedRenames(File fileFolder, String suffix) {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    tempResource.delete();
                    continue;
                }
                tempResource.renameTo(originResource);
            }
        }
    }

    private void recoverTsFiles(List<TsFileResource> tsFiles, boolean isSeq) {
        for (int i = 0; i < tsFiles.size(); ++i) {
            RestorableTsFileIOWriter writer;
            TsFileResource tsFileResource = tsFiles.get(i);
            long timePartitionId = tsFileResource.getTimePartition();
            TsFileRecoverPerformer recoverPerformer = new TsFileRecoverPerformer(this.storageGroupName + "-", this.getVersionControllerByTimePartitionId(timePartitionId), tsFileResource, isSeq, i == tsFiles.size() - 1);
            try {
                if (LevelCompactionTsFileManagement.getMergeLevel(tsFileResource.getTsFile()) > 0) {
                    recoverPerformer.recover(false);
                    tsFileResource.setClosed(true);
                    this.tsFileManagement.add(tsFileResource, isSeq);
                    continue;
                }
                writer = recoverPerformer.recover(true);
            }
            catch (StorageGroupProcessorException e) {
                logger.warn("Skip TsFile: {} because of error in recover: ", (Object)tsFileResource.getTsFilePath(), (Object)e);
                continue;
            }
            if (i != tsFiles.size() - 1 || !writer.canWrite()) {
                tsFileResource.setClosed(true);
            } else if (writer.canWrite()) {
                TsFileProcessor tsFileProcessor;
                if (isSeq) {
                    tsFileProcessor = new TsFileProcessor(this.storageGroupName, this.storageGroupInfo, tsFileResource, this.getVersionControllerByTimePartitionId(timePartitionId), this::closeUnsealedTsFileProcessorCallBack, this::updateLatestFlushTimeCallback, true, writer);
                    if (this.enableMemControl) {
                        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
                        tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                        this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
                        tsFileProcessorInfo.addTSPMemCost(tsFileProcessor.getTsFileResource().calculateRamSize());
                    }
                    this.workSequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                } else {
                    tsFileProcessor = new TsFileProcessor(this.storageGroupName, this.storageGroupInfo, tsFileResource, this.getVersionControllerByTimePartitionId(timePartitionId), this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false, writer);
                    if (this.enableMemControl) {
                        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
                        tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                        this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
                        tsFileProcessorInfo.addTSPMemCost(tsFileProcessor.getTsFileResource().calculateRamSize());
                    }
                    this.workUnsequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                }
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
                if (this.enableMemControl) {
                    long chunkMetadataSize = 0L;
                    for (Map metaMap : writer.getMetadatasForQuery().values()) {
                        for (List metadatas : metaMap.values()) {
                            for (ChunkMetadata chunkMetadata : metadatas) {
                                chunkMetadataSize += chunkMetadata.calculateRamSize();
                            }
                        }
                    }
                    tsFileProcessor.getTsFileProcessorInfo().addTSPMemCost(chunkMetadataSize);
                }
            }
            this.tsFileManagement.add(tsFileResource, isSeq);
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowPlan insertRowPlan) throws WriteProcessException {
        if (!this.isAlive(insertRowPlan.getTime())) {
            throw new OutOfTTLException(insertRowPlan.getTime(), System.currentTimeMillis() - this.dataTTL);
        }
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject();
        }
        this.writeLock();
        try {
            boolean isSequence;
            long timePartitionId = StorageEngine.getTimePartition(insertRowPlan.getTime());
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
            boolean bl = isSequence = insertRowPlan.getTime() > this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).getOrDefault(insertRowPlan.getDeviceId().getFullPath(), Long.MIN_VALUE);
            if (!isSequence && IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                return;
            }
            this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap());
            this.insertToTsFileProcessor(insertRowPlan, isSequence);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablet(InsertTabletPlan insertTabletPlan) throws BatchInsertionException {
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject();
            }
            catch (WriteProcessRejectException e) {
                Object[] results = new TSStatus[insertTabletPlan.getRowCount()];
                Arrays.fill(results, RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT));
                throw new BatchInsertionException((TSStatus[])results);
            }
        }
        this.writeLock();
        try {
            long currTime;
            int loc;
            Object[] results = new TSStatus[insertTabletPlan.getRowCount()];
            Arrays.fill(results, RpcUtils.SUCCESS_STATUS);
            boolean noFailure = true;
            for (loc = 0; loc < insertTabletPlan.getRowCount() && !this.isAlive(currTime = insertTabletPlan.getTimes()[loc]); ++loc) {
                results[loc] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OUT_OF_TTL_ERROR, (String)("time " + currTime + " in current line is out of TTL: " + this.dataTTL));
                noFailure = false;
            }
            if (loc == insertTabletPlan.getRowCount()) {
                throw new BatchInsertionException((TSStatus[])results);
            }
            int before = loc;
            long beforeTimePartition = StorageEngine.getTimePartition(insertTabletPlan.getTimes()[before]);
            long lastFlushTime = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(beforeTimePartition, id -> new HashMap()).computeIfAbsent(insertTabletPlan.getDeviceId().getFullPath(), id -> Long.MIN_VALUE);
            boolean isSequence = false;
            while (loc < insertTabletPlan.getRowCount()) {
                long time = insertTabletPlan.getTimes()[loc];
                long curTimePartition = StorageEngine.getTimePartition(time);
                if (curTimePartition != beforeTimePartition) {
                    if (isSequence || !IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                        noFailure = this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, isSequence, (TSStatus[])results, beforeTimePartition) && noFailure;
                    }
                    before = loc;
                    beforeTimePartition = curTimePartition;
                    lastFlushTime = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(beforeTimePartition, id -> new HashMap()).computeIfAbsent(insertTabletPlan.getDeviceId().getFullPath(), id -> Long.MIN_VALUE);
                    isSequence = false;
                    continue;
                }
                if (!isSequence && time > lastFlushTime) {
                    if (!IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                        noFailure = this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, false, (TSStatus[])results, beforeTimePartition) && noFailure;
                    }
                    before = loc;
                    isSequence = true;
                }
                ++loc;
            }
            if (before < loc && (isSequence || !IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData())) {
                noFailure = this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, isSequence, (TSStatus[])results, beforeTimePartition) && noFailure;
            }
            long globalLatestFlushedTime = this.globalLatestFlushedTimeForEachDevice.getOrDefault(insertTabletPlan.getDeviceId().getFullPath(), Long.MIN_VALUE);
            this.tryToUpdateBatchInsertLastCache(insertTabletPlan, globalLatestFlushedTime);
            if (!noFailure) {
                throw new BatchInsertionException((TSStatus[])results);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isAlive(long time) {
        return this.dataTTL == Long.MAX_VALUE || System.currentTimeMillis() - time <= this.dataTTL;
    }

    private boolean insertTabletToTsFileProcessor(InsertTabletPlan insertTabletPlan, int start, int end, boolean sequence, TSStatus[] results, long timePartitionId) {
        if (start >= end) {
            return true;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("can not create TsFileProcessor, timePartitionId: " + timePartitionId));
            }
            return false;
        }
        try {
            tsFileProcessor.insertTablet(insertTabletPlan, start, end, results);
        }
        catch (WriteProcessRejectException e) {
            logger.warn("insert to TsFileProcessor rejected ", (Throwable)e);
            return false;
        }
        catch (WriteProcessException e) {
            logger.error("insert to TsFileProcessor error ", (Throwable)e);
            return false;
        }
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, t -> new HashMap());
        if (sequence && this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(insertTabletPlan.getDeviceId().getFullPath(), Long.MIN_VALUE) < insertTabletPlan.getTimes()[end - 1]) {
            this.latestTimeForEachDevice.get(timePartitionId).put(insertTabletPlan.getDeviceId().getFullPath(), insertTabletPlan.getTimes()[end - 1]);
        }
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
        return true;
    }

    private void tryToUpdateBatchInsertLastCache(InsertTabletPlan plan, Long latestFlushedTime) {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        MeasurementMNode[] mNodes = plan.getMeasurementMNodes();
        for (int i = 0; i < mNodes.length; ++i) {
            if (plan.getColumns()[i] == null) continue;
            if (mNodes[i] != null) {
                IoTDB.metaManager.updateLastCache(null, plan.composeLastTimeValuePair(i), true, latestFlushedTime, mNodes[i]);
                continue;
            }
            IoTDB.metaManager.updateLastCache(plan.getDeviceId().concatNode(plan.getMeasurements()[i]), plan.composeLastTimeValuePair(i), true, latestFlushedTime, null);
        }
    }

    private void insertToTsFileProcessor(InsertRowPlan insertRowPlan, boolean sequence) throws WriteProcessException {
        long timePartitionId = StorageEngine.getTimePartition(insertRowPlan.getTime());
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            return;
        }
        tsFileProcessor.insert(insertRowPlan);
        if (this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(insertRowPlan.getDeviceId().getFullPath(), Long.MIN_VALUE) < insertRowPlan.getTime()) {
            this.latestTimeForEachDevice.get(timePartitionId).put(insertRowPlan.getDeviceId().getFullPath(), insertRowPlan.getTime());
        }
        long globalLatestFlushTime = this.globalLatestFlushedTimeForEachDevice.getOrDefault(insertRowPlan.getDeviceId().getFullPath(), Long.MIN_VALUE);
        this.tryToUpdateInsertLastCache(insertRowPlan, globalLatestFlushTime);
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
    }

    private void tryToUpdateInsertLastCache(InsertRowPlan plan, Long latestFlushedTime) {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        MeasurementMNode[] mNodes = plan.getMeasurementMNodes();
        for (int i = 0; i < mNodes.length; ++i) {
            if (plan.getValues()[i] == null) continue;
            if (mNodes[i] != null) {
                IoTDB.metaManager.updateLastCache(null, plan.composeTimeValuePair(i), true, latestFlushedTime, mNodes[i]);
                continue;
            }
            IoTDB.metaManager.updateLastCache(plan.getDeviceId().concatNode(plan.getMeasurements()[i]), plan.composeTimeValuePair(i), true, latestFlushedTime, null);
        }
    }

    public void asyncFlushMemTableInTsFileProcessor(TsFileProcessor tsFileProcessor) {
        this.writeLock();
        try {
            if (!this.closingSequenceTsFileProcessor.contains(tsFileProcessor) && !this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor)) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(long timeRangeId, boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        try {
            tsFileProcessor = sequence ? this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workSequenceTsFileProcessors, true) : this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workUnsequenceTsFileProcessors, false);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        catch (IOException e) {
            logger.error("meet IOException when creating TsFileProcessor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        return tsFileProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TsFileProcessor getOrCreateTsFileProcessorIntern(long timeRangeId, TreeMap<Long, TsFileProcessor> tsFileProcessorTreeMap, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor res;
        this.writeLock();
        try {
            if (!tsFileProcessorTreeMap.containsKey(timeRangeId)) {
                if (tsFileProcessorTreeMap.size() >= IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition()) {
                    Map.Entry<Long, TsFileProcessor> processorEntry = tsFileProcessorTreeMap.firstEntry();
                    logger.info("will close a {} TsFile because too many active partitions ({} > {}) in the storage group {},", new Object[]{sequence, tsFileProcessorTreeMap.size(), IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition(), this.storageGroupName});
                    this.asyncCloseOneTsFileProcessor(sequence, processorEntry.getValue());
                }
                TsFileProcessor newProcessor = this.createTsFileProcessor(sequence, timeRangeId);
                tsFileProcessorTreeMap.put(timeRangeId, newProcessor);
                this.tsFileManagement.add(newProcessor.getTsFileResource(), sequence);
                res = newProcessor;
            } else {
                res = tsFileProcessorTreeMap.get(timeRangeId);
            }
        }
        finally {
            this.writeUnlock();
        }
        return res;
    }

    private TsFileProcessor createTsFileProcessor(boolean sequence, long timePartitionId) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor tsFileProcessor;
        String baseDir = sequence ? DirectoryManager.getInstance().getNextFolderForSequenceFile() : DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
        this.fsFactory.getFile(baseDir, this.storageGroupName).mkdirs();
        String filePath = baseDir + File.separator + this.storageGroupName + File.separator + timePartitionId + File.separator + this.getNewTsFileName(timePartitionId);
        VersionController versionController = this.getVersionControllerByTimePartitionId(timePartitionId);
        if (sequence) {
            tsFileProcessor = new TsFileProcessor(this.storageGroupName, this.fsFactory.getFileWithParent(filePath), this.storageGroupInfo, versionController, this::closeUnsealedTsFileProcessorCallBack, this::updateLatestFlushTimeCallback, true, this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L));
            if (this.enableMemControl) {
                TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
                tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
                tsFileProcessorInfo.addTSPMemCost(tsFileProcessor.getTsFileResource().calculateRamSize());
            }
        } else {
            tsFileProcessor = new TsFileProcessor(this.storageGroupName, this.fsFactory.getFileWithParent(filePath), this.storageGroupInfo, versionController, this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false, this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L));
            if (this.enableMemControl) {
                TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
                tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
                tsFileProcessorInfo.addTSPMemCost(tsFileProcessor.getTsFileResource().calculateRamSize());
            }
        }
        tsFileProcessor.addCloseFileListeners(this.customCloseFileListeners);
        tsFileProcessor.addFlushListeners(this.customFlushListeners);
        tsFileProcessor.setTimeRangeId(timePartitionId);
        return tsFileProcessor;
    }

    private String getNewTsFileName(long timePartitionId) {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        this.partitionDirectFileVersions.computeIfAbsent(timePartitionId, p -> new HashSet()).add(version);
        return this.getNewTsFileName(System.currentTimeMillis(), version, 0);
    }

    private String getNewTsFileName(long time, long version, int mergeCnt) {
        return time + "-" + version + "-" + mergeCnt + ".tsfile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseOneTsFileProcessor(sequence, tsFileProcessor);
                long startTime = System.currentTimeMillis();
                while (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor)) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing one tsfile.", (Object)this.storageGroupName, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("syncCloseOneTsFileProcessor error occurs while waiting for closing the storage group {}", (Object)this.storageGroupName, (Object)e);
            }
        }
    }

    public void asyncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor)) {
            return;
        }
        logger.info("Async close tsfile: {}", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(tsFileProcessor);
            this.updateEndTimeMap(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workSequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workUnsequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
            logger.info("close a sequence tsfile processor {}", (Object)this.storageGroupName);
        } else {
            this.closingUnSequenceTsFileProcessor.add(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workUnsequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workSequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
        }
    }

    public void deleteFolder(String systemDir) {
        logger.info("{} will close all files for deleting data folder {}", (Object)this.storageGroupName, (Object)systemDir);
        this.writeLock();
        this.syncCloseAllWorkingTsFileProcessors();
        try {
            File storageGroupFolder = SystemFileFactory.INSTANCE.getFile(systemDir, this.storageGroupName);
            if (storageGroupFolder.exists()) {
                FileUtils.deleteDirectory(storageGroupFolder);
            }
        }
        catch (IOException e) {
            logger.error("Cannot delete the folder in storage group {}, because", (Object)this.storageGroupName, (Object)e);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void closeAllResources() {
        for (TsFileResource tsFileResource : this.tsFileManagement.getTsFileList(false)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
        for (TsFileResource tsFileResource : this.tsFileManagement.getTsFileList(true)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
    }

    public void syncDeleteDataFiles() {
        logger.info("{} will close all files for deleting data files", (Object)this.storageGroupName);
        this.writeLock();
        this.syncCloseAllWorkingTsFileProcessors();
        if (this.tsFileManagement.mergingModification != null) {
            try {
                this.tsFileManagement.mergingModification.close();
            }
            catch (IOException e) {
                logger.error("Cannot close the mergingMod file {}", (Object)this.tsFileManagement.mergingModification.getFilePath(), (Object)e);
            }
        }
        try {
            this.closeAllResources();
            List<String> folder = DirectoryManager.getInstance().getAllSequenceFileFolders();
            folder.addAll(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            this.deleteAllSGFolders(folder);
            this.workSequenceTsFileProcessors.clear();
            this.workUnsequenceTsFileProcessors.clear();
            this.tsFileManagement.clear();
            this.partitionLatestFlushedTimeForEachDevice.clear();
            this.globalLatestFlushedTimeForEachDevice.clear();
            this.latestTimeForEachDevice.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File storageGroupFolder = this.fsFactory.getFile(tsfilePath, this.storageGroupName);
            if (!storageGroupFolder.exists()) continue;
            try {
                FileUtils.deleteDirectory(storageGroupFolder);
            }
            catch (IOException e) {
                logger.error("Delete TsFiles failed", (Throwable)e);
            }
        }
    }

    public synchronized void checkFilesTTL() {
        if (this.dataTTL == Long.MAX_VALUE) {
            logger.debug("{}: TTL not set, ignore the check", (Object)this.storageGroupName);
            return;
        }
        long timeLowerBound = System.currentTimeMillis() - this.dataTTL;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: TTL removing files before {}", (Object)this.storageGroupName, (Object)new Date(timeLowerBound));
        }
        ArrayList<TsFileResource> seqFiles = new ArrayList<TsFileResource>(this.tsFileManagement.getTsFileList(true));
        ArrayList<TsFileResource> unseqFiles = new ArrayList<TsFileResource>(this.tsFileManagement.getTsFileList(false));
        for (TsFileResource tsFileResource : seqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, true);
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileTTL(TsFileResource resource, long timeLowerBound, boolean isSeq) {
        block10: {
            if (resource.isMerging() || !resource.isClosed() || !resource.isDeleted() && resource.stillLives(timeLowerBound)) {
                return;
            }
            this.writeLock();
            try {
                resource.setDeleted(true);
                if (resource.isMerging()) {
                    return;
                }
                if (!resource.tryWriteLock()) break block10;
                try {
                    resource.remove();
                    if (logger.isInfoEnabled()) {
                        logger.info("Removed a file {} before {} by ttl ({}ms)", new Object[]{resource.getTsFilePath(), new Date(timeLowerBound), this.dataTTL});
                    }
                    this.tsFileManagement.remove(resource, isSeq);
                }
                finally {
                    resource.writeUnlock();
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseAllWorkingTsFileProcessors() {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseAllWorkingTsFileProcessors();
                long startTime = System.currentTimeMillis();
                while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing all TsFiles.", (Object)this.storageGroupName, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
                while (this.compactionMergeWorking) {
                    this.closeStorageGroupCondition.wait(100L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing compaction.", (Object)this.storageGroupName, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncCloseAllWorkingTsFileProcessors() {
        this.writeLock();
        try {
            logger.info("async force close all files in storage group: {}", (Object)this.storageGroupName);
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(true, tsFileProcessor);
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(false, tsFileProcessor);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        this.writeLock();
        try {
            logger.info("force close all processors in storage group: {}", (Object)this.storageGroupName);
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public QueryDataSource query(PartialPath deviceId, String measurementId, QueryContext context, QueryFileManager filePathsManager, Filter timeFilter) throws QueryProcessException {
        this.insertLock.readLock().lock();
        try {
            List<TsFileResource> seqResources = this.getFileResourceListForQuery(this.tsFileManagement.getTsFileList(true), this.upgradeSeqFileList, deviceId, measurementId, context, timeFilter, true);
            List<TsFileResource> unseqResources = this.getFileResourceListForQuery(this.tsFileManagement.getTsFileList(false), this.upgradeUnseqFileList, deviceId, measurementId, context, timeFilter, false);
            QueryDataSource dataSource = new QueryDataSource(deviceId, seqResources, unseqResources);
            if (filePathsManager != null) {
                filePathsManager.addUsedFilesForQuery(context.getQueryId(), dataSource);
            }
            dataSource.setDataTTL(this.dataTTL);
            QueryDataSource queryDataSource = dataSource;
            return queryDataSource;
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        finally {
            this.insertLock.readLock().unlock();
        }
    }

    public void writeLock() {
        this.insertLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.insertLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> getFileResourceListForQuery(Collection<TsFileResource> tsFileResources, List<TsFileResource> upgradeTsFileResources, PartialPath deviceId, String measurementId, QueryContext context, Filter timeFilter, boolean isSeq) throws MetadataException {
        if (this.config.isDebugOn()) {
            DEBUG_LOGGER.info("Path: {}.{}, get tsfile list: {} isSeq: {} timefilter: {}", new Object[]{deviceId.getFullPath(), measurementId, tsFileResources, isSeq, timeFilter == null ? "null" : timeFilter});
        }
        MeasurementSchema schema = IoTDB.metaManager.getSeriesSchema(deviceId, measurementId);
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        long timeLowerBound = this.dataTTL != Long.MAX_VALUE ? System.currentTimeMillis() - this.dataTTL : Long.MIN_VALUE;
        context.setQueryTimeLowerBound(timeLowerBound);
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!this.isTsFileResourceSatisfied(tsFileResource, deviceId.getFullPath(), timeFilter, isSeq)) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                tsFileResource.getUnsealedFileProcessor().query(deviceId.getFullPath(), measurementId, schema.getType(), schema.getEncodingType(), schema.getProps(), context, tsfileResourcesForQuery);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        for (TsFileResource tsFileResource : upgradeTsFileResources) {
            if (!this.isTsFileResourceSatisfied(tsFileResource, deviceId.getFullPath(), timeFilter, isSeq)) continue;
            this.closeQueryLock.readLock().lock();
            try {
                tsfileResourcesForQuery.add(tsFileResource);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    private boolean isTsFileResourceSatisfied(TsFileResource tsFileResource, String deviceId, Filter timeFilter, boolean isSeq) {
        long endTime;
        if (!tsFileResource.containsDevice(deviceId)) {
            if (this.config.isDebugOn()) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)tsFileResource);
            }
            return false;
        }
        int deviceIndex = tsFileResource.getDeviceToIndexMap().get(deviceId);
        long startTime = tsFileResource.getStartTime(deviceIndex);
        long l = endTime = tsFileResource.isClosed() || !isSeq ? tsFileResource.getEndTime(deviceIndex) : Long.MAX_VALUE;
        if (!this.isAlive(endTime)) {
            if (this.config.isDebugOn()) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of ttl!", (Object)deviceId, (Object)tsFileResource);
            }
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (this.config.isDebugOn() && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", (Object)deviceId, (Object)tsFileResource);
            }
            return res;
        }
        return true;
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex) throws IOException {
        this.writeLock();
        this.tsFileManagement.writeLock();
        ArrayList<ModificationFile> updatedModFiles = new ArrayList<ModificationFile>();
        try {
            Set<PartialPath> devicePaths = IoTDB.metaManager.getDevices(path.getDevicePath());
            for (PartialPath device : devicePaths) {
                Long lastUpdateTime = null;
                for (Map<String, Long> latestTimeMap : this.latestTimeForEachDevice.values()) {
                    Long curTime = latestTimeMap.get(device.getFullPath());
                    if (curTime == null || lastUpdateTime != null && lastUpdateTime >= curTime) continue;
                    lastUpdateTime = curTime;
                }
                if (lastUpdateTime == null) {
                    logger.debug("No device {} in SG {}, deletion invalid", (Object)device, (Object)this.storageGroupName);
                    return;
                }
                this.tryToDeleteLastCache(device, path, startTime, endTime);
            }
            this.logDeletion(startTime, endTime, path);
            Deletion deletion = new Deletion(path, 1L, startTime, endTime);
            if (this.tsFileManagement.mergingModification != null) {
                this.tsFileManagement.mergingModification.write(deletion);
                updatedModFiles.add(this.tsFileManagement.mergingModification);
            }
            this.deleteDataInFiles(this.tsFileManagement.getTsFileList(true), deletion, devicePaths, updatedModFiles, planIndex);
            this.deleteDataInFiles(this.tsFileManagement.getTsFileList(false), deletion, devicePaths, updatedModFiles, planIndex);
        }
        catch (Exception e) {
            for (ModificationFile modFile : updatedModFiles) {
                modFile.abort();
            }
            throw new IOException(e);
        }
        finally {
            this.tsFileManagement.writeUnlock();
            this.writeUnlock();
        }
    }

    private void logDeletion(long startTime, long endTime, PartialPath path) throws IOException {
        long timePartitionStartId = StorageEngine.getTimePartition(startTime);
        long timePartitionEndId = StorageEngine.getTimePartition(endTime);
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            DeletePlan deletionPlan = new DeletePlan(startTime, endTime, path);
            for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
                if (timePartitionStartId > entry.getKey() || entry.getKey() > timePartitionEndId) continue;
                entry.getValue().getLogNode().write(deletionPlan);
            }
            for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
                if (timePartitionStartId > entry.getKey() || entry.getKey() > timePartitionEndId) continue;
                entry.getValue().getLogNode().write(deletionPlan);
            }
        }
    }

    private boolean canSkipDelete(TsFileResource tsFileResource, Set<PartialPath> devicePaths, long deleteStart, long deleteEnd) {
        for (PartialPath device : devicePaths) {
            if (!tsFileResource.containsDevice(device.getFullPath()) || deleteEnd < tsFileResource.getStartTime(device.getFullPath()) || deleteStart > tsFileResource.getOrDefaultEndTime(device.getFullPath(), Long.MAX_VALUE)) continue;
            return false;
        }
        return true;
    }

    private void deleteDataInFiles(Collection<TsFileResource> tsFileResourceList, Deletion deletion, Set<PartialPath> devicePaths, List<ModificationFile> updatedModFiles, long planIndex) throws IOException {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (this.canSkipDelete(tsFileResource, devicePaths, deletion.getStartTime(), deletion.getEndTime())) continue;
            long partitionId = tsFileResource.getTimePartition();
            deletion.setVersionNum(this.getVersionControllerByTimePartitionId(partitionId).nextVersion());
            tsFileResource.getModFile().write(deletion);
            tsFileResource.getModFile().close();
            tsFileResource.updatePlanIndexes(planIndex);
            if (!tsFileResource.isClosed()) {
                TsFileProcessor tsfileProcessor = tsFileResource.getUnsealedFileProcessor();
                tsfileProcessor.deleteDataInMemory(deletion, devicePaths);
            }
            updatedModFiles.add(tsFileResource.getModFile());
        }
    }

    private void tryToDeleteLastCache(PartialPath deviceId, PartialPath originalPath, long startTime, long endTime) throws WriteProcessException {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        try {
            MNode node = IoTDB.metaManager.getDeviceNode(deviceId);
            for (MNode measurementNode : node.getChildren().values()) {
                TimeValuePair lastPair;
                if (measurementNode == null || !originalPath.matchFullPath(measurementNode.getPartialPath()) || (lastPair = ((MeasurementMNode)measurementNode).getCachedLast()) == null || startTime > lastPair.getTimestamp() || lastPair.getTimestamp() > endTime) continue;
                ((MeasurementMNode)measurementNode).resetCache();
            }
        }
        catch (MetadataException e) {
            throw new WriteProcessException(e);
        }
    }

    private void updateEndTimeMap(TsFileProcessor tsFileProcessor) {
        TsFileResource resource = tsFileProcessor.getTsFileResource();
        for (Map.Entry<String, Integer> startTime : resource.getDeviceToIndexMap().entrySet()) {
            String deviceId = startTime.getKey();
            resource.forceUpdateEndTime(deviceId, this.latestTimeForEachDevice.get(tsFileProcessor.getTimeRangeId()).get(deviceId));
        }
    }

    private boolean unsequenceFlushCallback(TsFileProcessor processor) {
        return true;
    }

    private boolean updateLatestFlushTimeCallback(TsFileProcessor processor) {
        Map<String, Long> curPartitionDeviceLatestTime = this.latestTimeForEachDevice.get(processor.getTimeRangeId());
        if (curPartitionDeviceLatestTime == null) {
            logger.warn("Partition: {} does't have latest time for each device. No valid record is written into memtable. Flushing tsfile is: {}", (Object)processor.getTimeRangeId(), (Object)processor.getTsFileResource().getTsFile());
            return false;
        }
        for (Map.Entry<String, Long> entry : curPartitionDeviceLatestTime.entrySet()) {
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(processor.getTimeRangeId(), id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(processor.getTimeRangeId(), entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).compute(deviceId, (k, v) -> v == null ? time : Math.max(v, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessorCallBack(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
            this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
        } else {
            this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
        }
        if (!this.compactionMergeWorking && !CompactionMergeTaskPoolManager.getInstance().isTerminated()) {
            this.compactionMergeWorking = true;
            logger.info("{} submit a compaction merge task", (Object)this.storageGroupName);
            try {
                this.tsFileManagement.forkCurrentFileList(tsFileProcessor.getTimeRangeId());
                CompactionMergeTaskPoolManager compactionMergeTaskPoolManager = CompactionMergeTaskPoolManager.getInstance();
                TsFileManagement tsFileManagement = this.tsFileManagement;
                tsFileManagement.getClass();
                compactionMergeTaskPoolManager.submitTask(tsFileManagement.new TsFileManagement.CompactionMergeTask(this::closeCompactionMergeCallBack, tsFileProcessor.getTimeRangeId()));
            }
            catch (IOException | RejectedExecutionException e) {
                this.closeCompactionMergeCallBack();
                logger.error("{} compaction submit task failed", (Object)this.storageGroupName);
            }
        } else {
            logger.info("{} last compaction merge task is working, skip current merge", (Object)this.storageGroupName);
        }
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            this.closeStorageGroupCondition.notifyAll();
        }
        logger.info("signal closing storage group condition in {}", (Object)this.storageGroupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCompactionMergeCallBack() {
        this.compactionMergeWorking = false;
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            this.closeStorageGroupCondition.notifyAll();
        }
    }

    public int countUpgradeFiles() {
        return this.upgradeSeqFileList.size() + this.upgradeUnseqFileList.size();
    }

    public void upgrade() {
        for (TsFileResource seqTsFileResource : this.upgradeSeqFileList) {
            seqTsFileResource.setSeq(true);
            seqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            seqTsFileResource.doUpgrade();
        }
        for (TsFileResource unseqTsFileResource : this.upgradeUnseqFileList) {
            unseqTsFileResource.setSeq(false);
            unseqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            unseqTsFileResource.doUpgrade();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeTsFileResourceCallBack(TsFileResource tsFileResource) {
        List<TsFileResource> upgradedResources = tsFileResource.getUpgradedResources();
        for (TsFileResource tsFileResource2 : upgradedResources) {
            long partitionId = tsFileResource2.getTimePartition();
            tsFileResource2.getDeviceToIndexMap().forEach((device, index) -> this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, (String)device, resource.getEndTime((int)index)));
        }
        this.insertLock.writeLock().lock();
        this.tsFileManagement.writeLock();
        try {
            if (tsFileResource.isSeq()) {
                this.tsFileManagement.addAll(upgradedResources, true);
                this.upgradeSeqFileList.remove(tsFileResource);
            } else {
                this.tsFileManagement.addAll(upgradedResources, false);
                this.upgradeUnseqFileList.remove(tsFileResource);
            }
        }
        finally {
            this.tsFileManagement.writeUnlock();
            this.insertLock.writeLock().unlock();
        }
        if (this.countUpgradeFiles() == 0) {
            for (Map.Entry entry : this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.entrySet()) {
                long timePartitionId = (Long)entry.getKey();
                Map latestFlushTimeForPartition = this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap());
                for (Map.Entry endTimeMap : ((Map)entry.getValue()).entrySet()) {
                    String device2 = (String)endTimeMap.getKey();
                    long endTime = (Long)endTimeMap.getValue();
                    if (latestFlushTimeForPartition.getOrDefault(device2, Long.MIN_VALUE) >= endTime) continue;
                    this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device2, endTime);
                }
            }
            if (StorageEngine.getInstance().countUpgradeFiles() == 0) {
                UpgradeSevice.getINSTANCE().stop();
            }
        }
    }

    public void merge(boolean fullMerge) {
        this.writeLock();
        try {
            this.tsFileManagement.merge(fullMerge, this.tsFileManagement.getTsFileList(true), this.tsFileManagement.getTsFileList(false), this.dataTTL);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void loadNewTsFileForSync(TsFileResource newTsFileResource) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock();
        this.tsFileManagement.writeLock();
        try {
            if (this.loadTsFileByType(LoadTsFileType.LOAD_SEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId)) {
                this.updateLatestTimeMap(newTsFileResource);
            }
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new LoadFileException(e);
        }
        finally {
            this.tsFileManagement.writeUnlock();
            this.writeUnlock();
        }
    }

    public void loadNewTsFile(TsFileResource newTsFileResource) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock();
        this.tsFileManagement.writeLock();
        try {
            List<TsFileResource> sequenceList = this.tsFileManagement.getTsFileList(true);
            int insertPos = this.findInsertionPosition(newTsFileResource, newFilePartitionId, sequenceList);
            if (insertPos == -2) {
                return;
            }
            if (insertPos == -3) {
                this.loadTsFileByType(LoadTsFileType.LOAD_UNSEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId);
            } else {
                String newFileName;
                if (!this.tsFileManagement.isEmpty(true) && !(newFileName = this.getFileNameForLoadingFile(tsfileToBeInserted.getName(), insertPos, newTsFileResource.getTimePartition(), sequenceList)).equals(tsfileToBeInserted.getName())) {
                    logger.info("Tsfile {} must be renamed to {} for loading into the sequence list.", (Object)tsfileToBeInserted.getName(), (Object)newFileName);
                    newTsFileResource.setFile(this.fsFactory.getFile(tsfileToBeInserted.getParentFile(), newFileName));
                }
                this.loadTsFileByType(LoadTsFileType.LOAD_SEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId);
            }
            this.updateLatestTimeMap(newTsFileResource);
            long partitionNum = newTsFileResource.getTimePartition();
            this.partitionDirectFileVersions.computeIfAbsent(partitionNum, p -> new HashSet()).addAll(newTsFileResource.getHistoricalVersions());
            this.updatePartitionFileVersion(partitionNum, Collections.max(newTsFileResource.getHistoricalVersions()));
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new LoadFileException(e);
        }
        finally {
            this.tsFileManagement.writeUnlock();
            this.writeUnlock();
        }
    }

    public void setPartitionFileVersionToMax(long partition, long version) {
        this.partitionMaxFileVersions.compute(partition, (prt, oldVer) -> this.computeMaxVersion((Long)oldVer, version));
    }

    private long computeMaxVersion(Long oldVersion, Long newVersion) {
        if (oldVersion == null) {
            return newVersion;
        }
        return Math.max(oldVersion, newVersion);
    }

    private int findInsertionPosition(TsFileResource newTsFileResource, long newFilePartitionId, List<TsFileResource> sequenceList) {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        int insertPos = -1;
        for (int i = 0; i < sequenceList.size(); ++i) {
            TsFileResource localFile = sequenceList.get(i);
            if (localFile.getTsFile().getName().equals(tsfileToBeInserted.getName())) {
                return -2;
            }
            long localPartitionId = Long.parseLong(localFile.getTsFile().getParentFile().getName());
            if (i == sequenceList.size() - 1 && localFile.areEndTimesEmpty() || newFilePartitionId > localPartitionId) continue;
            int fileComparison = this.compareTsFileDevices(newTsFileResource, localFile);
            switch (fileComparison) {
                case 0: {
                    return -3;
                }
                case -1: {
                    return i - 1;
                }
            }
            insertPos = i;
        }
        return insertPos;
    }

    private int compareTsFileDevices(TsFileResource fileA, TsFileResource fileB) {
        boolean hasPre = false;
        boolean hasSubsequence = false;
        for (String device : fileA.getDeviceToIndexMap().keySet()) {
            if (!fileB.getDeviceToIndexMap().containsKey(device)) continue;
            long startTimeA = fileA.getStartTime(device);
            long endTimeA = fileA.getEndTime(device);
            long startTimeB = fileB.getStartTime(device);
            long endTimeB = fileB.getEndTime(device);
            if (startTimeA > endTimeB) {
                hasPre = true;
                continue;
            }
            if (startTimeB > endTimeA) {
                hasSubsequence = true;
                continue;
            }
            return 0;
        }
        if (hasPre && hasSubsequence) {
            return 0;
        }
        if (!hasPre && hasSubsequence) {
            return -1;
        }
        return 1;
    }

    public void removeFullyOverlapFiles(TsFileResource resource) {
        this.writeLock();
        this.closeQueryLock.writeLock().lock();
        try {
            Iterator<TsFileResource> iterator = this.tsFileManagement.getIterator(true);
            this.removeFullyOverlapFiles(resource, iterator, true);
            iterator = this.tsFileManagement.getIterator(false);
            this.removeFullyOverlapFiles(resource, iterator, false);
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFullyOverlapFiles(TsFileResource newTsFile, Iterator<TsFileResource> iterator, boolean isSeq) {
        while (iterator.hasNext()) {
            TsFileResource existingTsFile = iterator.next();
            if (!newTsFile.getHistoricalVersions().containsAll(existingTsFile.getHistoricalVersions()) || newTsFile.getHistoricalVersions().equals(existingTsFile.getHistoricalVersions()) || !existingTsFile.tryWriteLock()) continue;
            try {
                this.removeFullyOverlapFile(existingTsFile, iterator, isSeq);
            }
            catch (Exception e) {
                logger.error("Something gets wrong while removing FullyOverlapFiles: {}", (Object)existingTsFile.getTsFile().getAbsolutePath(), (Object)e);
            }
            finally {
                existingTsFile.writeUnlock();
            }
        }
    }

    private void removeFullyOverlapFile(TsFileResource tsFileResource, Iterator<TsFileResource> iterator, boolean isSeq) {
        long timePartition;
        TreeMap<Long, TsFileProcessor> fileProcessorMap;
        TsFileProcessor tsFileProcessor;
        if (!tsFileResource.isClosed() && (tsFileProcessor = (TsFileProcessor)(fileProcessorMap = isSeq ? this.workSequenceTsFileProcessors : this.workUnsequenceTsFileProcessors).get(timePartition = tsFileResource.getTimePartition())) != null && tsFileProcessor.getTsFileResource() == tsFileResource) {
            tsFileProcessor.syncClose();
            fileProcessorMap.remove(timePartition);
        }
        this.tsFileManagement.remove(tsFileResource, isSeq);
        iterator.remove();
        tsFileResource.remove();
    }

    private String getFileNameForLoadingFile(String tsfileName, int insertIndex, long timePartitionId, List<TsFileResource> sequenceList) {
        long preTime;
        long currentTsFileTime = Long.parseLong(tsfileName.split("-")[0]);
        if (insertIndex == -1) {
            preTime = 0L;
        } else {
            String preName = sequenceList.get(insertIndex).getTsFile().getName();
            preTime = Long.parseLong(preName.split("-")[0]);
        }
        if (insertIndex == this.tsFileManagement.size(true) - 1) {
            return preTime < currentTsFileTime ? tsfileName : this.getNewTsFileName(timePartitionId);
        }
        String subsequenceName = sequenceList.get(insertIndex + 1).getTsFile().getName();
        long subsequenceTime = Long.parseLong(subsequenceName.split("-")[0]);
        long subsequenceVersion = Long.parseLong(subsequenceName.split("-")[1]);
        if (preTime < currentTsFileTime && currentTsFileTime < subsequenceTime) {
            return tsfileName;
        }
        return this.getNewTsFileName(preTime + (subsequenceTime - preTime >> 1), subsequenceVersion, 0);
    }

    private void updateLatestTimeMap(TsFileResource newTsFileResource) {
        for (Map.Entry<String, Integer> entry : newTsFileResource.getDeviceToIndexMap().entrySet()) {
            Map latestFlushTimeForPartition;
            String device = entry.getKey();
            int index = entry.getValue();
            long endTime = newTsFileResource.getEndTime(index);
            long timePartitionId = StorageEngine.getTimePartition(endTime);
            if (!this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).containsKey(device) || this.latestTimeForEachDevice.get(timePartitionId).get(device) < endTime) {
                this.latestTimeForEachDevice.get(timePartitionId).put(device, endTime);
            }
            if ((latestFlushTimeForPartition = (Map)this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap())).getOrDefault(device, Long.MIN_VALUE) < endTime) {
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device, endTime);
            }
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(device, Long.MIN_VALUE) >= endTime) continue;
            this.globalLatestFlushedTimeForEachDevice.put(device, endTime);
        }
    }

    private boolean loadTsFileByType(LoadTsFileType type, File syncedTsFile, TsFileResource tsFileResource, long filePartitionId) throws LoadFileException, DiskSpaceInsufficientException {
        File targetFile;
        switch (type) {
            case LOAD_UNSEQUENCE: {
                targetFile = this.fsFactory.getFile(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.storageGroupName + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.tsFileManagement.contains(tsFileResource, false)) {
                    logger.error("The file {} has already been loaded in unsequence list", (Object)tsFileResource);
                    return false;
                }
                this.tsFileManagement.add(tsFileResource, false);
                logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)syncedTsFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            case LOAD_SEQUENCE: {
                targetFile = this.fsFactory.getFile(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.storageGroupName + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.tsFileManagement.contains(tsFileResource, true)) {
                    logger.error("The file {} has already been loaded in sequence list", (Object)tsFileResource);
                    return false;
                }
                this.tsFileManagement.add(tsFileResource, true);
                logger.info("Load tsfile in sequence list, move file from {} to {}", (Object)syncedTsFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            default: {
                throw new LoadFileException(String.format("Unsupported type of loading tsfile : %s", new Object[]{type}));
            }
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            org.apache.commons.io.FileUtils.moveFile((File)syncedTsFile, (File)targetFile);
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading tsfile. Origin: {}, Target: {}", new Object[]{syncedTsFile.getAbsolutePath(), targetFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", syncedTsFile.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
        }
        File syncedResourceFile = this.fsFactory.getFile(syncedTsFile.getAbsolutePath() + ".resource");
        File targetResourceFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".resource");
        try {
            org.apache.commons.io.FileUtils.moveFile((File)syncedResourceFile, (File)targetResourceFile);
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading .resource file. Origin: {}, Target: {}", new Object[]{syncedResourceFile.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", syncedResourceFile.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e.getMessage()));
        }
        this.partitionDirectFileVersions.computeIfAbsent(filePartitionId, p -> new HashSet()).addAll(tsFileResource.getHistoricalVersions());
        if (!tsFileResource.getHistoricalVersions().isEmpty()) {
            this.updatePartitionFileVersion(filePartitionId, Collections.max(tsFileResource.getHistoricalVersions()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTsfile(File tsfieToBeDeleted) {
        TsFileResource tsFileResourceToBeDeleted;
        block9: {
            this.writeLock();
            this.tsFileManagement.writeLock();
            tsFileResourceToBeDeleted = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManagement.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = sequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeDeleted, true);
                    break;
                }
                if (tsFileResourceToBeDeleted != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManagement.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = unsequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeDeleted, false);
                    break;
                }
            }
            finally {
                this.tsFileManagement.writeUnlock();
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeDeleted == null) {
            return false;
        }
        tsFileResourceToBeDeleted.writeLock();
        try {
            tsFileResourceToBeDeleted.remove();
            logger.info("Delete tsfile {} successfully.", (Object)tsFileResourceToBeDeleted.getTsFile());
        }
        finally {
            tsFileResourceToBeDeleted.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkSequenceTsFileProcessors() {
        return this.workSequenceTsFileProcessors.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveTsfile(File fileToBeMoved, File targetDir) {
        TsFileResource tsFileResourceToBeMoved;
        block9: {
            this.writeLock();
            this.tsFileManagement.writeLock();
            tsFileResourceToBeMoved = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManagement.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(fileToBeMoved.getName())) continue;
                    tsFileResourceToBeMoved = sequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeMoved, true);
                    break;
                }
                if (tsFileResourceToBeMoved != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManagement.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(fileToBeMoved.getName())) continue;
                    tsFileResourceToBeMoved = unsequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeMoved, false);
                    break;
                }
            }
            finally {
                this.tsFileManagement.writeUnlock();
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeMoved == null) {
            return false;
        }
        tsFileResourceToBeMoved.writeLock();
        try {
            tsFileResourceToBeMoved.moveTo(targetDir);
            logger.info("Move tsfile {} to target dir {} successfully.", (Object)tsFileResourceToBeMoved.getTsFile(), (Object)targetDir.getPath());
        }
        finally {
            tsFileResourceToBeMoved.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkUnsequenceTsFileProcessors() {
        return this.workUnsequenceTsFileProcessors.values();
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
        this.checkFilesTTL();
    }

    public List<TsFileResource> getSequenceFileTreeSet() {
        return this.tsFileManagement.getTsFileList(true);
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.tsFileManagement.getTsFileList(false);
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public StorageGroupInfo getStorageGroupInfo() {
        return this.storageGroupInfo;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, long partitionNum) {
        long workingFileVersion;
        for (TsFileProcessor workSequenceTsFileProcessor : this.getWorkSequenceTsFileProcessors()) {
            workingFileVersion = workSequenceTsFileProcessor.getTsFileResource().getMaxVersion();
            if (!tsFileResource.getHistoricalVersions().contains(workingFileVersion)) continue;
            return false;
        }
        for (TsFileProcessor workUnsequenceTsFileProcessor : this.getWorkUnsequenceTsFileProcessors()) {
            workingFileVersion = workUnsequenceTsFileProcessor.getTsFileResource().getMaxVersion();
            if (!tsFileResource.getHistoricalVersions().contains(workingFileVersion)) continue;
            return false;
        }
        Set partitionFileVersions = this.partitionDirectFileVersions.getOrDefault(partitionNum, Collections.emptySet());
        logger.debug("FileVersions/PartitionVersions: {}/{}", tsFileResource.getHistoricalVersions(), partitionFileVersions);
        return partitionFileVersions.containsAll(tsFileResource.getHistoricalVersions());
    }

    public void removePartitions(TimePartitionFilter filter) {
        this.insertLock.writeLock().lock();
        this.tsFileManagement.writeLock();
        try {
            MergeManager.getINSTANCE().abortMerge(this.storageGroupName);
            this.removePartitions(filter, this.workSequenceTsFileProcessors.entrySet());
            this.removePartitions(filter, this.workUnsequenceTsFileProcessors.entrySet());
            this.removePartitions(filter, this.tsFileManagement.getIterator(true));
            this.removePartitions(filter, this.tsFileManagement.getIterator(false));
        }
        finally {
            this.insertLock.writeLock().unlock();
            this.tsFileManagement.writeUnlock();
        }
    }

    private void removePartitions(TimePartitionFilter filter, Set<Map.Entry<Long, TsFileProcessor>> processorEntrys) {
        Iterator<Map.Entry<Long, TsFileProcessor>> iterator = processorEntrys.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TsFileProcessor> longTsFileProcessorEntry = iterator.next();
            long partitionId = longTsFileProcessorEntry.getKey();
            TsFileProcessor processor = longTsFileProcessorEntry.getValue();
            if (!filter.satisfy(this.storageGroupName, partitionId)) continue;
            processor.syncClose();
            iterator.remove();
            logger.debug("{} is removed during deleting partitions", (Object)processor.getTsFileResource().getTsFilePath());
        }
    }

    private void removePartitions(TimePartitionFilter filter, Iterator<TsFileResource> iterator) {
        while (iterator.hasNext()) {
            TsFileResource tsFileResource = iterator.next();
            if (!filter.satisfy(this.storageGroupName, tsFileResource.getTimePartition())) continue;
            tsFileResource.remove();
            iterator.remove();
            logger.debug("{} is removed during deleting partitions", (Object)tsFileResource.getTsFilePath());
        }
    }

    public TsFileManagement getTsFileManagement() {
        return this.tsFileManagement;
    }

    public void setCustomCloseFileListeners(List<CloseFileListener> customCloseFileListeners) {
        this.customCloseFileListeners = customCloseFileListeners;
    }

    public void setCustomFlushListeners(List<FlushListener> customFlushListeners) {
        this.customFlushListeners = customFlushListeners;
    }

    @FunctionalInterface
    public static interface TimePartitionFilter {
        public boolean satisfy(String var1, long var2);
    }

    @FunctionalInterface
    public static interface CloseCompactionMergeCallBack {
        public void call();
    }

    @FunctionalInterface
    public static interface UpgradeTsFileResourceCallBack {
        public void call(TsFileResource var1);
    }

    @FunctionalInterface
    public static interface UpdateEndTimeCallBack {
        public boolean call(TsFileProcessor var1);
    }

    @FunctionalInterface
    public static interface CloseTsFileCallBack {
        public void call(TsFileProcessor var1) throws TsFileProcessorException, IOException;
    }

    private static enum LoadTsFileType {
        LOAD_SEQUENCE,
        LOAD_UNSEQUENCE;

    }
}

