/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.util.Objects;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.metadata.PartialPath;

public class Deletion
extends Modification {
    private long startTime;
    private long endTime;

    public Deletion(PartialPath path, long versionNum, long endTime) {
        super(Modification.Type.DELETION, path, versionNum);
        this.startTime = Long.MIN_VALUE;
        this.endTime = endTime;
    }

    public Deletion(PartialPath path, long versionNum, long startTime, long endTime) {
        super(Modification.Type.DELETION, path, versionNum);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long timestamp) {
        this.startTime = timestamp;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long timestamp) {
        this.endTime = timestamp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Deletion)) {
            return false;
        }
        Deletion del = (Deletion)obj;
        return super.equals(obj) && del.startTime == this.startTime && del.endTime == this.endTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startTime, this.endTime);
    }
}

