/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogger;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.MergeUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.BatchDataIterator;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger(CompactionUtils.class);
    private static final int MERGE_PAGE_POINT_NUM = IoTDBDescriptor.getInstance().getConfig().getMergePagePointNumberThreshold();

    private CompactionUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static Pair<ChunkMetadata, Chunk> readByAppendMerge(Map<TsFileSequenceReader, List<ChunkMetadata>> readerChunkMetadataMap) throws IOException {
        ChunkMetadata newChunkMetadata = null;
        Chunk newChunk = null;
        for (Map.Entry<TsFileSequenceReader, List<ChunkMetadata>> entry : readerChunkMetadataMap.entrySet()) {
            for (ChunkMetadata chunkMetadata : entry.getValue()) {
                Chunk chunk = entry.getKey().readMemChunk(chunkMetadata);
                if (newChunkMetadata == null) {
                    newChunkMetadata = chunkMetadata;
                    newChunk = chunk;
                    continue;
                }
                newChunkMetadata.mergeChunkMetadata(chunkMetadata);
                newChunk.mergeChunk(chunk);
            }
        }
        return new Pair(newChunkMetadata, newChunk);
    }

    private static long readByDeserializeMerge(Map<TsFileSequenceReader, List<ChunkMetadata>> readerChunkMetadataMap, long maxVersion, Map<Long, TimeValuePair> timeValuePairMap) throws IOException {
        for (Map.Entry<TsFileSequenceReader, List<ChunkMetadata>> entry : readerChunkMetadataMap.entrySet()) {
            TsFileSequenceReader reader = entry.getKey();
            List<ChunkMetadata> chunkMetadataList = entry.getValue();
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                maxVersion = Math.max(chunkMetadata.getVersion(), maxVersion);
                ChunkReaderByTimestamp chunkReader = new ChunkReaderByTimestamp(reader.readMemChunk(chunkMetadata));
                while (chunkReader.hasNextSatisfiedPage()) {
                    BatchDataIterator iPointReader = new BatchDataIterator(chunkReader.nextPageData());
                    while (iPointReader.hasNextTimeValuePair()) {
                        TimeValuePair timeValuePair = iPointReader.nextTimeValuePair();
                        timeValuePairMap.put(timeValuePair.getTimestamp(), timeValuePair);
                    }
                }
            }
        }
        return maxVersion;
    }

    private static long writeByAppendMerge(long maxVersion, String device, RateLimiter compactionWriteRateLimiter, Map<TsFileSequenceReader, List<ChunkMetadata>> readerChunkMetadatasMap, TsFileResource targetResource, RestorableTsFileIOWriter writer) throws IOException {
        Pair<ChunkMetadata, Chunk> chunkPair = CompactionUtils.readByAppendMerge(readerChunkMetadatasMap);
        ChunkMetadata newChunkMetadata = (ChunkMetadata)chunkPair.left;
        Chunk newChunk = (Chunk)chunkPair.right;
        if (newChunkMetadata != null && newChunk != null) {
            maxVersion = Math.max(newChunkMetadata.getVersion(), maxVersion);
            MergeManager.mergeRateLimiterAcquire(compactionWriteRateLimiter, (long)newChunk.getHeader().getDataSize() + (long)newChunk.getData().position());
            writer.writeChunk(newChunk, newChunkMetadata);
            targetResource.updateStartTime(device, newChunkMetadata.getStartTime());
            targetResource.updateEndTime(device, newChunkMetadata.getEndTime());
        }
        return maxVersion;
    }

    private static long writeByDeserializeMerge(long maxVersion, String device, RateLimiter compactionRateLimiter, Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>> entry, TsFileResource targetResource, RestorableTsFileIOWriter writer) throws IOException {
        ChunkWriterImpl chunkWriter;
        TreeMap<Long, TimeValuePair> timeValuePairMap = new TreeMap<Long, TimeValuePair>();
        maxVersion = CompactionUtils.readByDeserializeMerge(entry.getValue(), maxVersion, timeValuePairMap);
        Iterator<List<ChunkMetadata>> chunkMetadataListIterator = entry.getValue().values().iterator();
        if (!chunkMetadataListIterator.hasNext()) {
            return maxVersion;
        }
        List<ChunkMetadata> chunkMetadataList = chunkMetadataListIterator.next();
        if (chunkMetadataList.isEmpty()) {
            return maxVersion;
        }
        try {
            chunkWriter = new ChunkWriterImpl(IoTDB.metaManager.getSeriesSchema(new PartialPath(device), entry.getKey()));
        }
        catch (MetadataException e) {
            throw new IOException(e);
        }
        for (TimeValuePair timeValuePair : timeValuePairMap.values()) {
            MergeUtils.writeTVPair(timeValuePair, (IChunkWriter)chunkWriter);
            targetResource.updateStartTime(device, timeValuePair.getTimestamp());
            targetResource.updateEndTime(device, timeValuePair.getTimestamp());
        }
        MergeManager.mergeRateLimiterAcquire(compactionRateLimiter, chunkWriter.getCurrentChunkSize());
        chunkWriter.writeToFileWriter((TsFileIOWriter)writer);
        return maxVersion;
    }

    private static Set<String> getTsFileDevicesSet(List<TsFileResource> subLevelResources, Map<String, TsFileSequenceReader> tsFileSequenceReaderMap, String storageGroup) throws IOException {
        HashSet<String> tsFileDevicesSet = new HashSet<String>();
        for (TsFileResource levelResource : subLevelResources) {
            TsFileSequenceReader reader = CompactionUtils.buildReaderFromTsFileResource(levelResource, tsFileSequenceReaderMap, storageGroup);
            if (reader == null) continue;
            tsFileDevicesSet.addAll(reader.getAllDevices());
        }
        return tsFileDevicesSet;
    }

    public static void merge(TsFileResource targetResource, List<TsFileResource> tsFileResources, String storageGroup, CompactionLogger compactionLogger, Set<String> devices, boolean sequence) throws IOException {
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(targetResource.getTsFile());
        HashMap<String, TsFileSequenceReader> tsFileSequenceReaderMap = new HashMap<String, TsFileSequenceReader>();
        RateLimiter compactionWriteRateLimiter = MergeManager.getINSTANCE().getMergeWriteRateLimiter();
        Set<String> tsFileDevicesMap = CompactionUtils.getTsFileDevicesSet(tsFileResources, tsFileSequenceReaderMap, storageGroup);
        for (String device : tsFileDevicesMap) {
            long maxVersion;
            if (devices.contains(device)) continue;
            writer.startChunkGroup(device);
            HashMap measurementChunkMetadataMap = new HashMap();
            for (TsFileResource levelResource : tsFileResources) {
                TsFileSequenceReader reader = CompactionUtils.buildReaderFromTsFileResource(levelResource, tsFileSequenceReaderMap, storageGroup);
                if (reader == null) continue;
                Map map = reader.readChunkMetadataInDevice(device);
                for (Map.Entry entry : map.entrySet()) {
                    for (ChunkMetadata chunkMetadata : (List)entry.getValue()) {
                        String measurementUid = chunkMetadata.getMeasurementUid();
                        Map readerChunkMetadataMap = measurementChunkMetadataMap.containsKey(measurementUid) ? (Map)measurementChunkMetadataMap.get(measurementUid) : new LinkedHashMap();
                        List chunkMetadataList = readerChunkMetadataMap.containsKey(reader) ? (List)readerChunkMetadataMap.get(reader) : new ArrayList();
                        chunkMetadataList.add(chunkMetadata);
                        readerChunkMetadataMap.put(reader, chunkMetadataList);
                        measurementChunkMetadataMap.put(chunkMetadata.getMeasurementUid(), readerChunkMetadataMap);
                    }
                }
            }
            if (!sequence) {
                maxVersion = Long.MIN_VALUE;
                for (Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>> entry : measurementChunkMetadataMap.entrySet()) {
                    maxVersion = CompactionUtils.writeByDeserializeMerge(maxVersion, device, compactionWriteRateLimiter, entry, targetResource, writer);
                }
                writer.endChunkGroup();
                writer.writeVersion(maxVersion);
            } else {
                maxVersion = Long.MIN_VALUE;
                for (Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>> entry : measurementChunkMetadataMap.entrySet()) {
                    Map readerChunkMetadatasMap = (Map)entry.getValue();
                    boolean isPageEnoughLarge = true;
                    block6: for (List chunkMetadatas : readerChunkMetadatasMap.values()) {
                        for (ChunkMetadata chunkMetadata : chunkMetadatas) {
                            if (chunkMetadata.getNumOfPoints() >= (long)MERGE_PAGE_POINT_NUM) continue;
                            isPageEnoughLarge = false;
                            continue block6;
                        }
                    }
                    if (isPageEnoughLarge) {
                        logger.debug("{} [Compaction] page enough large, use append merge", (Object)storageGroup);
                        maxVersion = CompactionUtils.writeByAppendMerge(maxVersion, device, compactionWriteRateLimiter, readerChunkMetadatasMap, targetResource, writer);
                        continue;
                    }
                    logger.debug("{} [Compaction] page too small, use deserialize merge", (Object)storageGroup);
                    maxVersion = CompactionUtils.writeByDeserializeMerge(maxVersion, device, compactionWriteRateLimiter, entry, targetResource, writer);
                }
                writer.endChunkGroup();
                writer.writeVersion(maxVersion);
            }
            if (compactionLogger == null) continue;
            compactionLogger.logDevice(device, writer.getPos());
        }
        for (TsFileSequenceReader reader : tsFileSequenceReaderMap.values()) {
            reader.close();
        }
        HashSet<Long> historicalVersions = new HashSet<Long>();
        for (TsFileResource tsFileResource : tsFileResources) {
            historicalVersions.addAll(tsFileResource.getHistoricalVersions());
        }
        targetResource.setHistoricalVersions(historicalVersions);
        targetResource.serialize();
        writer.endFile();
        targetResource.close();
    }

    private static TsFileSequenceReader buildReaderFromTsFileResource(TsFileResource levelResource, Map<String, TsFileSequenceReader> tsFileSequenceReaderMap, String storageGroup) {
        return tsFileSequenceReaderMap.computeIfAbsent(levelResource.getTsFile().getAbsolutePath(), path -> {
            try {
                if (levelResource.getTsFile().exists()) {
                    return new TsFileSequenceReader(path);
                }
                logger.info("{} tsfile does not exist", path);
                return null;
            }
            catch (IOException e) {
                logger.error("Storage group {}, flush recover meets error. reader create failed.", (Object)storageGroup, (Object)e);
                return null;
            }
        });
    }
}

