/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.no;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCompactionTsFileManagement
extends TsFileManagement {
    private static final Logger logger = LoggerFactory.getLogger(NoCompactionTsFileManagement.class);
    private TreeSet<TsFileResource> sequenceFileTreeSet = new TreeSet((o1, o2) -> {
        int rangeCompare = Long.compare(Long.parseLong(o1.getTsFile().getParentFile().getName()), Long.parseLong(o2.getTsFile().getParentFile().getName()));
        return rangeCompare == 0 ? NoCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile()) : rangeCompare;
    });
    private List<TsFileResource> unSequenceFileList = new ArrayList<TsFileResource>();

    public NoCompactionTsFileManagement(String storageGroupName, String storageGroupDir) {
        super(storageGroupName, storageGroupDir);
    }

    @Override
    public List<TsFileResource> getStableTsFileList(boolean sequence) {
        return this.getTsFileList(sequence);
    }

    @Override
    public List<TsFileResource> getTsFileList(boolean sequence) {
        if (sequence) {
            return new ArrayList<TsFileResource>(this.sequenceFileTreeSet);
        }
        return this.unSequenceFileList;
    }

    @Override
    public Iterator<TsFileResource> getIterator(boolean sequence) {
        return this.getTsFileList(sequence).iterator();
    }

    @Override
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            this.sequenceFileTreeSet.remove(tsFileResource);
        } else {
            this.unSequenceFileList.remove(tsFileResource);
        }
    }

    @Override
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        if (sequence) {
            this.sequenceFileTreeSet.removeAll(tsFileResourceList);
        } else {
            this.unSequenceFileList.removeAll(tsFileResourceList);
        }
    }

    @Override
    public void add(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            this.sequenceFileTreeSet.add(tsFileResource);
        } else {
            this.unSequenceFileList.add(tsFileResource);
        }
    }

    @Override
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        if (sequence) {
            this.sequenceFileTreeSet.addAll(tsFileResourceList);
        } else {
            this.unSequenceFileList.addAll(tsFileResourceList);
        }
    }

    @Override
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            return this.sequenceFileTreeSet.contains(tsFileResource);
        }
        return this.unSequenceFileList.contains(tsFileResource);
    }

    @Override
    public void clear() {
        this.sequenceFileTreeSet.clear();
        this.unSequenceFileList.clear();
    }

    @Override
    public boolean isEmpty(boolean sequence) {
        if (sequence) {
            return this.sequenceFileTreeSet.isEmpty();
        }
        return this.unSequenceFileList.isEmpty();
    }

    @Override
    public int size(boolean sequence) {
        if (sequence) {
            return this.sequenceFileTreeSet.size();
        }
        return this.unSequenceFileList.size();
    }

    @Override
    public void recover() {
        logger.info("{} no recover logic", (Object)this.storageGroupName);
    }

    @Override
    public void forkCurrentFileList(long timePartition) {
        logger.info("{} do not need fork", (Object)this.storageGroupName);
    }

    @Override
    protected void merge(long timePartition) {
        logger.info("{} no merge logic", (Object)this.storageGroupName);
    }
}

