/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.AbstractCli;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.tool.AbstractCsvTool;
import org.apache.thrift.TException;

public class ExportCsv
extends AbstractCsvTool {
    private static final String TARGET_DIR_ARGS = "td";
    private static final String TARGET_DIR_NAME = "targetDirectory";
    private static final String TARGET_FILE_ARGS = "f";
    private static final String TARGET_FILE_NAME = "targetFile";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sqlfile";
    private static final String TSFILEDB_CLI_PREFIX = "ExportCsv";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static String targetFile = "dump";
    private static String targetDirectory;
    private static final int EXPORT_PER_LINE_COUNT = 10000;
    private static String TIMESTAMP_PRECISION;
    private static List<Integer> typeList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SQLException {
        CommandLine commandLine;
        Options options = ExportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setExpandEvents(false);
        try {
            ExportCsv.parseBasicParams(commandLine, reader);
            ExportCsv.parseSpecialParams(commandLine);
            if (!ExportCsv.checkTimeFormat()) {
                return;
            }
            Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
            connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);
            ExportCsv.setTimeZone();
            if (sqlFile == null) {
                String sql = reader.readLine("ExportCsv> please input query: ");
                String[] values = sql.trim().split(";");
                for (int i = 0; i < values.length; ++i) {
                    ExportCsv.dumpResult(values[i], i);
                }
            } else {
                ExportCsv.dumpFromSqlFile(sqlFile);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Failed to export data because cannot find IoTDB JDBC Driver, please check whether you have imported driver or not: " + e.getMessage());
        }
        catch (TException e) {
            System.out.println("Encounter an error when connecting to server, because " + e.getMessage());
        }
        catch (SQLException e) {
            System.out.println("Encounter an error when exporting data, error is: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Failed to operate on file, because " + e.getMessage());
        }
        catch (ArgsErrorException e) {
            System.out.println("Invalid args: " + e.getMessage());
        }
        finally {
            reader.close();
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportCsv.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if ((timeFormat = commandLine.getOptionValue("tf")) == null) {
            timeFormat = "default";
        }
        timeZoneID = commandLine.getOptionValue("tz");
        if (!targetDirectory.endsWith(File.separator)) {
            targetDirectory = targetDirectory + File.separator;
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        Option opHost = Option.builder((String)"h").longOpt("host").required().argName("host").hasArg().desc("Host Name (required)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)"p").longOpt("port").required().argName("port").hasArg().desc("Port (required)").build();
        options.addOption(opPort);
        Option opUsername = Option.builder((String)"u").longOpt("username").required().argName("username").hasArg().desc("Username (required)").build();
        options.addOption(opUsername);
        Option opPassword = Option.builder((String)"pw").longOpt("password").optionalArg(true).argName("password").hasArg().desc("Password (optional)").build();
        options.addOption(opPassword);
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().argName(TARGET_DIR_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(targetFileName);
        Option opSqlFile = Option.builder((String)SQL_FILE_ARGS).argName(SQL_FILE_NAME).hasArg().desc("SQL File Path (optional)").build();
        options.addOption(opSqlFile);
        Option opTimeFormat = Option.builder((String)"tf").argName("timeformat").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd\\ HH:mm:ss, default ISO8601 (optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int index = 0;
            while ((sql = reader.readLine()) != null) {
                try {
                    ExportCsv.dumpResult(sql, index);
                }
                catch (SQLException e) {
                    System.out.println("Cannot dump data for statement " + sql + ", because : " + e.getMessage());
                }
                ++index;
            }
        }
    }

    private static void dumpResult(String sql, int index) throws SQLException {
        String path = targetDirectory + targetFile + index + ".csv";
        File tf = new File(path);
        try {
            if (!tf.exists() && !tf.createNewFile()) {
                System.out.println("Could not create target file for sql statement: " + sql);
                return;
            }
        }
        catch (IOException e) {
            System.out.println("Cannot create dump file " + path + "because: " + e.getMessage());
            return;
        }
        System.out.println("Start to export data from sql statement: " + sql);
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(sql);
             BufferedWriter bw = new BufferedWriter(new FileWriter(tf));){
            ResultSetMetaData metadata = rs.getMetaData();
            long startTime = System.currentTimeMillis();
            int count = metadata.getColumnCount();
            ExportCsv.writeMetadata(bw, count, metadata);
            int line = ExportCsv.writeResultSet(rs, bw, count);
            System.out.println(String.format("Statement [%s] has dumped to file %s successfully! It costs %dms to export %d lines.", sql, path, System.currentTimeMillis() - startTime, line));
        }
        catch (IOException e) {
            System.out.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private static void writeMetadata(BufferedWriter bw, int count, ResultSetMetaData metadata) throws SQLException, IOException {
        for (int i = 1; i <= count; ++i) {
            if (i < count) {
                bw.write(metadata.getColumnLabel(i) + ",");
            } else {
                bw.write(metadata.getColumnLabel(i) + "\n");
            }
            typeList.add(metadata.getColumnType(i));
        }
    }

    private static int writeResultSet(ResultSet rs, BufferedWriter bw, int count) throws SQLException, IOException {
        int line = 0;
        long timestamp = System.currentTimeMillis();
        while (rs.next()) {
            if (rs.getString(1) == null || "null".equalsIgnoreCase(rs.getString(1))) {
                bw.write(",");
            } else {
                ExportCsv.writeTime(rs, bw);
                ExportCsv.writeValue(rs, count, bw);
            }
            if (++line % 10000 != 0) continue;
            long tmp = System.currentTimeMillis();
            System.out.println(String.format("%d lines have been exported, it takes %dms", line, tmp - timestamp));
            timestamp = tmp;
        }
        return line;
    }

    private static void writeTime(ResultSet rs, BufferedWriter bw) throws SQLException, IOException {
        switch (timeFormat) {
            case "default": {
                long timestamp = rs.getLong(1);
                String str = AbstractCli.parseLongToDateWithPrecision(DateTimeFormatter.ISO_OFFSET_DATE_TIME, timestamp, zoneId, TIMESTAMP_PRECISION);
                bw.write(str + ",");
                break;
            }
            case "timestamp": 
            case "long": 
            case "nubmer": {
                bw.write(rs.getLong(1) + ",");
                break;
            }
            default: {
                ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(rs.getLong(1)), zoneId);
                bw.write(dateTime.format(DateTimeFormatter.ofPattern(timeFormat)) + ",");
            }
        }
    }

    private static void writeValue(ResultSet rs, int count, BufferedWriter bw) throws SQLException, IOException {
        for (int j = 2; j <= count; ++j) {
            if (j < count) {
                if ("null".equals(rs.getString(j))) {
                    bw.write(",");
                    continue;
                }
                if (typeList.get(j - 1) == 12) {
                    bw.write("'" + rs.getString(j) + "',");
                    continue;
                }
                bw.write(rs.getString(j) + ",");
                continue;
            }
            if ("null".equals(rs.getString(j))) {
                bw.write("\n");
                continue;
            }
            if (typeList.get(j - 1) == 12) {
                bw.write("'" + rs.getString(j) + "'\n");
                continue;
            }
            bw.write(rs.getString(j) + "\n");
        }
    }

    static {
        TIMESTAMP_PRECISION = "ms";
        typeList = new ArrayList<Integer>();
    }
}

