/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.AbstractCli;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.TException;

public class Cli
extends AbstractCli {
    private static CommandLine commandLine;

    public static void main(String[] args) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Options options = Cli.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(88);
        commandLine = null;
        if (args == null || args.length == 0) {
            Cli.println("Require more params input, eg. ./start-cli.sh(start-cli.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            Cli.println("For more information, please check the following hint.");
            hf.printHelp("./start-cli.sh(start-cli.bat if Windows)", options, true);
            return;
        }
        Cli.init();
        String[] newArgs = Cli.removePasswordArgs(args);
        String[] newArgs2 = Cli.processExecuteArgs(newArgs);
        boolean continues = Cli.parseCommandLine(options, newArgs2, hf);
        if (!continues) {
            return;
        }
        Cli.serve();
    }

    private static boolean parseCommandLine(Options options, String[] newArgs, HelpFormatter hf) {
        try {
            DefaultParser parser = new DefaultParser();
            commandLine = parser.parse(options, newArgs);
            if (commandLine.hasOption("help")) {
                hf.printHelp("./start-cli.sh(start-cli.bat if Windows)", options, true);
                return false;
            }
            if (commandLine.hasOption("c")) {
                Config.rpcThriftCompressionEnable = true;
            }
            if (commandLine.hasOption("disableISO8601")) {
                Cli.setTimeFormat("long");
            }
            if (commandLine.hasOption("maxPRC")) {
                Cli.setMaxDisplayNumber(commandLine.getOptionValue("maxPRC"));
            }
        }
        catch (ParseException e) {
            Cli.println("Require more params input, eg. ./start-cli.sh(start-cli.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            Cli.println("For more information, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            return false;
        }
        catch (NumberFormatException e) {
            Cli.println("IoTDB> error format of max print row count, it should be a number and greater than 0");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static void serve() {
        try {
            reader = new ConsoleReader();
            var1_3 = null;
            try {
                block33: {
                    block34: {
                        reader.setExpandEvents(false);
                        Cli.host = Cli.checkRequiredArg("h", "host", Cli.commandLine, false, Cli.host);
                        Cli.port = Cli.checkRequiredArg("p", "port", Cli.commandLine, false, Cli.port);
                        Cli.username = Cli.checkRequiredArg("u", "username", Cli.commandLine, true, null);
                        Cli.password = Cli.commandLine.getOptionValue("pw");
                        if (Cli.password == null) {
                            Cli.password = reader.readLine("please input your password:", Character.valueOf('\u0000'));
                        }
                        if (!Cli.hasExecuteSQL) ** GOTO lbl53
                        connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + Cli.host + ":" + Cli.port + "/", Cli.username, Cli.password);
                        var3_8 = null;
                        Cli.properties = connection.getServerProperties();
                        Cli.AGGREGRATE_TIME_LIST.addAll(Cli.properties.getSupportedTimeAggregationOperations());
                        Cli.processCommand(Cli.execute, connection);
                        if (connection == null) break block33;
                        if (var3_8 == null) break block34;
                        try {
                            connection.close();
                        }
                        catch (Throwable var4_9) {
                            var3_8.addSuppressed(var4_9);
                        }
                        break block33;
                    }
                    connection.close();
                }
                return;
                catch (Throwable var4_11) {
                    try {
                        try {
                            try {
                                var3_8 = var4_11;
                                throw var4_11;
                            }
                            catch (Throwable var5_12) {
                                if (connection != null) {
                                    if (var3_8 != null) {
                                        try {
                                            connection.close();
                                        }
                                        catch (Throwable var6_13) {
                                            var3_8.addSuppressed(var6_13);
                                        }
                                    } else {
                                        connection.close();
                                    }
                                }
                                throw var5_12;
                            }
                        }
                        catch (SQLException e) {
                            Cli.println("IoTDB> can't execute sql because" + e.getMessage());
                        }
lbl53:
                        // 2 sources

                        Cli.receiveCommands(reader);
                    }
                    catch (Throwable var2_7) {
                        var1_3 = var2_7;
                        throw var2_7;
                    }
                    catch (Throwable var7_14) {
                        throw var7_14;
                    }
                }
            }
            finally {
                if (reader != null) {
                    if (var1_3 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var4_10) {
                            var1_3.addSuppressed(var4_10);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (ArgsErrorException e) {
            Cli.println("IoTDB> input params error because" + e.getMessage());
        }
        catch (Exception e) {
            Cli.println("IoTDB> exit cli with error " + e.getMessage());
        }
    }

    private static void receiveCommands(ConsoleReader reader) throws TException, IOException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);){
            String s;
            boolean continues;
            properties = connection.getServerProperties();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            TIMESTAMP_PRECISION = properties.getTimestampPrecision();
            Cli.echoStarting();
            Cli.displayLogo(properties.getVersion());
            Cli.println("IoTDB> login successfully");
            while (continues = Cli.processCommand(s = reader.readLine("IoTDB> ", null), connection)) {
            }
        }
        catch (SQLException e) {
            Cli.println(String.format("%s> %s Host is %s, port is %s.", "IoTDB", e.getMessage(), host, port));
        }
    }
}

