/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.iotdb.jdbc.IoTDBDataSource;
import org.apache.iotdb.jdbc.IoTDBDriver;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataSourceFactory
implements DataSourceFactory {
    private final Logger logger = LoggerFactory.getLogger(IoTDBDataSourceFactory.class);

    public DataSource createDataSource(Properties properties) throws SQLException {
        IoTDBDataSource ds = new IoTDBDataSource();
        this.setProperties(ds, properties);
        return ds;
    }

    public void setProperties(IoTDBDataSource ds, Properties prop) {
        Properties properties = (Properties)prop.clone();
        String url = (String)properties.remove("url");
        if (url != null) {
            ds.setUrl(url);
            this.logger.info("URL set {}", (Object)url);
        }
        String user = (String)properties.remove("user");
        ds.setUser(user);
        this.logger.info("User set {}", (Object)user);
        String password = (String)properties.remove("password");
        ds.setPassword(password);
        this.logger.info("Password set {}", (Object)password);
        this.logger.info("Remaining properties {}", (Object)properties.size());
        if (!properties.isEmpty()) {
            BeanConfig.configure((Object)ds, (Properties)properties);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        return null;
    }

    public XADataSource createXADataSource(Properties properties) throws SQLException {
        return null;
    }

    public Driver createDriver(Properties properties) throws SQLException {
        return new IoTDBDriver();
    }
}

