/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.Binary;

public class CommonUtils {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    public static final int MAX_EXECUTOR_POOL_SIZE = Math.max(100, CommonUtils.getCpuCores() * 5);

    private CommonUtils() {
    }

    public static int getJdkVersion() {
        String[] javaVersionElements = System.getProperty("java.version").split("\\.");
        if (Integer.parseInt(javaVersionElements[0]) == 1) {
            return Integer.parseInt(javaVersionElements[1]);
        }
        return Integer.parseInt(javaVersionElements[0]);
    }

    public static long getUsableSpace(String dir) {
        return FSFactoryProducer.getFSFactory().getFile(dir).getFreeSpace();
    }

    public static boolean hasSpace(String dir) {
        return CommonUtils.getUsableSpace(dir) > 0L;
    }

    public static long getOccupiedSpace(String folderPath) throws IOException {
        Path folder = Paths.get(folderPath, new String[0]);
        try (Stream<Path> s = Files.walk(folder, new FileVisitOption[0]);){
            long l = s.filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
            return l;
        }
    }

    public static Object parseValue(TSDataType dataType, String value) throws QueryProcessException {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    return CommonUtils.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TEXT: {
                    if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
                        if (value.length() == 1) {
                            return new Binary(value);
                        }
                        return new Binary(value.substring(1, value.length() - 1));
                    }
                    return new Binary(value);
                }
            }
            throw new QueryProcessException("Unsupported data type:" + dataType);
        }
        catch (NumberFormatException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    public static Object parseValueForTest(TSDataType dataType, String value) throws QueryProcessException {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    return CommonUtils.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TEXT: {
                    return new Binary(value);
                }
            }
            throw new QueryProcessException("Unsupported data type:" + dataType);
        }
        catch (NumberFormatException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    private static boolean parseBoolean(String value) throws QueryProcessException {
        if ("0".equals(value = value.toLowerCase()) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new QueryProcessException("The BOOLEAN should be true/TRUE, false/FALSE or 0/1");
    }

    public static int getCpuCores() {
        return CPUS;
    }

    public static int getMaxExecutorPoolSize() {
        return MAX_EXECUTOR_POOL_SIZE;
    }
}

