/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateMultiTimeSeriesPlan
extends PhysicalPlan {
    private List<PartialPath> paths;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> alias = null;
    private List<Map<String, String>> props = null;
    private List<Map<String, String>> tags = null;
    private List<Map<String, String>> attributes = null;
    private Map<Integer, Exception> results = new HashMap<Integer, Exception>();
    private List<Integer> indexes;

    public CreateMultiTimeSeriesPlan() {
        super(false, Operator.OperatorType.CREATE_MULTI_TIMESERIES);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public void setAlias(List<String> alias) {
        this.alias = alias;
    }

    public List<Map<String, String>> getProps() {
        return this.props;
    }

    public void setProps(List<Map<String, String>> props) {
        this.props = props;
    }

    public List<Map<String, String>> getTags() {
        return this.tags;
    }

    public void setTags(List<Map<String, String>> tags) {
        this.tags = tags;
    }

    public List<Map<String, String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Map<String, String>> attributes) {
        this.attributes = attributes;
    }

    public List<Integer> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Integer> indexes) {
        this.indexes = indexes;
    }

    public Map<Integer, Exception> getResults() {
        return this.results;
    }

    public void setResults(Map<Integer, Exception> results) {
        this.results = results;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.MULTI_CREATE_TIMESERIES.ordinal();
        stream.write(type);
        stream.writeInt(this.paths.size());
        for (PartialPath partialPath : this.paths) {
            this.putString(stream, partialPath.getFullPath());
        }
        for (TSDataType tSDataType : this.dataTypes) {
            stream.write(tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            stream.write(tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            stream.write(compressionType.ordinal());
        }
        if (this.alias != null) {
            stream.write(1);
            for (String string : this.alias) {
                this.putString(stream, string);
            }
        } else {
            stream.write(0);
        }
        if (this.props != null) {
            stream.write(1);
            for (Map map : this.props) {
                ReadWriteIOUtils.write((Map)map, (DataOutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        if (this.tags != null) {
            stream.write(1);
            for (Map map : this.tags) {
                ReadWriteIOUtils.write((Map)map, (DataOutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        if (this.attributes != null) {
            stream.write(1);
            for (Map map : this.attributes) {
                ReadWriteIOUtils.write((Map)map, (DataOutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.MULTI_CREATE_TIMESERIES.ordinal();
        buffer.put((byte)type);
        buffer.putInt(this.paths.size());
        for (PartialPath partialPath : this.paths) {
            this.putString(buffer, partialPath.getFullPath());
        }
        for (TSDataType tSDataType : this.dataTypes) {
            buffer.put((byte)tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            buffer.put((byte)tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            buffer.put((byte)compressionType.ordinal());
        }
        if (this.alias != null) {
            buffer.put((byte)1);
            for (String string : this.alias) {
                this.putString(buffer, string);
            }
        } else {
            buffer.put((byte)0);
        }
        if (this.props != null) {
            buffer.put((byte)1);
            for (Map map : this.props) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        if (this.tags != null) {
            buffer.put((byte)1);
            for (Map map : this.tags) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        if (this.attributes != null) {
            buffer.put((byte)1);
            for (Map map : this.attributes) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int i;
        int totalSize = buffer.getInt();
        this.paths = new ArrayList<PartialPath>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.paths.add(new PartialPath(this.readString(buffer)));
        }
        this.dataTypes = new ArrayList<TSDataType>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.dataTypes.add(TSDataType.values()[buffer.get()]);
        }
        this.encodings = new ArrayList<TSEncoding>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.encodings.add(TSEncoding.values()[buffer.get()]);
        }
        if (buffer.get() == 1) {
            this.alias = new ArrayList<String>(totalSize);
            for (i = 0; i < totalSize; ++i) {
                this.alias.add(this.readString(buffer));
            }
        }
        if (buffer.get() == 1) {
            this.props = new ArrayList<Map<String, String>>(totalSize);
            for (i = 0; i < totalSize; ++i) {
                this.props.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
            }
        }
        if (buffer.get() == 1) {
            this.tags = new ArrayList<Map<String, String>>(totalSize);
            for (i = 0; i < totalSize; ++i) {
                this.tags.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
            }
        }
        if (buffer.get() == 1) {
            this.attributes = new ArrayList<Map<String, String>>(totalSize);
            for (i = 0; i < totalSize; ++i) {
                this.attributes.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
            }
        }
        this.index = buffer.getLong();
    }
}

