/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.common.cache.Accountable;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class Chunk
implements Accountable {
    private ChunkHeader chunkHeader;
    private ByteBuffer chunkData;
    private List<TimeRange> deleteIntervalList;
    private long ramSize;

    public Chunk(ChunkHeader header, ByteBuffer buffer, List<TimeRange> deleteIntervalList) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.deleteIntervalList = deleteIntervalList;
    }

    public ChunkHeader getHeader() {
        return this.chunkHeader;
    }

    public ByteBuffer getData() {
        return this.chunkData;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public void mergeChunk(Chunk chunk) {
        this.chunkHeader.mergeChunkHeader(chunk.chunkHeader);
        ByteBuffer newChunkData = ByteBuffer.allocate(this.chunkData.array().length + chunk.chunkData.array().length);
        newChunkData.put(this.chunkData.array());
        newChunkData.put(chunk.chunkData.array());
        this.chunkData = newChunkData;
    }

    @Override
    public void setRamSize(long size) {
        this.ramSize = size;
    }

    @Override
    public long getRamSize() {
        return this.ramSize;
    }
}

