/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.BatchDataIterator;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class BatchData
implements Serializable {
    private static final long serialVersionUID = -4620310601188394839L;
    private static final int capacityThreshold = 1000;
    protected int capacity = 16;
    protected TSDataType dataType;
    protected int readCurListIndex;
    protected int readCurArrayIndex;
    protected int writeCurListIndex;
    protected int writeCurArrayIndex;
    private int count;
    private List<long[]> timeRet;
    private List<boolean[]> booleanRet;
    private List<int[]> intRet;
    private List<long[]> longRet;
    private List<float[]> floatRet;
    private List<double[]> doubleRet;
    private List<Binary[]> binaryRet;

    public BatchData() {
        this.dataType = null;
    }

    public BatchData(TSDataType type) {
        this.init(type);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean hasCurrent() {
        if (this.readCurListIndex == this.writeCurListIndex) {
            return this.readCurArrayIndex < this.writeCurArrayIndex;
        }
        return this.readCurListIndex < this.writeCurListIndex && this.readCurArrayIndex < this.capacity;
    }

    public void next() {
        ++this.readCurArrayIndex;
        if (this.readCurArrayIndex == this.capacity) {
            this.readCurArrayIndex = 0;
            ++this.readCurListIndex;
        }
    }

    public long currentTime() {
        return this.timeRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public Object currentValue() {
        switch (this.dataType) {
            case INT32: {
                return this.getInt();
            }
            case INT64: {
                return this.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case BOOLEAN: {
                return this.getBoolean();
            }
            case TEXT: {
                return this.getBinary();
            }
        }
        return null;
    }

    public TsPrimitiveType currentTsPrimitiveType() {
        switch (this.dataType) {
            case INT32: {
                return new TsPrimitiveType.TsInt(this.getInt());
            }
            case INT64: {
                return new TsPrimitiveType.TsLong(this.getLong());
            }
            case FLOAT: {
                return new TsPrimitiveType.TsFloat(this.getFloat());
            }
            case DOUBLE: {
                return new TsPrimitiveType.TsDouble(this.getDouble());
            }
            case BOOLEAN: {
                return new TsPrimitiveType.TsBoolean(this.getBoolean());
            }
            case TEXT: {
                return new TsPrimitiveType.TsBinary(this.getBinary());
            }
        }
        return null;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void init(TSDataType type) {
        this.dataType = type;
        this.readCurListIndex = 0;
        this.readCurArrayIndex = 0;
        this.writeCurListIndex = 0;
        this.writeCurArrayIndex = 0;
        this.timeRet = new ArrayList<long[]>();
        this.timeRet.add(new long[this.capacity]);
        this.count = 0;
        switch (this.dataType) {
            case BOOLEAN: {
                this.booleanRet = new ArrayList<boolean[]>();
                this.booleanRet.add(new boolean[this.capacity]);
                break;
            }
            case INT32: {
                this.intRet = new ArrayList<int[]>();
                this.intRet.add(new int[this.capacity]);
                break;
            }
            case INT64: {
                this.longRet = new ArrayList<long[]>();
                this.longRet.add(new long[this.capacity]);
                break;
            }
            case FLOAT: {
                this.floatRet = new ArrayList<float[]>();
                this.floatRet.add(new float[this.capacity]);
                break;
            }
            case DOUBLE: {
                this.doubleRet = new ArrayList<double[]>();
                this.doubleRet.add(new double[this.capacity]);
                break;
            }
            case TEXT: {
                this.binaryRet = new ArrayList<Binary[]>();
                this.binaryRet.add(new Binary[this.capacity]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public void putBoolean(long t, boolean v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.booleanRet.add(new boolean[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                boolean[] newValueData = new boolean[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.booleanRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.booleanRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.booleanRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putInt(long t, int v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.intRet.add(new int[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                int[] newValueData = new int[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.intRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.intRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.intRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putLong(long t, long v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.longRet.add(new long[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                long[] newValueData = new long[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.longRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.longRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.longRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putFloat(long t, float v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.floatRet.add(new float[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                float[] newValueData = new float[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.floatRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.floatRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.floatRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putDouble(long t, double v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.doubleRet.add(new double[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                double[] newValueData = new double[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.doubleRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.doubleRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.doubleRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putBinary(long t, Binary v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.binaryRet.add(new Binary[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                Binary[] newValueData = new Binary[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.binaryRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.binaryRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.binaryRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public boolean getBoolean() {
        return this.booleanRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setBoolean(boolean v) {
        this.booleanRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public int getInt() {
        return this.intRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setInt(int v) {
        this.intRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public long getLong() {
        return this.longRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setLong(long v) {
        this.longRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public float getFloat() {
        return this.floatRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setFloat(float v) {
        this.floatRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public double getDouble() {
        return this.doubleRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setDouble(double v) {
        this.doubleRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public Binary getBinary() {
        return this.binaryRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setBinary(Binary v) {
        this.binaryRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public void setTime(long v) {
        this.timeRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public void putAnObject(long t, Object v) {
        switch (this.dataType) {
            case BOOLEAN: {
                this.putBoolean(t, (Boolean)v);
                break;
            }
            case INT32: {
                this.putInt(t, (Integer)v);
                break;
            }
            case INT64: {
                this.putLong(t, (Long)v);
                break;
            }
            case FLOAT: {
                this.putFloat(t, ((Float)v).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(t, (Double)v);
                break;
            }
            case TEXT: {
                this.putBinary(t, (Binary)v);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public int length() {
        return this.count;
    }

    public long getTimeByIndex(int idx) {
        return this.timeRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public long getLongByIndex(int idx) {
        return this.longRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public double getDoubleByIndex(int idx) {
        return this.doubleRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public int getIntByIndex(int idx) {
        return this.intRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public float getFloatByIndex(int idx) {
        return this.floatRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public Binary getBinaryByIndex(int idx) {
        return this.binaryRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public boolean getBooleanByIndex(int idx) {
        return this.booleanRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public TimeValuePair getLastPairBeforeOrEqualTimestamp(long queryTime) {
        TimeValuePair resultPair = new TimeValuePair(Long.MIN_VALUE, null);
        this.resetBatchData();
        while (this.hasCurrent() && this.currentTime() <= queryTime) {
            resultPair.setTimestamp(this.currentTime());
            resultPair.setValue(this.currentTsPrimitiveType());
            this.next();
        }
        return resultPair;
    }

    public Object getValueInTimestamp(long time) {
        while (this.hasCurrent()) {
            if (this.currentTime() < time) {
                this.next();
                continue;
            }
            if (this.currentTime() == time) {
                Object value = this.currentValue();
                this.next();
                return value;
            }
            return null;
        }
        return null;
    }

    public long getMaxTimestamp() {
        return this.getTimeByIndex(this.length() - 1);
    }

    public long getMinTimestamp() {
        return this.getTimeByIndex(0);
    }

    public BatchDataIterator getBatchDataIterator() {
        return new BatchDataIterator(this);
    }

    public void resetBatchData() {
        this.readCurArrayIndex = 0;
        this.readCurListIndex = 0;
    }

    public void resetBatchData(int readCurArrayIndex, int readCurListIndex) {
        this.readCurArrayIndex = readCurArrayIndex;
        this.readCurListIndex = readCurListIndex;
    }

    public int getReadCurListIndex() {
        return this.readCurListIndex;
    }

    public int getReadCurArrayIndex() {
        return this.readCurArrayIndex;
    }

    public BatchData flip() {
        return this;
    }
}

