/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.VersionUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSequenceReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSequenceReader.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    protected String file;
    protected TsFileInput tsFileInput;
    private long fileMetadataPos;
    private int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    private int totalChunkNum;
    private TsFileMetadata tsFileMetaData;
    private Map<String, Map<String, TimeseriesMetadata>> cachedDeviceMetadata = new ConcurrentHashMap<String, Map<String, TimeseriesMetadata>>();
    private static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private boolean cacheDeviceMetadata;

    public TsFileSequenceReader(String file) throws IOException {
        this(file, true);
    }

    public TsFileSequenceReader(String file, boolean loadMetadataSize) throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is opened. {}", (Object)file, (Object)this.getClass().getName());
        }
        this.file = file;
        this.tsFileInput = FSFactoryProducer.getFileInputFactory().getTsFileInput(file);
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(String file, boolean loadMetadata, boolean cacheDeviceMetadata) throws IOException {
        this(file, loadMetadata);
        this.cacheDeviceMetadata = cacheDeviceMetadata;
    }

    public TsFileSequenceReader(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReader(TsFileInput input, boolean loadMetadataSize) throws IOException {
        this.tsFileInput = input;
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        this.tsFileInput = input;
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    public void loadMetadataSize() throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        if (this.readTailMagic().equals("TsFile")) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        }
    }

    public long getFileMetadataPos() {
        return this.fileMetadataPos;
    }

    public int getFileMetadataSize() {
        return this.fileMetadataSize;
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFile".getBytes().length);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        return this.tsFileInput.size() >= (long)("TsFile".getBytes().length * 2 + "000002".getBytes().length) && (this.readTailMagic().equals(this.readHeadMagic()) || this.readTailMagic().equals("000001"));
    }

    public String readHeadMagic() throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, 0L);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public String readVersionNumber() throws IOException {
        ByteBuffer versionNumberBytes = ByteBuffer.allocate("000002".getBytes().length);
        this.tsFileInput.read(versionNumberBytes, "TsFile".getBytes().length);
        versionNumberBytes.flip();
        return new String(versionNumberBytes.array());
    }

    public TsFileMetadata readFileMetadata() throws IOException {
        if (this.tsFileMetaData == null) {
            this.tsFileMetaData = TsFileMetadata.deserializeFrom(this.readData(this.fileMetadataPos, this.fileMetadataSize));
        }
        return this.tsFileMetaData;
    }

    public BloomFilter readBloomFilter() throws IOException {
        this.readFileMetadata();
        return this.tsFileMetaData.getBloomFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TimeseriesMetadata> readDeviceMetadata(String device) throws IOException {
        if (!this.cacheDeviceMetadata) {
            return this.readDeviceMetadataFromDisk(device);
        }
        cacheLock.readLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        cacheLock.writeLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
            this.readFileMetadata();
            Map<String, TimeseriesMetadata> deviceMetadata = this.readDeviceMetadataFromDisk(device);
            this.cachedDeviceMetadata.put(device, deviceMetadata);
            Map<String, TimeseriesMetadata> map = deviceMetadata;
            return map;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private Map<String, TimeseriesMetadata> readDeviceMetadataFromDisk(String device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataList = this.getDeviceTimeseriesMetadata(device);
        HashMap<String, TimeseriesMetadata> deviceMetadata = new HashMap<String, TimeseriesMetadata>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
            deviceMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata);
        }
        return deviceMetadata;
    }

    public TimeseriesMetadata readTimeseriesMetadata(Path path) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), MetadataIndexNodeType.INTERNAL_DEVICE, true);
        if (metadataIndexPair == null) {
            return null;
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), MetadataIndexNodeType.INTERNAL_MEASUREMENT, false);
        }
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer));
        }
        int searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, path.getMeasurement());
        return searchResult >= 0 ? (TimeseriesMetadata)timeseriesMetadataList.get(searchResult) : null;
    }

    public List<TimeseriesMetadata> readTimeseriesMetadata(String device, Set<String> measurements) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, device, MetadataIndexNodeType.INTERNAL_DEVICE, false);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<TimeseriesMetadata> resultTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        ArrayList<String> measurementList = new ArrayList<String>(measurements);
        HashSet<String> measurementsHadFound = new HashSet<String>();
        for (int i = 0; i < measurementList.size(); ++i) {
            if (measurementsHadFound.contains(measurementList.get(i))) continue;
            ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
            Pair<MetadataIndexEntry, Long> measurementMetadataIndexPair = metadataIndexPair;
            ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
            MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
            if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
                measurementMetadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, (String)measurementList.get(i), MetadataIndexNodeType.INTERNAL_MEASUREMENT, false);
            }
            if (measurementMetadataIndexPair == null) {
                return Collections.emptyList();
            }
            buffer = this.readData(((MetadataIndexEntry)measurementMetadataIndexPair.left).getOffset(), (Long)measurementMetadataIndexPair.right);
            while (buffer.hasRemaining()) {
                timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer));
            }
            for (int j = i; j < measurementList.size(); ++j) {
                int searchResult;
                String current = (String)measurementList.get(j);
                if (!measurementsHadFound.contains(current) && (searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, current)) >= 0) {
                    resultTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(searchResult));
                    measurementsHadFound.add(current);
                }
                if (measurementsHadFound.size() != measurements.size()) continue;
                return resultTimeseriesMetadataList;
            }
        }
        return resultTimeseriesMetadataList;
    }

    private void traverseAndReadTimeseriesMetadataInOneDevice(List<TimeseriesMetadata> timeseriesMetadataList, MetadataIndexNodeType type, Pair<MetadataIndexEntry, Long> metadataIndexPair, Set<String> measurements) throws IOException {
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        switch (type) {
            case LEAF_DEVICE: 
            case INTERNAL_MEASUREMENT: {
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    this.traverseAndReadTimeseriesMetadataInOneDevice(timeseriesMetadataList, metadataIndexNode.getNodeType(), new Pair<MetadataIndexEntry, Long>(metadataIndexNode.getChildren().get(i), endOffset), measurements);
                }
                break;
            }
            case LEAF_MEASUREMENT: {
                while (buffer.hasRemaining()) {
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(buffer);
                    if (!measurements.contains(timeseriesMetadata.getMeasurementId())) continue;
                    timeseriesMetadataList.add(timeseriesMetadata);
                }
                break;
            }
            default: {
                throw new IOException("Failed to traverse and read TimeseriesMetadata in device: " + ((MetadataIndexEntry)metadataIndexPair.left).getName() + ". Wrong MetadataIndexEntry type.");
            }
        }
    }

    private int binarySearchInTimeseriesMetadataList(List<TimeseriesMetadata> timeseriesMetadataList, String key) {
        int low = 0;
        int high = timeseriesMetadataList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            TimeseriesMetadata midVal = timeseriesMetadataList.get(mid);
            int cmp = midVal.getMeasurementId().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public List<String> getAllDevices() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        return this.getAllDevices(this.tsFileMetaData.getMetadataIndex());
    }

    private List<String> getAllDevices(MetadataIndexNode metadataIndexNode) throws IOException {
        ArrayList<String> deviceList = new ArrayList<String>();
        int metadataIndexListSize = metadataIndexNode.getChildren().size();
        if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_MEASUREMENT)) {
            for (MetadataIndexEntry index : metadataIndexNode.getChildren()) {
                deviceList.add(index.getName());
            }
        } else {
            for (int i = 0; i < metadataIndexListSize; ++i) {
                ByteBuffer buffer;
                MetadataIndexNode node;
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if ((node = MetadataIndexNode.deserializeFrom(buffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset))).getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceList.addAll(node.getChildren().stream().map(MetadataIndexEntry::getName).collect(Collectors.toList()));
                    continue;
                }
                deviceList.addAll(this.getAllDevices(node));
            }
        }
        return deviceList;
    }

    public Map<String, List<ChunkMetadata>> readChunkMetadataInDevice(String device) throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        long start = 0L;
        int size = 0;
        List<TimeseriesMetadata> timeseriesMetadataMap = this.getDeviceTimeseriesMetadata(device);
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap) {
            if (start == 0L) {
                start = timeseriesMetadata.getOffsetOfChunkMetaDataList();
            }
            size += timeseriesMetadata.getDataSizeOfChunkMetaDataList();
        }
        ByteBuffer buffer = this.readData(start, size);
        HashMap<String, List<ChunkMetadata>> seriesMetadata = new HashMap<String, List<ChunkMetadata>>();
        while (buffer.hasRemaining()) {
            ChunkMetadata chunkMetadata = ChunkMetadata.deserializeFrom(buffer);
            seriesMetadata.computeIfAbsent(chunkMetadata.getMeasurementUid(), key -> new ArrayList()).add(chunkMetadata);
        }
        List<Pair<Long, Long>> versionInfo = this.tsFileMetaData.getVersionInfo();
        for (Map.Entry entry : seriesMetadata.entrySet()) {
            VersionUtils.applyVersion((List)entry.getValue(), versionInfo);
        }
        return seriesMetadata;
    }

    public List<Path> getAllPaths() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (String measurementId : timeseriesMetadataMap.keySet()) {
                paths.add(new Path(device, measurementId));
            }
        }
        return paths;
    }

    private void generateMetadataIndex(MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<String, List<TimeseriesMetadata>> timeseriesMetadataMap) throws IOException {
        switch (type) {
            case LEAF_DEVICE: 
            case INTERNAL_MEASUREMENT: 
            case INTERNAL_DEVICE: {
                deviceId = metadataIndex.getName();
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                    this.generateMetadataIndex(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap);
                }
                break;
            }
            case LEAF_MEASUREMENT: {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer));
                }
                timeseriesMetadataMap.computeIfAbsent(deviceId, k -> new ArrayList()).addAll(timeseriesMetadataList);
            }
        }
    }

    public Map<String, List<TimeseriesMetadata>> getAllTimeseriesMetadata() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        HashMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<String, List<TimeseriesMetadata>>();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            this.generateMetadataIndex(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap);
        }
        return timeseriesMetadataMap;
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadata(String device) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, MetadataIndexNodeType.INTERNAL_DEVICE, false);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        this.generateMetadataIndex((MetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    private Pair<MetadataIndexEntry, Long> getMetadataAndEndOffset(MetadataIndexNode metadataIndex, String name, MetadataIndexNodeType type, boolean exactSearch) throws IOException {
        Pair<MetadataIndexEntry, Long> childIndexEntry = metadataIndex.getChildIndexEntry(name, exactSearch);
        if (childIndexEntry == null) {
            return null;
        }
        if (!metadataIndex.getNodeType().equals((Object)type)) {
            return childIndexEntry;
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)childIndexEntry.left).getOffset(), (Long)childIndexEntry.right);
        return this.getMetadataAndEndOffset(MetadataIndexNode.deserializeFrom(buffer), name, type, exactSearch);
    }

    public ChunkGroupFooter readChunkGroupFooter() throws IOException {
        return ChunkGroupFooter.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public ChunkGroupFooter readChunkGroupFooter(long position, boolean markerRead) throws IOException {
        return ChunkGroupFooter.deserializeFrom(this.tsFileInput, position, markerRead);
    }

    public long readVersion() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        return buffer.getLong();
    }

    public ChunkHeader readChunkHeader() throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    private ChunkHeader readChunkHeader(long position, int chunkHeaderSize, boolean markerRead) throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput, position, chunkHeaderSize, markerRead);
    }

    private ByteBuffer readChunk(long position, int dataSize) throws IOException {
        return this.readData(position, dataSize);
    }

    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        int chunkHeadSize = ChunkHeader.getSerializedSize(metaData.getMeasurementUid());
        ChunkHeader header = this.readChunkHeader(metaData.getOffsetOfChunkHeader(), chunkHeadSize, false);
        ByteBuffer buffer = this.readChunk(metaData.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
        return new Chunk(header, buffer, metaData.getDeleteIntervalList());
    }

    public Map<String, List<Chunk>> readChunksInDevice(String device) throws IOException {
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        Map<String, List<ChunkMetadata>> chunkMetadataInDevice = this.readChunkMetadataInDevice(device);
        for (List<ChunkMetadata> chunkMetadataListInDevice : chunkMetadataInDevice.values()) {
            chunkMetadataList.addAll(chunkMetadataListInDevice);
        }
        HashMap<String, List<Chunk>> chunksInDevice = new HashMap<String, List<Chunk>>();
        chunkMetadataList.sort(Comparator.comparing(ChunkMetadata::getOffsetOfChunkHeader));
        for (ChunkMetadata chunkMetadata : chunkMetadataList) {
            Chunk chunk = this.readMemChunk(chunkMetadata);
            String measurement = chunk.getHeader().getMeasurementID();
            if (!chunksInDevice.containsKey(measurement)) {
                chunksInDevice.put(measurement, new ArrayList());
            }
            ((List)chunksInDevice.get(measurement)).add(chunk);
        }
        return chunksInDevice;
    }

    public PageHeader readPageHeader(TSDataType type) throws IOException {
        return PageHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type);
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public void skipPageData(PageHeader header) throws IOException {
        this.tsFileInput.position(this.tsFileInput.position() + (long)header.getCompressedSize());
    }

    public ByteBuffer readPage(PageHeader header, CompressionType type) throws IOException {
        return this.readPage(header, type, -1L);
    }

    private ByteBuffer readPage(PageHeader header, CompressionType type, long position) throws IOException {
        ByteBuffer buffer = this.readData(position, header.getCompressedSize());
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(type);
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(header.getUncompressedSize());
        if (type == CompressionType.UNCOMPRESSED) {
            return buffer;
        }
        unCompressor.uncompress(buffer.array(), buffer.position(), buffer.remaining(), uncompressedBuffer.array(), 0);
        return uncompressedBuffer;
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    @Override
    public void close() throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is closed.", (Object)this.file);
        }
        this.tsFileInput.close();
    }

    public String getFileName() {
        return this.file;
    }

    public long fileSize() throws IOException {
        return this.tsFileInput.size();
    }

    private ByteBuffer readData(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (position < 0L) {
            if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) != size) {
                throw new IOException("reach the end of the data");
            }
        } else {
            long actualReadSize = ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, size);
            if (actualReadSize != (long)size) {
                throw new IOException(String.format("reach the end of the data. Size of data that want to read: %s,actual read size: %s, posiotion: %s", size, actualReadSize, position));
            }
        }
        buffer.flip();
        return buffer;
    }

    private ByteBuffer readData(long start, long end) throws IOException {
        return this.readData(start, (int)(end - start));
    }

    public int readRaw(long position, int length, ByteBuffer target) throws IOException {
        return ReadWriteIOUtils.readAsPossible(this.tsFileInput, target, position, length);
    }

    public long selfCheck(Map<Path, MeasurementSchema> newSchema, List<ChunkGroupMetadata> chunkGroupMetadataList, List<Pair<Long, Long>> versionInfo, boolean fastFinish) throws IOException {
        File checkFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!checkFile.exists()) {
            return -4L;
        }
        long fileSize = checkFile.length();
        ArrayList<ChunkMetadata> chunkMetadataList = null;
        int headerLength = "TsFile".getBytes().length + "000002".getBytes().length;
        if (fileSize < (long)headerLength) {
            return -3L;
        }
        if (!"TsFile".equals(this.readHeadMagic()) || !"000002".equals(this.readVersionNumber())) {
            return -3L;
        }
        this.tsFileInput.position(headerLength);
        if (fileSize == (long)headerLength) {
            return headerLength;
        }
        if (this.isComplete()) {
            this.loadMetadataSize();
            if (fastFinish) {
                return -1L;
            }
        }
        boolean newChunkGroup = true;
        long truncatedSize = headerLength;
        int chunkCnt = 0;
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        try {
            byte marker;
            block7: while ((marker = this.readMarker()) != 2) {
                switch (marker) {
                    case 1: {
                        if (newChunkGroup) {
                            newChunkGroup = false;
                            chunkMetadataList = new ArrayList<ChunkMetadata>();
                        }
                        long fileOffsetOfChunk = this.position() - 1L;
                        ChunkHeader chunkHeader = this.readChunkHeader();
                        String measurementID = chunkHeader.getMeasurementID();
                        MeasurementSchema measurementSchema = new MeasurementSchema(measurementID, chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        TSDataType dataType = chunkHeader.getDataType();
                        Statistics chunkStatistics = Statistics.getStatsByType(dataType);
                        for (int j = 0; j < chunkHeader.getNumOfPages(); ++j) {
                            PageHeader pageHeader = this.readPageHeader(chunkHeader.getDataType());
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            this.skipPageData(pageHeader);
                        }
                        ChunkMetadata currentChunk = new ChunkMetadata(measurementID, dataType, fileOffsetOfChunk, chunkStatistics);
                        chunkMetadataList.add(currentChunk);
                        ++chunkCnt;
                        continue block7;
                    }
                    case 0: {
                        ChunkGroupFooter chunkGroupFooter = this.readChunkGroupFooter();
                        String deviceID = chunkGroupFooter.getDeviceID();
                        if (newSchema != null) {
                            for (MeasurementSchema tsSchema : measurementSchemaList) {
                                newSchema.putIfAbsent(new Path(deviceID, tsSchema.getMeasurementId()), tsSchema);
                            }
                        }
                        chunkGroupMetadataList.add(new ChunkGroupMetadata(deviceID, chunkMetadataList));
                        newChunkGroup = true;
                        truncatedSize = this.position();
                        this.totalChunkNum += chunkCnt;
                        chunkCnt = 0;
                        measurementSchemaList = new ArrayList();
                        continue block7;
                    }
                    case 3: {
                        long version = this.readVersion();
                        versionInfo.add(new Pair<Long, Long>(this.position(), version));
                        truncatedSize = this.position();
                        continue block7;
                    }
                }
                throw new IOException("Unexpected marker " + marker);
            }
            truncatedSize = this.position() - 1L;
        }
        catch (Exception e) {
            logger.info("TsFile {} self-check cannot proceed at position {} recovered, because : {}", new Object[]{this.file, this.position(), e.getMessage()});
        }
        return truncatedSize;
    }

    public int getTotalChunkNum() {
        return this.totalChunkNum;
    }

    public List<ChunkMetadata> getChunkMetadataList(Path path) throws IOException {
        TimeseriesMetadata timeseriesMetaData = this.readTimeseriesMetadata(path);
        if (timeseriesMetaData == null) {
            return Collections.emptyList();
        }
        List<ChunkMetadata> chunkMetadataList = this.readChunkMetaDataList(timeseriesMetaData);
        chunkMetadataList.sort(Comparator.comparingLong(ChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    public List<ChunkMetadata> readChunkMetaDataList(TimeseriesMetadata timeseriesMetaData) throws IOException {
        this.readFileMetadata();
        List<Pair<Long, Long>> versionInfo = this.tsFileMetaData.getVersionInfo();
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        long startOffsetOfChunkMetadataList = timeseriesMetaData.getOffsetOfChunkMetaDataList();
        int dataSizeOfChunkMetadataList = timeseriesMetaData.getDataSizeOfChunkMetaDataList();
        ByteBuffer buffer = this.readData(startOffsetOfChunkMetadataList, dataSizeOfChunkMetadataList);
        while (buffer.hasRemaining()) {
            chunkMetadataList.add(ChunkMetadata.deserializeFrom(buffer));
        }
        VersionUtils.applyVersion(chunkMetadataList, versionInfo);
        chunkMetadataList.trimToSize();
        return chunkMetadataList;
    }

    public Map<String, TSDataType> getAllMeasurements() throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTSDataType());
            }
        }
        return result;
    }

    public List<String> getDeviceNameInRange(long start, long end) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        for (String device : this.getAllDevices()) {
            Map<String, List<ChunkMetadata>> seriesMetadataMap = this.readChunkMetadataInDevice(device);
            if (!this.hasDataInPartition(seriesMetadataMap, start, end)) continue;
            res.add(device);
        }
        return res;
    }

    private boolean hasDataInPartition(Map<String, List<ChunkMetadata>> seriesMetadataMap, long start, long end) {
        for (List<ChunkMetadata> chunkMetadataList : seriesMetadataMap.values()) {
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                LocateStatus location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata, start, end);
                if (location != LocateStatus.in) continue;
                return true;
            }
        }
        return false;
    }

    public static enum LocateStatus {
        in,
        before,
        after;

    }
}

