/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;

public class MetadataIndexConstructor {
    private static final int MAX_DEGREE_OF_INDEX_NODE = TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode();

    private MetadataIndexConstructor() {
        throw new IllegalStateException("Utility class");
    }

    public static MetadataIndexNode constructMetadataIndex(Map<String, List<TimeseriesMetadata>> deviceTimeseriesMetadataMap, TsFileOutput out) throws IOException {
        TreeMap deviceMetadataIndexMap = new TreeMap();
        for (Map.Entry<String, List<TimeseriesMetadata>> entry : deviceTimeseriesMetadataMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ArrayDeque<MetadataIndexNode> arrayDeque = new ArrayDeque<MetadataIndexNode>();
            MetadataIndexNode currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)((List)entry.getValue()).get(i);
                if (i % MAX_DEGREE_OF_INDEX_NODE == 0) {
                    if (currentIndexNode.isFull()) {
                        MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, arrayDeque, out);
                        currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
                    }
                    currentIndexNode.addEntry(new MetadataIndexEntry(timeseriesMetadata.getMeasurementId(), out.getPosition()));
                }
                timeseriesMetadata.serializeTo(out.wrapAsStream());
            }
            MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, arrayDeque, out);
            deviceMetadataIndexMap.put(entry.getKey(), MetadataIndexConstructor.generateRootNode(arrayDeque, out, MetadataIndexNodeType.INTERNAL_MEASUREMENT));
        }
        if (deviceMetadataIndexMap.size() <= MAX_DEGREE_OF_INDEX_NODE) {
            MetadataIndexNode metadataIndexNode = new MetadataIndexNode(MetadataIndexNodeType.INTERNAL_MEASUREMENT);
            for (Map.Entry entry : deviceMetadataIndexMap.entrySet()) {
                metadataIndexNode.addEntry(new MetadataIndexEntry((String)entry.getKey(), out.getPosition()));
                ((MetadataIndexNode)entry.getValue()).serializeTo(out.wrapAsStream());
            }
            metadataIndexNode.setEndOffset(out.getPosition());
            return metadataIndexNode;
        }
        ArrayDeque<MetadataIndexNode> deviceMetadaIndexQueue = new ArrayDeque<MetadataIndexNode>();
        MetadataIndexNode currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_DEVICE);
        for (Map.Entry entry : deviceMetadataIndexMap.entrySet()) {
            if (currentIndexNode.isFull()) {
                MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, deviceMetadaIndexQueue, out);
                currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_DEVICE);
            }
            currentIndexNode.addEntry(new MetadataIndexEntry((String)entry.getKey(), out.getPosition()));
            ((MetadataIndexNode)entry.getValue()).serializeTo(out.wrapAsStream());
        }
        MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, deviceMetadaIndexQueue, out);
        MetadataIndexNode metadataIndexNode = MetadataIndexConstructor.generateRootNode(deviceMetadaIndexQueue, out, MetadataIndexNodeType.INTERNAL_DEVICE);
        metadataIndexNode.setEndOffset(out.getPosition());
        return metadataIndexNode;
    }

    private static MetadataIndexNode generateRootNode(Queue<MetadataIndexNode> metadataIndexNodeQueue, TsFileOutput out, MetadataIndexNodeType type) throws IOException {
        int queueSize = metadataIndexNodeQueue.size();
        MetadataIndexNode currentIndexNode = new MetadataIndexNode(type);
        while (queueSize != 1) {
            for (int i = 0; i < queueSize; ++i) {
                MetadataIndexNode metadataIndexNode = metadataIndexNodeQueue.poll();
                if (currentIndexNode.isFull()) {
                    MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, metadataIndexNodeQueue, out);
                    currentIndexNode = new MetadataIndexNode(type);
                }
                currentIndexNode.addEntry(new MetadataIndexEntry(metadataIndexNode.peek().getName(), out.getPosition()));
                metadataIndexNode.serializeTo(out.wrapAsStream());
            }
            MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, metadataIndexNodeQueue, out);
            currentIndexNode = new MetadataIndexNode(type);
            queueSize = metadataIndexNodeQueue.size();
        }
        return metadataIndexNodeQueue.poll();
    }

    private static void addCurrentIndexNodeToQueue(MetadataIndexNode currentIndexNode, Queue<MetadataIndexNode> metadataIndexNodeQueue, TsFileOutput out) throws IOException {
        currentIndexNode.setEndOffset(out.getPosition());
        metadataIndexNodeQueue.add(currentIndexNode);
    }
}

