/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.ZoneId;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBPreparedStatement;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.apache.iotdb.jdbc.IoTDBURLException;
import org.apache.iotdb.jdbc.Utils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConnection.class);
    private static final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V2;
    private TSIService.Iface client = null;
    private long sessionId = -1L;
    private IoTDBConnectionParams params;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSocket transport;
    private ZoneId zoneId;
    private boolean autoCommit;

    public IoTDBConnection() {
    }

    public IoTDBConnection(String url, Properties info) throws SQLException, TTransportException {
        if (url == null) {
            throw new IoTDBURLException("Input url cannot be null");
        }
        this.params = Utils.parseUrl(url, info);
        this.openTransport();
        if (Config.rpcThriftCompressionEnable) {
            this.setClient((TSIService.Iface)new TSIService.Client((TProtocol)new TCompactProtocol((TTransport)this.transport)));
        } else {
            this.setClient((TSIService.Iface)new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport)));
        }
        this.openSession();
        this.setClient(RpcUtils.newSynchronizedClient((TSIService.Iface)this.getClient()));
        this.autoCommit = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Not support isWrapperFor");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Not support unwrap");
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
        throw new SQLException("Not support abort");
    }

    @Override
    public void clearWarnings() {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionId);
        try {
            this.getClient().closeSession(req);
        }
        catch (TException e) {
            throw new SQLException("Error occurs when closing session at server. Maybe server is down.", e);
        }
        finally {
            this.isClosed = true;
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Not support commit");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Not support createArrayOf");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Not support createBlob");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Not support createClob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Not suppport createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Not support createSQLXML");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new IoTDBStatement(this, this.getClient(), this.sessionId, this.zoneId);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException(String.format("Statements with result set concurrency %d are not supported", resultSetConcurrency));
        }
        if (resultSetType == 1005) {
            throw new SQLException(String.format("Statements with ResultSet type %d are not supported", resultSetType));
        }
        return new IoTDBStatement(this, this.getClient(), this.sessionId, this.zoneId);
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Not support createStatement");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Not support createStruct");
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean arg0) {
        this.autoCommit = arg0;
    }

    @Override
    public String getCatalog() {
        return "no catalog";
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new SQLException("Not support setCatalog");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Not support getClientInfo");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new SQLClientInfoException("Not support setClientInfo", null);
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new SQLException("Not support getClientInfo");
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new SQLException("Not support setHoldability");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new IoTDBDatabaseMetadata(this, this.getClient(), this.sessionId);
    }

    @Override
    public int getNetworkTimeout() {
        return Config.connectionTimeoutInMs;
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Not support getSchema");
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        throw new SQLException("Not support setSchema");
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new SQLException("Not support setTransactionIsolation");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Not support getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new SQLException("Not support setTypeMap");
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        throw new SQLException("Not support setReadOnly");
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new SQLException("Not support nativeSQL");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new SQLException("Not support prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Not support prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("Not support prepareCall");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new IoTDBPreparedStatement(this, this.getClient(), (Long)this.sessionId, sql, this.zoneId);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not support prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not support prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not support prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not support prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not support prepareStatement");
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("Not support releaseSavepoint");
    }

    @Override
    public void rollback() {
    }

    @Override
    public void rollback(Savepoint arg0) {
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new SQLClientInfoException("Not support setClientInfo", null);
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        throw new SQLException("Not support setNetworkTimeout");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not support setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("Not support setSavepoint");
    }

    public TSIService.Iface getClient() {
        return this.client;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setClient(TSIService.Iface client) {
        this.client = client;
    }

    private void openTransport() throws TTransportException {
        this.transport = new TSocket(this.params.getHost(), this.params.getPort(), Config.connectionTimeoutInMs);
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
    }

    private void openSession() throws SQLException {
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(this.params.getUsername());
        openReq.setPassword(this.params.getPassword());
        TSOpenSessionResp openResp = null;
        try {
            openResp = this.client.openSession(openReq);
            this.sessionId = openResp.getSessionId();
            RpcUtils.verifySuccess((TSStatus)openResp.getStatus());
            if (protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                logger.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
            if (this.zoneId != null) {
                this.setTimeZone(this.zoneId.toString());
            } else {
                this.zoneId = ZoneId.of(this.getTimeZone());
            }
        }
        catch (TException e) {
            this.transport.close();
            if (e.getMessage().contains("Required field 'client_protocol' was not present!")) {
                throw new SQLException(String.format("Can not establish connection with %s : You may try to connect an old version IoTDB instance using a client with new version: %s. ", this.params.getJdbcUriString(), e.getMessage()), e);
            }
            throw new SQLException(String.format("Can not establish connection with %s : %s. ", this.params.getJdbcUriString(), e.getMessage()), e);
        }
        catch (StatementExecutionException e) {
            this.transport.close();
            throw new IoTDBSQLException(e.getMessage(), openResp.getStatus());
        }
        this.isClosed = false;
    }

    boolean reconnect() {
        boolean flag = false;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (this.transport == null) continue;
                this.transport.close();
                this.openTransport();
                if (Config.rpcThriftCompressionEnable) {
                    this.setClient((TSIService.Iface)new TSIService.Client((TProtocol)new TCompactProtocol((TTransport)this.transport)));
                } else {
                    this.setClient((TSIService.Iface)new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport)));
                }
                this.openSession();
                this.setClient(RpcUtils.newSynchronizedClient((TSIService.Iface)this.getClient()));
                flag = true;
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("reconnect is interrupted.", (Throwable)e1);
                }
            }
        }
        return flag;
    }

    public String getTimeZone() throws TException, IoTDBSQLException {
        if (this.zoneId != null) {
            return this.zoneId.toString();
        }
        TSGetTimeZoneResp resp = this.getClient().getTimeZone(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)resp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), resp.getStatus());
        }
        return resp.getTimeZone();
    }

    public void setTimeZone(String zoneId) throws TException, IoTDBSQLException {
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(this.sessionId, zoneId);
        TSStatus resp = this.getClient().setTimeZone(req);
        try {
            RpcUtils.verifySuccess((TSStatus)resp);
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), resp);
        }
        this.zoneId = ZoneId.of(zoneId);
    }

    public ServerProperties getServerProperties() throws TException {
        return this.getClient().getProperties();
    }
}

