/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.tool.ImportCsv;
import org.apache.thrift.TException;

public abstract class AbstractCli {
    static final String HOST_ARGS = "h";
    static final String HOST_NAME = "host";
    static final String HELP_ARGS = "help";
    static final String PORT_ARGS = "p";
    static final String PORT_NAME = "port";
    static final String PASSWORD_ARGS = "pw";
    private static final String PASSWORD_NAME = "password";
    static final String USERNAME_ARGS = "u";
    static final String USERNAME_NAME = "username";
    private static final String EXECUTE_ARGS = "e";
    private static final String EXECUTE_NAME = "execute";
    private static final String NULL = "null";
    static final String ISO8601_ARGS = "disableISO8601";
    static final List<String> AGGREGRATE_TIME_LIST = new ArrayList<String>();
    static final String MAX_PRINT_ROW_COUNT_ARGS = "maxPRC";
    private static final String MAX_PRINT_ROW_COUNT_NAME = "maxPrintRowCount";
    static final String RPC_COMPRESS_ARGS = "c";
    private static final String RPC_COMPRESS_NAME = "rpcCompressed";
    static final String SET_MAX_DISPLAY_NUM = "set max_display_num";
    static final String SET_TIMESTAMP_DISPLAY = "set time_display_type";
    static final String SHOW_TIMESTAMP_DISPLAY = "show time_display_type";
    static final String SET_TIME_ZONE = "set time_zone";
    static final String SHOW_TIMEZONE = "show time_zone";
    static final String SET_FETCH_SIZE = "set fetch_size";
    static final String SHOW_FETCH_SIZE = "show fetch_size";
    private static final String HELP = "help";
    static final String IOTDB_CLI_PREFIX = "IoTDB";
    static final String SCRIPT_HINT = "./start-cli.sh(start-cli.bat if Windows)";
    static final String QUIT_COMMAND = "quit";
    static final String EXIT_COMMAND = "exit";
    private static final String SHOW_METADATA_COMMAND = "show timeseries";
    static final int MAX_HELP_CONSOLE_WIDTH = 88;
    static final String TIMESTAMP_STR = "Time";
    static final int ISO_DATETIME_LEN = 35;
    private static final String IMPORT_CMD = "import";
    private static final String DEFAULT_TIME_FORMAT = "default";
    private static String timeFormat = "default";
    static int maxPrintRowCount = 1000;
    private static int fetchSize = 1000;
    static int maxTimeLength = 35;
    static int maxValueLength = 15;
    static String TIMESTAMP_PRECISION = "ms";
    private static int lineCount = 0;
    private static final String SUCCESS_MESSAGE = "The statement is executed successfully.";
    private static boolean isReachEnd = false;
    static String formatTime = "%" + maxTimeLength + "s|";
    static String host = "127.0.0.1";
    static String port = "6667";
    static String username;
    static String password;
    static String execute;
    static boolean hasExecuteSQL;
    static Set<String> keywordSet;
    static ServerProperties properties;
    private static final PrintStream SCREEN_PRINTER;
    private static boolean cursorBeforeFirst;

    static void init() {
        keywordSet.add("-h");
        keywordSet.add("-help");
        keywordSet.add("-p");
        keywordSet.add("-pw");
        keywordSet.add("-u");
        keywordSet.add("-e");
        keywordSet.add("-disableISO8601");
        keywordSet.add("-maxPRC");
        keywordSet.add("-c");
    }

    private static String getTimestampPrecision() {
        return TIMESTAMP_PRECISION;
    }

    private static void printCount(int cnt) {
        if (cnt == 0) {
            AbstractCli.println("Empty set.");
        } else {
            AbstractCli.println("Total line number = " + cnt);
        }
    }

    static Options createOptions() {
        Options options = new Options();
        Option help = new Option("help", false, "Display help information(optional)");
        help.setRequired(false);
        options.addOption(help);
        Option timeFormat = new Option(ISO8601_ARGS, false, "Display timestamp in number(optional)");
        timeFormat.setRequired(false);
        options.addOption(timeFormat);
        Option host = Option.builder((String)HOST_ARGS).argName(HOST_NAME).hasArg().desc("Host Name (optional, default 127.0.0.1)").build();
        options.addOption(host);
        Option port = Option.builder((String)PORT_ARGS).argName(PORT_NAME).hasArg().desc("Port (optional, default 6667)").build();
        options.addOption(port);
        Option username = Option.builder((String)USERNAME_ARGS).argName(USERNAME_NAME).hasArg().desc("User name (required)").required().build();
        options.addOption(username);
        Option password = Option.builder((String)PASSWORD_ARGS).argName(PASSWORD_NAME).hasArg().desc("password (optional)").build();
        options.addOption(password);
        Option execute = Option.builder((String)EXECUTE_ARGS).argName(EXECUTE_NAME).hasArg().desc("execute statement (optional)").build();
        options.addOption(execute);
        Option maxPrintCount = Option.builder((String)MAX_PRINT_ROW_COUNT_ARGS).argName(MAX_PRINT_ROW_COUNT_NAME).hasArg().desc("Maximum number of rows displayed (optional)").build();
        options.addOption(maxPrintCount);
        Option isRpcCompressed = Option.builder((String)RPC_COMPRESS_ARGS).argName(RPC_COMPRESS_NAME).desc("Rpc Compression enabled or not").build();
        options.addOption(isRpcCompressed);
        return options;
    }

    public static String parseLongToDateWithPrecision(DateTimeFormatter formatter, long timestamp, ZoneId zoneid, String timestampPrecision) {
        if (timestampPrecision.equals("ms")) {
            long integerofDate = timestamp / 1000L;
            StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000L));
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 3) {
                for (int i = 0; i < 3 - length; ++i) {
                    digits.insert(0, "0");
                }
            }
            return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
        }
        if (timestampPrecision.equals("us")) {
            long integerofDate = timestamp / 1000000L;
            StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000000L));
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 6) {
                for (int i = 0; i < 6 - length; ++i) {
                    digits.insert(0, "0");
                }
            }
            return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
        }
        long integerofDate = timestamp / 1000000000L;
        StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000000000L));
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
        String datetime = dateTime.format(formatter);
        int length = digits.length();
        if (length != 9) {
            for (int i = 0; i < 9 - length; ++i) {
                digits.insert(0, "0");
            }
        }
        return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
    }

    private static String formatDatetime(long timestamp, ZoneId zoneId) {
        switch (timeFormat) {
            case "long": 
            case "number": {
                return Long.toString(timestamp);
            }
            case "default": 
            case "iso8601": {
                return AbstractCli.parseLongToDateWithPrecision(DateTimeFormatter.ISO_OFFSET_DATE_TIME, timestamp, zoneId, AbstractCli.getTimestampPrecision());
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return dateTime.format(DateTimeFormatter.ofPattern(timeFormat));
    }

    static String checkRequiredArg(String arg, String name, CommandLine commandLine, boolean isRequired, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (isRequired) {
                String msg = String.format("%s: Required values for option '%s' not provided", IOTDB_CLI_PREFIX, name);
                AbstractCli.println(msg);
                AbstractCli.println("Use -help for more information");
                throw new ArgsErrorException(msg);
            }
            if (defaultValue == null) {
                String msg = String.format("%s: Required values for option '%s' is null.", IOTDB_CLI_PREFIX, name);
                throw new ArgsErrorException(msg);
            }
            return defaultValue;
        }
        return str;
    }

    static void setTimeFormat(String newTimeFormat) {
        switch (newTimeFormat.trim().toLowerCase()) {
            case "long": 
            case "number": {
                maxTimeLength = maxValueLength;
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            case "default": 
            case "iso8601": {
                maxTimeLength = 35;
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            default: {
                new SimpleDateFormat(newTimeFormat.trim());
                maxTimeLength = Math.max(TIMESTAMP_STR.length(), newTimeFormat.length());
                timeFormat = newTimeFormat;
            }
        }
        formatTime = "%" + maxTimeLength + "s|";
    }

    private static void setFetchSize(String fetchSizeString) {
        long tmp = Long.parseLong(fetchSizeString.trim());
        fetchSize = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(fetchSizeString.trim());
    }

    static void setMaxDisplayNumber(String maxDisplayNum) {
        long tmp = Long.parseLong(maxDisplayNum.trim());
        maxPrintRowCount = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(maxDisplayNum.trim());
    }

    static String[] removePasswordArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-pw")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        return args;
    }

    static String[] processExecuteArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-e")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        if (index == -1) {
            return args;
        }
        StringBuilder executeCommand = new StringBuilder();
        for (int j = index + 1; j < args.length; ++j) {
            executeCommand.append(args[j]).append(" ");
        }
        executeCommand.deleteCharAt(executeCommand.length() - 1);
        execute = executeCommand.toString();
        hasExecuteSQL = true;
        args = Arrays.copyOfRange(args, 0, index);
        return args;
    }

    static void displayLogo(String version) {
        AbstractCli.println(" _____       _________  ______   ______    \n|_   _|     |  _   _  ||_   _ `.|_   _ \\   \n  | |   .--.|_/ | | \\_|  | | `. \\ | |_) |  \n  | | / .'`\\ \\  | |      | |  | | |  __'.  \n _| |_| \\__. | _| |_    _| |_.' /_| |__) | \n|_____|'.__.' |_____|  |______.'|_______/  version " + version + "\n                                           \n");
    }

    static void echoStarting() {
        AbstractCli.println("---------------------");
        AbstractCli.println("Starting IoTDB Cli");
        AbstractCli.println("---------------------");
    }

    static OperationResult handleInputCmd(String cmd, IoTDBConnection connection) {
        String specialCmd = cmd.toLowerCase().trim();
        if (QUIT_COMMAND.equals(specialCmd) || EXIT_COMMAND.equals(specialCmd)) {
            return OperationResult.STOP_OPER;
        }
        if ("help".equals(specialCmd)) {
            AbstractCli.showHelp();
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIMESTAMP_DISPLAY)) {
            AbstractCli.setTimestampDisplay(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIME_ZONE)) {
            AbstractCli.setTimeZone(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_FETCH_SIZE)) {
            AbstractCli.setFetchSize(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_MAX_DISPLAY_NUM)) {
            AbstractCli.setMaxDisplaNum(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMEZONE)) {
            AbstractCli.showTimeZone(connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMESTAMP_DISPLAY)) {
            AbstractCli.println("Current time format: " + timeFormat);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_FETCH_SIZE)) {
            AbstractCli.println("Current fetch size: " + fetchSize);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(IMPORT_CMD)) {
            AbstractCli.importCmd(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        AbstractCli.executeQuery(connection, cmd);
        return OperationResult.NO_OPER;
    }

    private static void showHelp() {
        AbstractCli.println("    <your-sql>\t\t\t execute your sql statment");
        AbstractCli.println(String.format("    %s\t\t show how many timeseries are in iotdb", SHOW_METADATA_COMMAND));
        AbstractCli.println(String.format("    %s=xxx\t eg. long, default, ISO8601, yyyy-MM-dd HH:mm:ss.", SET_TIMESTAMP_DISPLAY));
        AbstractCli.println(String.format("    %s\t show time display type", SHOW_TIMESTAMP_DISPLAY));
        AbstractCli.println(String.format("    %s=xxx\t\t eg. +08:00, Asia/Shanghai.", SET_TIME_ZONE));
        AbstractCli.println(String.format("    %s\t\t show cli time zone", SHOW_TIMEZONE));
        AbstractCli.println(String.format("    %s=xxx\t\t set fetch size when querying data from server.", SET_FETCH_SIZE));
        AbstractCli.println(String.format("    %s\t\t show fetch size", SHOW_FETCH_SIZE));
        AbstractCli.println(String.format("    %s=xxx\t eg. set max lines for cli to ouput, -1 equals to unlimited.", SET_MAX_DISPLAY_NUM));
    }

    private static void setTimestampDisplay(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractCli.println(String.format("Time display format error, please input like %s=ISO8601", SET_TIMESTAMP_DISPLAY));
            return;
        }
        try {
            AbstractCli.setTimeFormat(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractCli.println(String.format("time display format error, %s", e.getMessage()));
            return;
        }
        AbstractCli.println("Time display type has set to " + cmd.split("=")[1].trim());
    }

    private static void setTimeZone(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractCli.println(String.format("Time zone format error, please input like %s=+08:00", SET_TIME_ZONE));
            return;
        }
        try {
            connection.setTimeZone(cmd.split("=")[1].trim());
        }
        catch (Exception e) {
            AbstractCli.println(String.format("Time zone format error: %s", e.getMessage()));
            return;
        }
        AbstractCli.println("Time zone has set to " + values[1].trim());
    }

    private static void setFetchSize(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractCli.println(String.format("Fetch size format error, please input like %s=10000", SET_FETCH_SIZE));
            return;
        }
        try {
            AbstractCli.setFetchSize(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractCli.println(String.format("Fetch size format error, %s", e.getMessage()));
            return;
        }
        AbstractCli.println("Fetch size has set to " + values[1].trim());
    }

    private static void setMaxDisplaNum(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractCli.println(String.format("Max display number format error, please input like %s = 10000", SET_MAX_DISPLAY_NUM));
            return;
        }
        try {
            AbstractCli.setMaxDisplayNumber(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractCli.println(String.format("Max display number format error, %s", e.getMessage()));
            return;
        }
        AbstractCli.println("Max display number has set to " + values[1].trim());
    }

    private static void showTimeZone(IoTDBConnection connection) {
        try {
            AbstractCli.println("Current time zone: " + connection.getTimeZone());
        }
        catch (Exception e) {
            AbstractCli.println("Cannot get time zone from server side because: " + e.getMessage());
        }
    }

    private static void importCmd(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split(" ");
        if (values.length != 2) {
            AbstractCli.println("Please input like: import /User/myfile. Noted that your file path cannot contain any space character)");
            return;
        }
        try {
            AbstractCli.println(cmd.split(" ")[1]);
            ImportCsv.importCsvFromFile(host, port, username, password, cmd.split(" ")[1], connection.getTimeZone());
        }
        catch (SQLException e) {
            AbstractCli.println(String.format("Failed to import from %s because %s", cmd.split(" ")[1], e.getMessage()));
        }
        catch (TException e) {
            AbstractCli.println("Cannot connect to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeQuery(IoTDBConnection connection, String cmd) {
        block22: {
            long startTime = System.currentTimeMillis();
            try (Statement statement = connection.createStatement();){
                ZoneId zoneId = ZoneId.of(connection.getTimeZone());
                statement.setFetchSize(fetchSize);
                boolean hasResultSet = statement.execute(cmd.trim());
                if (hasResultSet) {
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int columnLength = resultSetMetaData.getColumnCount();
                        ArrayList<Integer> maxSizeList = new ArrayList<Integer>(columnLength);
                        List<List<String>> lists = AbstractCli.cacheResult(resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                        AbstractCli.output(lists, maxSizeList);
                        long costTime = System.currentTimeMillis() - startTime;
                        AbstractCli.println(String.format("It costs %.3fs", (double)costTime / 1000.0));
                        while (!isReachEnd) {
                            AbstractCli.println(String.format("Reach the max_display_num = %s. Press ENTER to show more, input 'q' to quit.", maxPrintRowCount));
                            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                            try {
                                if (br.readLine().equals("")) {
                                    maxSizeList = new ArrayList(columnLength);
                                    lists = AbstractCli.cacheResult(resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                                    AbstractCli.output(lists, maxSizeList);
                                }
                                break block22;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block22;
                    }
                }
                AbstractCli.println("Msg: The statement is executed successfully.");
            }
            catch (Exception e) {
                AbstractCli.println("Msg: " + e.getMessage());
            }
            finally {
                AbstractCli.resetArgs();
            }
        }
    }

    private static List<List<String>> cacheResult(ResultSet resultSet, List<Integer> maxSizeList, int columnCount, ResultSetMetaData resultSetMetaData, ZoneId zoneId) throws SQLException {
        int i;
        ArrayList<List<String>> lists = new ArrayList<List<String>>(columnCount);
        if (resultSet instanceof IoTDBJDBCResultSet) {
            for (i = 1; i <= columnCount; ++i) {
                ArrayList<String> list = new ArrayList<String>(maxPrintRowCount + 1);
                list.add(resultSetMetaData.getColumnLabel(i));
                lists.add(list);
                maxSizeList.add(resultSetMetaData.getColumnLabel(i).length());
            }
        } else {
            for (i = 1; i <= columnCount; i += 2) {
                ArrayList<String> timeList = new ArrayList<String>(maxPrintRowCount + 1);
                timeList.add(resultSetMetaData.getColumnLabel(i).substring(0, TIMESTAMP_STR.length()));
                lists.add(timeList);
                ArrayList<String> valueList = new ArrayList<String>(maxPrintRowCount + 1);
                valueList.add(resultSetMetaData.getColumnLabel(i + 1));
                lists.add(valueList);
                maxSizeList.add(TIMESTAMP_STR.length());
                maxSizeList.add(resultSetMetaData.getColumnLabel(i + 1).length());
            }
        }
        int j = 0;
        if (cursorBeforeFirst) {
            isReachEnd = !resultSet.next();
            cursorBeforeFirst = false;
        }
        if (resultSet instanceof IoTDBJDBCResultSet) {
            boolean printTimestamp;
            boolean bl = printTimestamp = !((IoTDBJDBCResultSet)resultSet).isIgnoreTimeStamp();
            while (j < maxPrintRowCount && !isReachEnd) {
                for (int i2 = 1; i2 <= columnCount; ++i2) {
                    String tmp = printTimestamp && i2 == 1 ? AbstractCli.formatDatetime(resultSet.getLong(TIMESTAMP_STR), zoneId) : resultSet.getString(i2);
                    if (tmp == null) {
                        tmp = NULL;
                    }
                    ((List)lists.get(i2 - 1)).add(tmp);
                    if (maxSizeList.get(i2 - 1) >= tmp.length()) continue;
                    maxSizeList.set(i2 - 1, tmp.length());
                }
                ++j;
                isReachEnd = !resultSet.next();
            }
            return lists;
        }
        while (j < maxPrintRowCount && !isReachEnd) {
            for (int i3 = 1; i3 <= columnCount; ++i3) {
                String tmp = resultSet.getString(i3);
                if (tmp == null) {
                    tmp = NULL;
                }
                if (i3 % 2 != 0 && !tmp.equals(NULL)) {
                    tmp = AbstractCli.formatDatetime(Long.parseLong(tmp), zoneId);
                }
                ((List)lists.get(i3 - 1)).add(tmp);
                if (maxSizeList.get(i3 - 1) >= tmp.length()) continue;
                maxSizeList.set(i3 - 1, tmp.length());
            }
            ++j;
            isReachEnd = !resultSet.next();
        }
        return lists;
    }

    private static void output(List<List<String>> lists, List<Integer> maxSizeList) {
        AbstractCli.printBlockLine(maxSizeList);
        AbstractCli.printRow(lists, 0, maxSizeList);
        AbstractCli.printBlockLine(maxSizeList);
        for (int i = 1; i < lists.get(0).size(); ++i) {
            AbstractCli.printRow(lists, i, maxSizeList);
        }
        AbstractCli.printBlockLine(maxSizeList);
        if (isReachEnd) {
            AbstractCli.printCount(lineCount += lists.get(0).size() - 1);
        } else {
            lineCount += maxPrintRowCount;
        }
    }

    private static void resetArgs() {
        lineCount = 0;
        cursorBeforeFirst = true;
        isReachEnd = false;
    }

    private static void printBlockLine(List<Integer> maxSizeList) {
        StringBuilder blockLine = new StringBuilder();
        for (Integer integer : maxSizeList) {
            blockLine.append("+").append(StringUtils.repeat((String)"-", (int)integer));
        }
        blockLine.append("+");
        AbstractCli.println(blockLine.toString());
    }

    private static void printRow(List<List<String>> lists, int i, List<Integer> maxSizeList) {
        AbstractCli.printf("|", new Object[0]);
        for (int j = 0; j < maxSizeList.size(); ++j) {
            AbstractCli.printf("%" + maxSizeList.get(j) + "s|", lists.get(j).get(i));
        }
        AbstractCli.println();
    }

    private static void printf(String format, Object ... args) {
        SCREEN_PRINTER.printf(format, args);
    }

    static void print(String msg) {
        SCREEN_PRINTER.print(msg);
    }

    private static void println() {
        SCREEN_PRINTER.println();
    }

    static void println(String msg) {
        SCREEN_PRINTER.println(msg);
    }

    static boolean processCommand(String s, IoTDBConnection connection) {
        String[] cmds;
        if (s == null) {
            return true;
        }
        block4: for (String cmd : cmds = s.trim().split(";")) {
            if (cmd == null || "".equals(cmd.trim())) continue;
            OperationResult result = AbstractCli.handleInputCmd(cmd, connection);
            switch (result) {
                case STOP_OPER: {
                    return false;
                }
                case CONTINUE_OPER: {
                    continue block4;
                }
            }
        }
        return true;
    }

    static {
        hasExecuteSQL = false;
        keywordSet = new HashSet<String>();
        properties = null;
        SCREEN_PRINTER = new PrintStream(System.out);
        cursorBeforeFirst = true;
    }

    static enum OperationResult {
        STOP_OPER,
        CONTINUE_OPER,
        NO_OPER;

    }
}

