/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtils {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeUtils.class);
    private static final String COMMA_SEPERATOR = ",";
    private static final ReadWriteLock cntUpgradeFileLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock upgradeLogLock = new ReentrantReadWriteLock();

    public static ReadWriteLock getCntUpgradeFileLock() {
        return cntUpgradeFileLock;
    }

    public static ReadWriteLock getUpgradeLogLock() {
        return upgradeLogLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNeedUpgrade(TsFileResource tsFileResource) {
        tsFileResource.getWriteQueryLock().readLock().lock();
        if (tsFileResource.getFile().length() == 0L) {
            return false;
        }
        try (TsFileSequenceReader tsFileSequenceReader = new TsFileSequenceReader(tsFileResource.getFile().getAbsolutePath());){
            if (tsFileSequenceReader.readVersionNumber().equals("000001")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("meet error when judge whether file needs to be upgraded, the file's path:{}", (Object)tsFileResource.getFile().getAbsolutePath(), (Object)e);
        }
        finally {
            tsFileResource.getWriteQueryLock().readLock().unlock();
        }
        return false;
    }

    public static String getOneUpgradedFileName(TsFileResource upgradeResource) throws IOException {
        upgradeResource.deserialize();
        long firstPartitionId = upgradeResource.getTimePartition();
        File oldTsFile = upgradeResource.getFile();
        return oldTsFile.getParent() + File.separator + firstPartitionId + File.separator + oldTsFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverUpgrade() {
        if (SystemFileFactory.INSTANCE.getFile(UpgradeLog.getUpgradeLogPath()).exists()) {
            try (BufferedReader upgradeLogReader = new BufferedReader(new FileReader(SystemFileFactory.INSTANCE.getFile(UpgradeLog.getUpgradeLogPath())));){
                String line;
                HashMap<String, Integer> upgradeRecoverMap = new HashMap<String, Integer>();
                while ((line = upgradeLogReader.readLine()) != null) {
                    String oldFileName = line.split(COMMA_SEPERATOR)[0];
                    if (upgradeRecoverMap.containsKey(oldFileName)) {
                        upgradeRecoverMap.put(oldFileName, (Integer)upgradeRecoverMap.get(oldFileName) + 1);
                        continue;
                    }
                    upgradeRecoverMap.put(oldFileName, 1);
                }
                for (String key : upgradeRecoverMap.keySet()) {
                    File[] partitionDirs;
                    if (((Integer)upgradeRecoverMap.get(key)).intValue() == UpgradeCheckStatus.BEGIN_UPGRADE_FILE.getCheckStatusCode()) {
                        File[] partitionDirs2;
                        File upgradeDir = FSFactoryProducer.getFSFactory().getFile(key).getParentFile();
                        for (File partitionDir : partitionDirs2 = upgradeDir.listFiles()) {
                            File[] generatedFiles;
                            if (!partitionDir.isDirectory()) continue;
                            for (File generatedFile : generatedFiles = partitionDir.listFiles()) {
                                if (!generatedFile.getName().equals(FSFactoryProducer.getFSFactory().getFile(key).getName())) continue;
                                Files.delete(generatedFile.toPath());
                            }
                        }
                        continue;
                    }
                    if (((Integer)upgradeRecoverMap.get(key)).intValue() != UpgradeCheckStatus.AFTER_UPGRADE_FILE.getCheckStatusCode()) continue;
                    String upgradedFileName = UpgradeUtils.getOneUpgradedFileName(new TsFileResource(FSFactoryProducer.getFSFactory().getFile(key)));
                    if (FSFactoryProducer.getFSFactory().getFile(key).exists() && FSFactoryProducer.getFSFactory().getFile(upgradedFileName).exists()) {
                        Files.delete(FSFactoryProducer.getFSFactory().getFile(key).toPath());
                        Files.delete(FSFactoryProducer.getFSFactory().getFile(key + ".resource").toPath());
                    }
                    File upgradeDir = FSFactoryProducer.getFSFactory().getFile(key).getParentFile();
                    String storageGroupPath = upgradeDir.getParent();
                    for (File partitionDir : partitionDirs = upgradeDir.listFiles()) {
                        File[] generatedFiles;
                        if (!partitionDir.isDirectory()) continue;
                        String partitionId = partitionDir.getName();
                        File destPartitionDir = FSFactoryProducer.getFSFactory().getFile(storageGroupPath, partitionId);
                        if (!destPartitionDir.exists()) {
                            destPartitionDir.mkdir();
                        }
                        for (File generatedFile : generatedFiles = partitionDir.listFiles()) {
                            FSFactoryProducer.getFSFactory().moveFile(generatedFile, FSFactoryProducer.getFSFactory().getFile(destPartitionDir, generatedFile.getName()));
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("meet error when recover upgrade process, file path:{}", (Object)UpgradeLog.getUpgradeLogPath(), (Object)e);
            }
            finally {
                SystemFileFactory.INSTANCE.getFile(UpgradeLog.getUpgradeLogPath()).delete();
            }
        }
    }
}

