/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static Map<TSDataType, Set<TSEncoding>> schemaChecker = new EnumMap<TSDataType, Set<TSEncoding>>(TSDataType.class);
    private static final Logger logger;

    private SchemaUtils() {
    }

    public static void registerTimeseries(MeasurementSchema schema) {
        try {
            logger.debug("Registering timeseries {}", (Object)schema);
            String path = schema.getMeasurementId();
            TSDataType dataType = schema.getType();
            TSEncoding encoding = schema.getEncodingType();
            CompressionType compressionType = schema.getCompressor();
            MManager.getInstance().createTimeseries(path, dataType, encoding, compressionType, Collections.emptyMap());
        }
        catch (PathAlreadyExistException path) {
        }
        catch (MetadataException e) {
            logger.error("Cannot create timeseries {} in snapshot, ignored", (Object)schema.getMeasurementId(), (Object)e);
        }
    }

    public static List<TSDataType> getSeriesTypesByPath(Collection<Path> paths) throws MetadataException {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : paths) {
            dataTypes.add(MManager.getInstance().getSeriesType(path.getFullPath()));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByString(Collection<String> paths, String aggregation) throws MetadataException {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(paths.size(), dataType);
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (String path : paths) {
            dataTypes.add(MManager.getInstance().getSeriesType(path));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByPath(Collection<Path> paths, String aggregation) throws MetadataException {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(paths.size(), dataType);
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : paths) {
            dataTypes.add(MManager.getInstance().getSeriesType(path.getFullPath()));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByPath(List<Path> paths, List<String> aggregations) throws MetadataException {
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < paths.size(); ++i) {
            TSDataType dataType = SchemaUtils.getAggregationType(aggregations.get(i));
            if (dataType != null) {
                tsDataTypes.add(dataType);
                continue;
            }
            tsDataTypes.add(MManager.getInstance().getSeriesType(paths.get(i).getFullPath()));
        }
        return tsDataTypes;
    }

    public static TSDataType getAggregationType(String aggregation) throws MetadataException {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": {
                return TSDataType.INT64;
            }
            case "last_value": 
            case "first_value": 
            case "min_value": 
            case "max_value": {
                return null;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        throw new MetadataException("aggregate does not support " + aggregation + " function.");
    }

    public static void checkDataTypeWithEncoding(TSDataType dataType, TSEncoding encoding) throws MetadataException {
        if (!schemaChecker.get(dataType).contains(encoding)) {
            throw new MetadataException(String.format("encoding %s does not support %s", dataType.toString(), encoding.toString()));
        }
    }

    static {
        HashSet<TSEncoding> booleanSet = new HashSet<TSEncoding>();
        booleanSet.add(TSEncoding.PLAIN);
        booleanSet.add(TSEncoding.RLE);
        schemaChecker.put(TSDataType.BOOLEAN, booleanSet);
        HashSet<TSEncoding> int32Set = new HashSet<TSEncoding>();
        int32Set.add(TSEncoding.PLAIN);
        int32Set.add(TSEncoding.RLE);
        int32Set.add(TSEncoding.TS_2DIFF);
        int32Set.add(TSEncoding.REGULAR);
        schemaChecker.put(TSDataType.INT32, int32Set);
        schemaChecker.put(TSDataType.INT64, int32Set);
        HashSet<TSEncoding> floatSet = new HashSet<TSEncoding>();
        floatSet.add(TSEncoding.PLAIN);
        floatSet.add(TSEncoding.RLE);
        floatSet.add(TSEncoding.TS_2DIFF);
        floatSet.add(TSEncoding.GORILLA);
        schemaChecker.put(TSDataType.FLOAT, floatSet);
        schemaChecker.put(TSDataType.DOUBLE, floatSet);
        HashSet<TSEncoding> textSet = new HashSet<TSEncoding>();
        textSet.add(TSEncoding.PLAIN);
        schemaChecker.put(TSDataType.TEXT, textSet);
        logger = LoggerFactory.getLogger(SchemaUtils.class);
    }
}

