/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeSevice
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeSevice.class);
    private static final UpgradeSevice INSTANCE = new UpgradeSevice();
    private ExecutorService upgradeThreadPool;
    private AtomicInteger threadCnt = new AtomicInteger();
    private static int cntUpgradeFileNum;

    private UpgradeSevice() {
    }

    public static UpgradeSevice getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public void start() throws StartupException {
        int updateThreadNum = IoTDBDescriptor.getInstance().getConfig().getUpgradeThreadNum();
        if (updateThreadNum <= 0) {
            updateThreadNum = 1;
        }
        this.upgradeThreadPool = Executors.newFixedThreadPool(updateThreadNum, r -> new Thread(r, "UpgradeThread-" + this.threadCnt.getAndIncrement()));
        UpgradeLog.createUpgradeLog();
        UpgradeSevice.countUpgradeFiles();
        if (cntUpgradeFileNum == 0) {
            this.stop();
            return;
        }
        UpgradeSevice.upgradeAll();
    }

    @Override
    public void stop() {
        UpgradeLog.closeLogWriter();
        if (this.upgradeThreadPool != null) {
            this.upgradeThreadPool.shutdownNow();
            logger.info("Waiting for upgrade task pool to shut down");
            while (!this.upgradeThreadPool.isTerminated()) {
            }
            this.upgradeThreadPool = null;
            logger.info("Upgrade service stopped");
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UPGRADE_SERVICE;
    }

    public static void setCntUpgradeFileNum(int cntUpgradeFileNum) {
        UpgradeUtils.getCntUpgradeFileLock().writeLock().lock();
        try {
            UpgradeSevice.cntUpgradeFileNum = cntUpgradeFileNum;
        }
        finally {
            UpgradeUtils.getCntUpgradeFileLock().writeLock().unlock();
        }
    }

    public static int getCntUpgradeFileNum() {
        UpgradeUtils.getCntUpgradeFileLock().readLock().lock();
        try {
            int n = cntUpgradeFileNum;
            return n;
        }
        finally {
            UpgradeUtils.getCntUpgradeFileLock().readLock().unlock();
        }
    }

    public void submitUpgradeTask(UpgradeTask upgradeTask) {
        this.upgradeThreadPool.submit(upgradeTask);
    }

    private static void countUpgradeFiles() {
        cntUpgradeFileNum = StorageEngine.getInstance().countUpgradeFiles();
        logger.info("finish counting upgrading files, total num:{}", (Object)cntUpgradeFileNum);
    }

    private static void upgradeAll() {
        try {
            StorageEngine.getInstance().upgradeAll();
        }
        catch (StorageEngineException e) {
            logger.error("Cannot perform a global upgrade because", (Throwable)e);
        }
    }
}

