/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metrics.server.SqlArgument;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.NonAlignEngineDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.service.StaticResps;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.apache.thrift.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements TSIService.Iface,
ServerContext {
    private static final Logger logger = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final String INFO_NOT_LOGIN = "{}: Not login.";
    private static final int MAX_SIZE = IoTDBDescriptor.getInstance().getConfig().getQueryCacheSizeInMetric();
    private static final int DELETE_SIZE = 20;
    private static final String ERROR_PARSING_SQL = "meet error while parsing SQL to physical plan: {}";
    private static final List<SqlArgument> sqlArgumentList = new ArrayList<SqlArgument>(MAX_SIZE);
    protected Planner processor;
    protected IPlanExecutor executor;
    private boolean enableMetric = IoTDBDescriptor.getInstance().getConfig().isEnableMetricService();
    private Map<Long, String> sessionIdUsernameMap = new ConcurrentHashMap<Long, String>();
    private Map<Long, ZoneId> sessionIdZoneIdMap = new ConcurrentHashMap<Long, ZoneId>();
    private AtomicLong sessionIdGenerator = new AtomicLong();
    private AtomicLong statementIdGenerator = new AtomicLong();
    private Map<Long, Set<Long>> sessionId2StatementId = new ConcurrentHashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> statementId2QueryId = new ConcurrentHashMap<Long, Set<Long>>();
    private Map<Long, QueryDataSet> queryId2DataSet = new ConcurrentHashMap<Long, QueryDataSet>();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ThreadLocal<Long> currSessionId = new ThreadLocal();

    public TSServiceImpl() throws QueryProcessException {
        this.processor = new Planner();
        this.executor = new PlanExecutor();
    }

    public static List<SqlArgument> getSqlArgumentList() {
        return sqlArgumentList;
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        TSStatus tsStatus;
        boolean status;
        IAuthorizer authorizer;
        logger.info("{}: receive open session request from username {}", (Object)"IoTDB", (Object)req.getUsername());
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        String loginMessage = null;
        try {
            status = authorizer.login(req.getUsername(), req.getPassword());
        }
        catch (AuthException e) {
            logger.info("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        long sessionId = -1L;
        if (status) {
            boolean compatible = this.checkCompatibility(req.getClient_protocol());
            if (!compatible) {
                TSStatus tsStatus2 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INCOMPATIBLE_VERSION, (String)("The version is incompatible, please upgrade to " + IoTDBConstant.VERSION));
                TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus2, TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V2);
                resp.setSessionId(sessionId);
                return resp;
            }
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Login successfully");
            sessionId = this.sessionIdGenerator.incrementAndGet();
            this.sessionIdUsernameMap.put(sessionId, req.getUsername());
            this.sessionIdZoneIdMap.put(sessionId, this.config.getZoneID());
            this.currSessionId.set(sessionId);
        } else {
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR);
            tsStatus.setMessage(loginMessage);
        }
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V2);
        resp.setSessionId(sessionId);
        logger.info("{}: Login status: {}. User : {}", new Object[]{"IoTDB", tsStatus.message, req.getUsername()});
        return resp;
    }

    private boolean checkCompatibility(TSProtocolVersion version) {
        return version.equals((Object)TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V2);
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        logger.info("{}: receive close session", (Object)"IoTDB");
        long sessionId = this.currSessionId.get();
        this.currSessionId.remove();
        TSStatus tsStatus = this.sessionIdUsernameMap.remove(sessionId) == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        this.sessionIdZoneIdMap.remove(sessionId);
        ArrayList<StorageEngineException> exceptions = new ArrayList<StorageEngineException>();
        Set statementIds = this.sessionId2StatementId.getOrDefault(sessionId, Collections.emptySet());
        Iterator iterator = statementIds.iterator();
        while (iterator.hasNext()) {
            long statementId = (Long)iterator.next();
            Set queryIds = this.statementId2QueryId.getOrDefault(statementId, Collections.emptySet());
            Iterator iterator2 = queryIds.iterator();
            while (iterator2.hasNext()) {
                long queryId = (Long)iterator2.next();
                try {
                    this.releaseQueryResource(queryId);
                }
                catch (StorageEngineException e) {
                    exceptions.add(e);
                    logger.error("Error in closeSession : ", (Throwable)e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            return new TSStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLOSE_OPERATION_ERROR, (String)String.format("%d errors in closeOperation, see server logs for detail", exceptions.size())));
        }
        return new TSStatus(tsStatus);
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: receive close operation", (Object)"IoTDB");
        }
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        try {
            if (req.isSetStatementId()) {
                long stmtId = req.getStatementId();
                Set<Long> queryIdSet = this.statementId2QueryId.remove(stmtId);
                if (queryIdSet != null) {
                    for (long queryId : queryIdSet) {
                        this.releaseQueryResource(queryId);
                    }
                }
            } else {
                this.releaseQueryResource(req.queryId);
            }
        }
        catch (Exception e) {
            logger.error("Error in closeOperation : ", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLOSE_OPERATION_ERROR, (String)"Error in closeOperation");
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    protected void releaseQueryResource(long queryId) throws StorageEngineException {
        this.queryId2DataSet.remove(queryId);
        QueryResourceManager.getInstance().endQuery(queryId);
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TSStatus status;
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            TSStatus status2 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            return new TSFetchMetadataResp(status2);
        }
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        try {
            switch (req.getType()) {
                case "METADATA_IN_JSON": {
                    String metadataInJson = this.getMetadataInString();
                    resp.setMetadataInJson(metadataInJson);
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "COLUMN": {
                    List<TSDataType> dataTypes = this.getSeriesTypesByString(Collections.singletonList(req.getColumnPath()), null);
                    resp.setDataType(dataTypes.get(0).toString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(req.getColumnPath()));
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                default: {
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)req.getType());
                    break;
                }
            }
        }
        catch (OutOfMemoryError | MetadataException e) {
            logger.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), e);
            TSStatus status3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage());
            resp.setStatus(status3);
            return resp;
        }
        catch (Exception e) {
            logger.error("Error in fetchMetadata : ", (Throwable)e);
            TSStatus status4 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            resp.setStatus(status4);
            return resp;
        }
        resp.setStatus(status);
        return resp;
    }

    private String getMetadataInString() {
        return MManager.getInstance().getMetadataInString();
    }

    protected List<String> getPaths(String path) throws MetadataException {
        return MManager.getInstance().getAllTimeseriesName(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteBatchStatementResp executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> result = new ArrayList<TSStatus>();
        try {
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp2 = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSExecuteBatchStatementResp2;
            }
            List statements = req.getStatements();
            boolean isAllSuccessful = true;
            for (String statement : statements) {
                long t2 = System.currentTimeMillis();
                isAllSuccessful = this.executeStatementInBatch(statement, result, req.getSessionId()) && isAllSuccessful;
                Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
            }
            if (isAllSuccessful) {
                tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully");
                return tSExecuteBatchStatementResp;
            }
            tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp(result);
            return tSExecuteBatchStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            return tSExecuteBatchStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        }
    }

    private boolean executeStatementInBatch(String statement, List<TSStatus> result, long sessionId) {
        try {
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(sessionId));
            if (physicalPlan.isQuery()) {
                throw new QueryInBatchStatementException(statement);
            }
            TSExecuteStatementResp resp = this.executeUpdateStatement(physicalPlan, sessionId);
            if (resp.getStatus().code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                result.add(resp.status);
                return false;
            }
            result.add(resp.status);
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)(statement + " " + e.getMessage()));
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)("meet error while parsing SQL to physical plan: {} " + statement + " " + e.getMessage())));
            return false;
        }
        catch (SQLParserException e) {
            logger.error("Error occurred when executing {}, check metadata error: ", (Object)statement, (Object)e);
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)("meet error while parsing SQL to physical plan: {} " + statement + " " + e.getMessage())));
            return false;
        }
        catch (QueryProcessException e) {
            logger.info("Error occurred when executing {}, meet error while parsing SQL to physical plan: {}", (Object)statement, (Object)e.getMessage());
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)("Meet error in query process: " + e.getMessage())));
            return false;
        }
        catch (QueryInBatchStatementException e) {
            logger.info("Error occurred when executing {}, query statement not allowed: ", (Object)statement, (Object)e);
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)("query statement not allowed: " + statement)));
            return false;
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("server Internal Error: " + e.getMessage())));
        }
        return true;
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(req.getSessionId()));
            if (physicalPlan.isQuery()) {
                return this.internalExecuteQueryStatement(statement, req.statementId, physicalPlan, req.fetchSize, this.sessionIdUsernameMap.get(req.getSessionId()));
            }
            return this.executeUpdateStatement(physicalPlan, req.getSessionId());
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)(req.getStatement() + " " + e.getMessage()));
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
        }
        catch (SQLParserException e) {
            logger.error("check metadata error: ", (Throwable)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)("Check metadata error: " + e.getMessage()));
        }
        catch (QueryProcessException e) {
            logger.info(ERROR_PARSING_SQL, (Object)e.getMessage());
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)("Meet error in query process: " + e.getMessage())));
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        try {
            PhysicalPlan physicalPlan;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            try {
                physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(req.getSessionId()));
            }
            catch (QueryProcessException | SQLParserException e) {
                logger.info(ERROR_PARSING_SQL, (Object)e.getMessage());
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
            }
            if (!physicalPlan.isQuery()) {
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
            }
            return this.internalExecuteQueryStatement(statement, req.statementId, physicalPlan, req.fetchSize, this.sessionIdUsernameMap.get(req.getSessionId()));
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)(req.getStatement() + " " + e.getMessage()));
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)(ERROR_PARSING_SQL + e.getMessage()));
        }
        catch (SQLParserException e) {
            logger.error("check metadata error: ", (Throwable)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)("Check metadata error: " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp internalExecuteQueryStatement(String statement, long statementId, PhysicalPlan plan, int fetchSize, String username) {
        long startTime = System.currentTimeMillis();
        long queryId = -1L;
        try {
            TSQueryDataSet result;
            TSExecuteStatementResp resp = this.getQueryResp(plan, username);
            if (plan instanceof QueryPlan && !((QueryPlan)plan).isAlignByTime()) {
                if (plan.getOperatorType() == Operator.OperatorType.AGGREGATION) {
                    throw new QueryProcessException("Aggregation doesn't support disable align clause.");
                }
                if (plan.getOperatorType() == Operator.OperatorType.FILL) {
                    throw new QueryProcessException("Fill doesn't support disable align clause.");
                }
                if (plan.getOperatorType() == Operator.OperatorType.GROUPBY) {
                    throw new QueryProcessException("Group by doesn't support disable align clause.");
                }
            }
            if (plan.getOperatorType() == Operator.OperatorType.AGGREGATION) {
                resp.setIgnoreTimeStamp(true);
            }
            resp.setOperationType(plan.getOperatorType().toString());
            queryId = this.generateQueryId(true);
            this.statementId2QueryId.computeIfAbsent(statementId, k -> new HashSet()).add(queryId);
            QueryDataSet newDataSet = this.createQueryDataSet(queryId, plan);
            if (plan instanceof QueryPlan && !((QueryPlan)plan).isAlignByTime() && newDataSet instanceof NonAlignEngineDataSet) {
                result = this.fillRpcNonAlignReturnData(fetchSize, newDataSet, username);
                resp.setNonAlignQueryDataSet((TSQueryNonAlignDataSet)result);
            } else {
                if (plan instanceof ShowPlan && ((ShowPlan)plan).getShowContentType() == ShowPlan.ShowContentType.TIMESERIES) {
                    resp.setColumns(newDataSet.getPaths().stream().map(Path::getFullPath).collect(Collectors.toList()));
                    resp.setDataTypeList(newDataSet.getDataTypes().stream().map(Enum::toString).collect(Collectors.toList()));
                }
                result = this.fillRpcReturnData(fetchSize, newDataSet, username);
                resp.setQueryDataSet(result);
            }
            resp.setQueryId(queryId);
            if (this.enableMetric) {
                long endTime = System.currentTimeMillis();
                SqlArgument sqlArgument = new SqlArgument(resp, plan, statement, startTime, endTime);
                List<SqlArgument> list = sqlArgumentList;
                synchronized (list) {
                    sqlArgumentList.add(sqlArgument);
                    if (sqlArgumentList.size() >= MAX_SIZE) {
                        sqlArgumentList.subList(0, 20).clear();
                    }
                }
            }
            TSExecuteStatementResp tSExecuteStatementResp = resp;
            return tSExecuteStatementResp;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            TSExecuteStatementResp newDataSet = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            return newDataSet;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            if (queryId != -1L) {
                try {
                    this.releaseQueryResource(queryId);
                }
                catch (StorageEngineException ex) {
                    logger.error("Error happened while releasing query resource: ", (Throwable)ex);
                }
            }
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            return tSExecuteStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
        }
    }

    private TSExecuteStatementResp getQueryResp(PhysicalPlan plan, String username) throws QueryProcessException, AuthException, TException, MetadataException {
        if (plan instanceof AuthorPlan) {
            return this.getAuthQueryColumnHeaders(plan);
        }
        if (plan instanceof ShowPlan) {
            return this.getShowQueryColumnHeaders((ShowPlan)plan);
        }
        return this.getQueryColumnHeaders(plan, username);
    }

    private TSExecuteStatementResp getShowQueryColumnHeaders(ShowPlan showPlan) throws QueryProcessException {
        switch (showPlan.getShowContentType()) {
            case TTL: {
                return StaticResps.TTL_RESP;
            }
            case FLUSH_TASK_INFO: {
                return StaticResps.FLUSH_INFO_RESP;
            }
            case DYNAMIC_PARAMETER: {
                return StaticResps.DYNAMIC_PARAMETER_RESP;
            }
            case VERSION: {
                return StaticResps.SHOW_VERSION_RESP;
            }
            case TIMESERIES: {
                return StaticResps.SHOW_TIMESERIES_RESP;
            }
            case STORAGE_GROUP: {
                return StaticResps.SHOW_STORAGE_GROUP;
            }
            case CHILD_PATH: {
                return StaticResps.SHOW_CHILD_PATHS;
            }
            case DEVICES: {
                return StaticResps.SHOW_DEVICES;
            }
            case COUNT_NODE_TIMESERIES: {
                return StaticResps.COUNT_NODE_TIMESERIES;
            }
            case COUNT_NODES: {
                return StaticResps.COUNT_NODES;
            }
            case COUNT_TIMESERIES: {
                return StaticResps.COUNT_TIMESERIES;
            }
        }
        logger.error("Unsupported show content type: {}", (Object)showPlan.getShowContentType());
        throw new QueryProcessException("Unsupported show content type:" + (Object)((Object)showPlan.getShowContentType()));
    }

    private TSExecuteStatementResp getAuthQueryColumnHeaders(PhysicalPlan plan) {
        AuthorPlan authorPlan = (AuthorPlan)plan;
        switch (authorPlan.getAuthorType()) {
            case LIST_ROLE: 
            case LIST_USER_ROLES: {
                return StaticResps.LIST_ROLE_RESP;
            }
            case LIST_USER: 
            case LIST_ROLE_USERS: {
                return StaticResps.LIST_USER_RESP;
            }
            case LIST_ROLE_PRIVILEGE: {
                return StaticResps.LIST_ROLE_PRIVILEGE_RESP;
            }
            case LIST_USER_PRIVILEGE: {
                return StaticResps.LIST_USER_PRIVILEGE_RESP;
            }
        }
        return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)String.format("%s is not an auth query", new Object[]{authorPlan.getAuthorType()})));
    }

    private TSExecuteStatementResp getQueryColumnHeaders(PhysicalPlan physicalPlan, String username) throws AuthException, TException, QueryProcessException, MetadataException {
        ArrayList<String> respColumns = new ArrayList<String>();
        ArrayList<String> columnsTypes = new ArrayList<String>();
        if (!this.checkAuthorization(physicalPlan.getPaths(), physicalPlan, username)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + (Object)((Object)physicalPlan.getOperatorType()))));
        }
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        QueryPlan plan = (QueryPlan)physicalPlan;
        if (plan instanceof AlignByDevicePlan) {
            this.getAlignByDeviceQueryHeaders((AlignByDevicePlan)plan, respColumns, columnsTypes);
        } else {
            if (plan instanceof LastQueryPlan) {
                return StaticResps.LAST_RESP.deepCopy();
            }
            this.getWideQueryHeaders(plan, respColumns, columnsTypes);
            resp.setColumnNameIndexMap(plan.getPathToIndex());
        }
        resp.setColumns(respColumns);
        resp.setDataTypeList(columnsTypes);
        return resp;
    }

    private void getWideQueryHeaders(QueryPlan plan, List<String> respColumns, List<String> columnTypes) throws TException, QueryProcessException, MetadataException {
        List<TSDataType> seriesTypes;
        List<Path> paths = plan.getPaths();
        switch (plan.getOperatorType()) {
            case QUERY: 
            case FILL: {
                for (Path p : paths) {
                    if (p.getAlias() != null) {
                        respColumns.add(p.getFullPathWithAlias());
                        continue;
                    }
                    respColumns.add(p.getFullPath());
                }
                seriesTypes = this.getSeriesTypesByString(respColumns, null);
                break;
            }
            case AGGREGATION: 
            case GROUPBY: 
            case GROUP_BY_FILL: {
                int i;
                List<String> aggregations = plan.getAggregations();
                if (aggregations.size() != paths.size()) {
                    for (i = 1; i < paths.size(); ++i) {
                        aggregations.add(aggregations.get(0));
                    }
                }
                for (i = 0; i < paths.size(); ++i) {
                    if (paths.get(i).getAlias() != null) {
                        respColumns.add(aggregations.get(i) + "(" + paths.get(i).getFullPathWithAlias() + ")");
                        continue;
                    }
                    respColumns.add(aggregations.get(i) + "(" + paths.get(i).getFullPath() + ")");
                }
                seriesTypes = this.getSeriesTypesByPath(paths, aggregations);
                break;
            }
            default: {
                throw new TException("unsupported query type: " + (Object)((Object)plan.getOperatorType()));
            }
        }
        for (TSDataType seriesType : seriesTypes) {
            columnTypes.add(seriesType.toString());
        }
    }

    private void getAlignByDeviceQueryHeaders(AlignByDevicePlan plan, List<String> respColumns, List<String> columnTypes) {
        respColumns.add("Device");
        columnTypes.add(TSDataType.TEXT.toString());
        ArrayList<TSDataType> deduplicatedColumnsType = new ArrayList<TSDataType>();
        deduplicatedColumnsType.add(TSDataType.TEXT);
        LinkedHashSet<String> deduplicatedMeasurements = new LinkedHashSet<String>();
        Map<String, TSDataType> measurementDataTypeMap = plan.getColumnDataTypeMap();
        List<String> measurements = plan.getMeasurements();
        Map<String, AlignByDevicePlan.MeasurementType> measurementTypeMap = plan.getMeasurementTypeMap();
        for (String measurement : measurements) {
            TSDataType type = null;
            switch (measurementTypeMap.get(measurement)) {
                case Exist: {
                    type = measurementDataTypeMap.get(measurement);
                    break;
                }
                case NonExist: 
                case Constant: {
                    type = TSDataType.TEXT;
                }
            }
            respColumns.add(measurement);
            columnTypes.add(type.toString());
            if (deduplicatedMeasurements.contains(measurement)) continue;
            deduplicatedMeasurements.add(measurement);
            deduplicatedColumnsType.add(type);
        }
        plan.setMeasurements(new ArrayList<String>(deduplicatedMeasurements));
        plan.setDataTypes(deduplicatedColumnsType);
        plan.setPaths(null);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (!this.queryId2DataSet.containsKey(req.queryId)) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Has not executed query"));
            }
            QueryDataSet queryDataSet = this.queryId2DataSet.get(req.queryId);
            if (req.isAlign) {
                boolean hasResultSet;
                TSQueryDataSet result = this.fillRpcReturnData(req.fetchSize, queryDataSet, this.sessionIdUsernameMap.get(req.sessionId));
                boolean bl = hasResultSet = result.bufferForTime().limit() != 0;
                if (!hasResultSet) {
                    this.releaseQueryResource(req.queryId);
                }
                TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                resp.setHasResultSet(hasResultSet);
                resp.setQueryDataSet(result);
                resp.setIsAlign(true);
                return resp;
            }
            TSQueryNonAlignDataSet nonAlignResult = this.fillRpcNonAlignReturnData(req.fetchSize, queryDataSet, this.sessionIdUsernameMap.get(req.sessionId));
            boolean hasResultSet = false;
            for (ByteBuffer timeBuffer : nonAlignResult.getTimeList()) {
                if (timeBuffer.limit() == 0) continue;
                hasResultSet = true;
                break;
            }
            if (!hasResultSet) {
                this.queryId2DataSet.remove(req.queryId);
            }
            TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            resp.setHasResultSet(hasResultSet);
            resp.setNonAlignQueryDataSet(nonAlignResult);
            resp.setIsAlign(false);
            return resp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            try {
                this.releaseQueryResource(req.queryId);
            }
            catch (StorageEngineException ex) {
                logger.error("Error happened while releasing query resource: ", (Throwable)ex);
            }
            return RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    private TSQueryDataSet fillRpcReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, InterruptedException {
        TSQueryDataSet result;
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        if (this.config.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (!this.config.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", this.config.getWatermarkMethodName()));
            }
            GroupedLSBWatermarkEncoder encoder = new GroupedLSBWatermarkEncoder(this.config);
            result = queryDataSet instanceof RawQueryDataSetWithoutValueFilter ? ((RawQueryDataSetWithoutValueFilter)queryDataSet).fillBuffer(fetchSize, encoder) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, encoder);
        } else {
            result = queryDataSet instanceof RawQueryDataSetWithoutValueFilter ? ((RawQueryDataSetWithoutValueFilter)queryDataSet).fillBuffer(fetchSize, null) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize);
        }
        return result;
    }

    private TSQueryNonAlignDataSet fillRpcNonAlignReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, InterruptedException {
        TSQueryNonAlignDataSet result;
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        if (this.config.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (!this.config.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", this.config.getWatermarkMethodName()));
            }
            GroupedLSBWatermarkEncoder encoder = new GroupedLSBWatermarkEncoder(this.config);
            result = ((NonAlignEngineDataSet)queryDataSet).fillBuffer(fetchSize, encoder);
        } else {
            result = ((NonAlignEngineDataSet)queryDataSet).fillBuffer(fetchSize, null);
        }
        return result;
    }

    private QueryDataSet createQueryDataSet(long queryId, PhysicalPlan physicalPlan) throws QueryProcessException, QueryFilterOptimizationException, StorageEngineException, IOException, MetadataException, SQLException {
        QueryContext context = this.genQueryContext(queryId);
        QueryDataSet queryDataSet = this.executor.processQuery(physicalPlan, context);
        this.queryId2DataSet.put(queryId, queryDataSet);
        return queryDataSet;
    }

    protected QueryContext genQueryContext(long queryId) {
        return new QueryContext(queryId);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            return this.executeUpdateStatement(statement, req.getSessionId());
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(PhysicalPlan plan, long sessionId) {
        TSStatus status = this.checkAuthority(plan, sessionId);
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        status = this.executePlan(plan);
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
        long queryId = this.generateQueryId(false);
        resp.setQueryId(queryId);
        return resp;
    }

    private boolean executeNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new QueryProcessException("Current system mode is read-only, does not support non-query operation");
        }
        return this.executor.processNonQuery(plan);
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement, long sessionId) {
        PhysicalPlan physicalPlan;
        try {
            physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(sessionId));
        }
        catch (QueryProcessException | SQLParserException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)statement, (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
        }
        if (physicalPlan.isQuery()) {
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is a query statement.");
        }
        return this.executeUpdateStatement(physicalPlan, sessionId);
    }

    private boolean checkLogin(long sessionId) {
        return this.sessionIdUsernameMap.get(sessionId) != null;
    }

    private boolean checkAuthorization(List<Path> paths, PhysicalPlan plan, String username) throws AuthException {
        String targetUser = null;
        if (plan instanceof AuthorPlan) {
            targetUser = ((AuthorPlan)plan).getUserName();
        }
        return AuthorityChecker.check(username, paths, plan.getOperatorType(), targetUser);
    }

    protected void handleClientExit() {
        Long sessionId = this.currSessionId.get();
        if (sessionId != null) {
            TSCloseSessionReq req = new TSCloseSessionReq(sessionId.longValue());
            this.closeSession(req);
        }
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        TSGetTimeZoneResp resp = null;
        try {
            TSStatus tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            ZoneId zoneId = this.sessionIdZoneIdMap.get(sessionId);
            if (zoneId != null) {
                resp = new TSGetTimeZoneResp(tsStatus, zoneId.toString());
            }
        }
        catch (Exception e) {
            logger.error("meet error while generating time zone.", (Throwable)e);
            TSStatus tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.GENERATE_TIME_ZONE_ERROR);
            resp = new TSGetTimeZoneResp(tsStatus, "Unknown time zone");
        }
        return resp;
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        TSStatus tsStatus;
        try {
            String timeZoneID = req.getTimeZone();
            this.sessionIdZoneIdMap.put(req.getSessionId(), ZoneId.of(timeZoneID));
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            logger.error("meet error while setting time zone.", (Throwable)e);
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SET_TIME_ZONE_ERROR);
        }
        return new TSStatus(tsStatus);
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        logger.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        return properties;
    }

    public TSExecuteBatchStatementResp insertRecords(TSInsertRecordsReq req) {
        TSExecuteBatchStatementResp resp = new TSExecuteBatchStatementResp();
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            resp.addToStatusList(RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR));
            return resp;
        }
        InsertPlan plan = new InsertPlan();
        for (int i = 0; i < req.deviceIds.size(); ++i) {
            try {
                plan.setDeviceId((String)req.getDeviceIds().get(i));
                plan.setTime((Long)req.getTimestamps().get(i));
                plan.setMeasurements(((List)req.getMeasurementsList().get(i)).toArray(new String[0]));
                plan.setTypes(new TSDataType[plan.getMeasurements().length]);
                plan.setValues(new Object[plan.getMeasurements().length]);
                plan.setValues((ByteBuffer)req.valuesList.get(i));
                plan.setInferType(req.isInferType());
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    resp.addToStatusList(status);
                    continue;
                }
                resp.addToStatusList(this.executePlan(plan));
                continue;
            }
            catch (Exception e) {
                logger.error("meet error when insert in batch", (Throwable)e);
                resp.addToStatusList(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR));
            }
        }
        return resp;
    }

    public TSExecuteBatchStatementResp testInsertTablet(TSInsertTabletReq req) {
        logger.debug("Test insert batch request receive.");
        return RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSExecuteBatchStatementResp testInsertTablets(TSInsertTabletsReq req) throws TException {
        logger.debug("Test insert batch request receive.");
        return RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        logger.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSExecuteBatchStatementResp testInsertRecords(TSInsertRecordsReq req) {
        logger.debug("Test insert row in batch request receive.");
        return RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus insertRecord(TSInsertRecordReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            InsertPlan plan = new InsertPlan();
            plan.setDeviceId(req.getDeviceId());
            plan.setTime(req.getTimestamp());
            plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
            plan.setTypes(new TSDataType[plan.getMeasurements().length]);
            plan.setValues(new Object[plan.getMeasurements().length]);
            plan.setValues(req.values);
            plan.setInferType(req.isInferType());
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                return status;
            }
            return this.executePlan(plan);
        }
        catch (Exception e) {
            logger.error("meet error when insert", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        DeletePlan plan = new DeletePlan();
        plan.setDeleteTime(req.getTimestamp());
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String path : req.getPaths()) {
            paths.add(new Path(path));
        }
        plan.addPaths(paths);
        TSStatus status = this.checkAuthority(plan, req.getSessionId());
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteBatchStatementResp insertTablet(TSInsertTabletReq req) {
        long t1 = System.currentTimeMillis();
        try {
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp;
            TSExecuteBatchStatementResp tsStatusArray;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp2 = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSExecuteBatchStatementResp2;
            }
            InsertTabletPlan insertTabletPlan = new InsertTabletPlan(req.deviceId, req.measurements);
            insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer(req.timestamps, req.size));
            insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer(req.values, req.types, req.measurements.size(), req.size));
            insertTabletPlan.setRowCount(req.size);
            insertTabletPlan.setDataTypes(req.types);
            boolean isAllSuccessful = true;
            TSStatus status = this.checkAuthority(insertTabletPlan, req.getSessionId());
            if (status != null) {
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp3 = RpcUtils.getTSBatchExecuteStatementResp((TSStatus)status);
                return tSExecuteBatchStatementResp3;
            }
            for (TSStatus tsStatus : tsStatusArray = this.executor.insertTablet(insertTabletPlan)) {
                if (tsStatus.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                isAllSuccessful = false;
                break;
            }
            if (isAllSuccessful) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Insert one Tablet successfully");
                }
                tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSExecuteBatchStatementResp;
            }
            logger.debug("Insert one Tablet failed!");
            tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp(Arrays.asList(tsStatusArray));
            return tSExecuteBatchStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: error occurs when executing statements", (Object)"IoTDB", (Object)e);
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            return tSExecuteBatchStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteBatchStatementResp insertTablets(TSInsertTabletsReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSExecuteBatchStatementResp;
            }
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            for (int i = 0; i < req.deviceIds.size(); ++i) {
                InsertTabletPlan insertTabletPlan = new InsertTabletPlan((String)req.deviceIds.get(i), (List)req.measurementsList.get(i));
                insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer((ByteBuffer)req.timestampsList.get(i), (Integer)req.sizeList.get(i)));
                insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer((ByteBuffer)req.valuesList.get(i), (List)req.typesList.get(i), ((List)req.measurementsList.get(i)).size(), (int)((Integer)req.sizeList.get(i))));
                insertTabletPlan.setRowCount((Integer)req.sizeList.get(i));
                insertTabletPlan.setDataTypes((List)req.typesList.get(i));
                boolean isCurrentTabletSuccessful = true;
                TSStatus status = this.checkAuthority(insertTabletPlan, req.getSessionId());
                if (status != null) {
                    statusList.add(status);
                    continue;
                }
                TSStatus[] tsStatusArray = this.executor.insertTablet(insertTabletPlan);
                TSStatus failed = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR);
                for (TSStatus tsStatus : tsStatusArray) {
                    if (tsStatus.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    isCurrentTabletSuccessful = false;
                    failed = tsStatus;
                    break;
                }
                if (isCurrentTabletSuccessful) {
                    statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
                    continue;
                }
                statusList.add(failed);
            }
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp(statusList);
            return tSExecuteBatchStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: error occurs when insertTablets", (Object)"IoTDB", (Object)e);
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp = RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            return tSExecuteBatchStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        if (!this.checkLogin(sessionId)) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        TSStatus status = this.checkPathValidity(storageGroup);
        if (status != null) {
            return status;
        }
        SetStorageGroupPlan plan = new SetStorageGroupPlan(new Path(storageGroup));
        status = this.checkAuthority(plan, sessionId);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        if (!this.checkLogin(sessionId)) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        ArrayList<Path> storageGroupList = new ArrayList<Path>();
        for (String storageGroup : storageGroups) {
            storageGroupList.add(new Path(storageGroup));
        }
        DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(storageGroupList);
        TSStatus status = this.checkAuthority(plan, sessionId);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        TSStatus status = this.checkPathValidity(req.path);
        if (status != null) {
            return status;
        }
        CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new Path(req.path), TSDataType.values()[req.dataType], TSEncoding.values()[req.encoding], CompressionType.values()[req.compressor], req.props, req.tags, req.attributes, req.measurementAlias);
        status = this.checkAuthority(plan, req.getSessionId());
        if (status != null) {
            return status;
        }
        return this.executePlan(plan);
    }

    public TSExecuteBatchStatementResp createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>(req.paths.size());
        for (int i = 0; i < req.paths.size(); ++i) {
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new Path((String)req.getPaths().get(i)), TSDataType.values()[(Integer)req.dataTypes.get(i)], TSEncoding.values()[(Integer)req.encodings.get(i)], CompressionType.values()[(Integer)req.compressors.get(i)], req.propsList == null ? null : (Map)req.propsList.get(i), req.tagsList == null ? null : (Map)req.tagsList.get(i), req.attributesList == null ? null : (Map)req.attributesList.get(i), req.measurementAliasList == null ? null : (String)req.measurementAliasList.get(i));
            TSStatus status = this.checkPathValidity((String)req.paths.get(i));
            if (status != null) {
                statusList.add(status);
                continue;
            }
            status = this.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                statusList.add(status);
                continue;
            }
            statusList.add(this.executePlan(plan));
        }
        boolean isAllSuccessful = true;
        for (TSStatus tsStatus : statusList) {
            if (tsStatus.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            isAllSuccessful = false;
            break;
        }
        if (isAllSuccessful) {
            if (logger.isDebugEnabled()) {
                logger.debug("Create multiple timeseries successfully");
            }
            return RpcUtils.getTSBatchExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        logger.debug("Create multiple timeseries failed!");
        return RpcUtils.getTSBatchExecuteStatementResp(statusList);
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> paths) {
        if (!this.checkLogin(sessionId)) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (String path : paths) {
            pathList.add(new Path(path));
        }
        DeleteTimeSeriesPlan plan = new DeleteTimeSeriesPlan(pathList);
        TSStatus status = this.checkAuthority(plan, sessionId);
        if (status != null) {
            return status;
        }
        return this.executePlan(plan);
    }

    public long requestStatementId(long sessionId) {
        long statementId = this.statementIdGenerator.incrementAndGet();
        this.sessionId2StatementId.computeIfAbsent(sessionId, s -> new HashSet()).add(statementId);
        return statementId;
    }

    private TSStatus checkAuthority(PhysicalPlan plan, long sessionId) {
        List<Path> paths = plan.getPaths();
        try {
            if (!this.checkAuthorization(paths, plan, this.sessionIdUsernameMap.get(sessionId))) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + plan.getOperatorType().toString()));
            }
        }
        catch (AuthException e) {
            logger.error("meet error while checking authorization.", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNINITIALIZED_AUTH_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return null;
    }

    protected TSStatus executePlan(PhysicalPlan plan) {
        boolean execRet;
        try {
            execRet = this.executeNonQuery(plan);
        }
        catch (QueryProcessException e) {
            logger.debug("meet error while processing non-query. ", (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return execRet ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
    }

    private TSStatus checkPathValidity(String path) {
        if (!IoTDBConfig.PATH_PATTERN.matcher(path).matches()) {
            logger.warn("Illegal path: {}", (Object)path);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PATH_ILLEGAL, (String)(path + " path is illegal"));
        }
        return null;
    }

    private long generateQueryId(boolean isDataQuery) {
        return QueryResourceManager.getInstance().assignQueryId(isDataQuery);
    }

    protected List<TSDataType> getSeriesTypesByPath(List<Path> paths, List<String> aggregations) throws MetadataException {
        return SchemaUtils.getSeriesTypesByPath(paths, aggregations);
    }

    protected List<TSDataType> getSeriesTypesByString(List<String> paths, String aggregation) throws MetadataException {
        return SchemaUtils.getSeriesTypesByString(paths, aggregation);
    }
}

