/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

class StaticResps {
    static final TSExecuteStatementResp TTL_RESP = StaticResps.getNoTimeExecuteResp(Arrays.asList("storage group", "ttl"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.INT64.toString()));
    static final TSExecuteStatementResp FLUSH_INFO_RESP = StaticResps.getNoTimeExecuteResp(Arrays.asList("                             item", "value"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp DYNAMIC_PARAMETER_RESP = StaticResps.getNoTimeExecuteResp(Arrays.asList("                                          parameter", "value"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp SHOW_VERSION_RESP = StaticResps.getNoTimeExecuteResp(Collections.singletonList("        version"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp SHOW_TIMESERIES_RESP = StaticResps.getNoTimeExecuteResp(Arrays.asList("timeseries", "storage group", "dataType", "encoding", "compression"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.TEXT.toString(), TSDataType.TEXT.toString(), TSDataType.TEXT.toString(), TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp SHOW_DEVICES = StaticResps.getNoTimeExecuteResp(Collections.singletonList("devices"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp SHOW_STORAGE_GROUP = StaticResps.getNoTimeExecuteResp(Collections.singletonList("storage group"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp SHOW_CHILD_PATHS = StaticResps.getNoTimeExecuteResp(Collections.singletonList("child paths"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp COUNT_TIMESERIES = StaticResps.getNoTimeExecuteResp(Collections.singletonList("count"), Collections.singletonList(TSDataType.INT32.toString()));
    static final TSExecuteStatementResp COUNT_NODE_TIMESERIES = StaticResps.getNoTimeExecuteResp(Arrays.asList("column", "count"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp COUNT_NODES = StaticResps.getNoTimeExecuteResp(Collections.singletonList("count"), Collections.singletonList(TSDataType.INT32.toString()));
    static final TSExecuteStatementResp LIST_ROLE_RESP = StaticResps.getNoTimeExecuteResp(Collections.singletonList("role"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp LIST_USER_RESP = StaticResps.getNoTimeExecuteResp(Collections.singletonList("user"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp LIST_USER_PRIVILEGE_RESP = StaticResps.getNoTimeExecuteResp(Arrays.asList("role", "privilege"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp LIST_ROLE_PRIVILEGE_RESP = StaticResps.getNoTimeExecuteResp(Collections.singletonList("privilege"), Collections.singletonList(TSDataType.TEXT.toString()));
    static final TSExecuteStatementResp LAST_RESP = StaticResps.getExecuteResp(Arrays.asList("timeseries", "value"), Arrays.asList(TSDataType.TEXT.toString(), TSDataType.TEXT.toString()), false);

    private StaticResps() {
    }

    private static TSExecuteStatementResp getNoTimeExecuteResp(List<String> columns, List<String> dataTypes) {
        return StaticResps.getExecuteResp(columns, dataTypes, true);
    }

    private static TSExecuteStatementResp getExecuteResp(List<String> columns, List<String> dataTypes, boolean ignoreTimeStamp) {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        resp.setIgnoreTimeStamp(ignoreTimeStamp);
        resp.setColumns(columns);
        resp.setDataTypeList(dataTypes);
        return resp;
    }
}

