/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.runtime.RPCServiceException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.RPCServiceMBean;
import org.apache.iotdb.db.service.RPCServiceThriftHandler;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCService
implements RPCServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(RPCService.class);
    private static final String STATUS_UP = "UP";
    private static final String STATUS_DOWN = "DOWN";
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    private RPCServiceThread rpcServiceThread;
    private TProtocolFactory protocolFactory;
    private TSIService.Processor<TSIService.Iface> processor;
    private TThreadPoolServer.Args poolArgs;
    private TSServiceImpl impl;
    private CountDownLatch stopLatch;

    private RPCService() {
    }

    public static final RPCService getInstance() {
        return RPCServiceHolder.INSTANCE;
    }

    @Override
    public String getRPCServiceStatus() {
        if (this.rpcServiceThread == null) {
            logger.debug("Start latch is null when getting status");
        } else {
            logger.debug("Start status is {} when getting status", (Object)this.rpcServiceThread.isServing());
        }
        if (this.stopLatch == null) {
            logger.debug("Stop latch is null when getting status");
        } else {
            logger.debug("Stop latch is {} when getting status", (Object)this.stopLatch.getCount());
        }
        if (this.rpcServiceThread != null && this.rpcServiceThread.isServing()) {
            return STATUS_UP;
        }
        return STATUS_DOWN;
    }

    @Override
    public int getRPCPort() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        return config.getRpcPort();
    }

    @Override
    public void start() throws StartupException {
        JMXService.registerMBean(RPCService.getInstance(), this.mbeanName);
        this.startService();
    }

    @Override
    public void stop() {
        this.stopService();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public ServiceType getID() {
        return ServiceType.RPC_SERVICE;
    }

    @Override
    public synchronized void startService() throws StartupException {
        if (STATUS_UP.equals(this.getRPCServiceStatus())) {
            logger.info("{}: {} has been already running now", (Object)"IoTDB", (Object)this.getID().getName());
            return;
        }
        logger.info("{}: start {}...", (Object)"IoTDB", (Object)this.getID().getName());
        try {
            this.reset();
            this.rpcServiceThread = new RPCServiceThread(this.stopLatch);
            this.rpcServiceThread.setName(ThreadName.RPC_SERVICE.getName());
            this.rpcServiceThread.start();
            while (!this.rpcServiceThread.isServing()) {
                Thread.sleep(100L);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
        logger.info("{}: start {} successfully, listening on ip {} port {}", new Object[]{"IoTDB", this.getID().getName(), IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), IoTDBDescriptor.getInstance().getConfig().getRpcPort()});
    }

    private void reset() {
        this.rpcServiceThread = null;
        this.stopLatch = new CountDownLatch(1);
    }

    @Override
    public synchronized void restartService() throws StartupException {
        this.stopService();
        this.startService();
    }

    @Override
    public synchronized void stopService() {
        if (STATUS_DOWN.equals(this.getRPCServiceStatus())) {
            logger.info("{}: {} isn't running now", (Object)"IoTDB", (Object)this.getID().getName());
            return;
        }
        logger.info("{}: closing {}...", (Object)"IoTDB", (Object)this.getID().getName());
        if (this.rpcServiceThread != null) {
            this.rpcServiceThread.close();
        }
        try {
            this.stopLatch.await();
            this.reset();
            logger.info("{}: close {} successfully", (Object)"IoTDB", (Object)this.getID().getName());
        }
        catch (InterruptedException e) {
            logger.error("{}: close {} failed because: ", new Object[]{"IoTDB", this.getID().getName(), e});
            Thread.currentThread().interrupt();
        }
    }

    private class RPCServiceThread
    extends Thread {
        private TServerSocket serverTransport;
        private TServer poolServer;
        private CountDownLatch threadStopLatch;

        public RPCServiceThread(CountDownLatch threadStopLatch) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable()) {
                RPCService.this.protocolFactory = (TProtocolFactory)new TCompactProtocol.Factory();
            } else {
                RPCService.this.protocolFactory = (TProtocolFactory)new TBinaryProtocol.Factory();
            }
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            RPCService.this.impl = (TSServiceImpl)Class.forName(config.getRpcImplClassName()).newInstance();
            RPCService.this.processor = new TSIService.Processor((TSIService.Iface)RPCService.this.impl);
            this.threadStopLatch = threadStopLatch;
        }

        @Override
        public void run() {
            logger.info("The RPC service thread begin to run...");
            try {
                IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
                this.serverTransport = new TServerSocket(new InetSocketAddress(config.getRpcAddress(), config.getRpcPort()));
                if (!this.serverTransport.getServerSocket().isBound()) {
                    logger.error("The RPC service port is not bound.");
                }
                RPCService.this.poolArgs = new TThreadPoolServer.Args((TServerTransport)this.serverTransport).maxWorkerThreads(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum()).minWorkerThreads(1).stopTimeoutVal(IoTDBDescriptor.getInstance().getConfig().getThriftServerAwaitTimeForStopService());
                ((RPCService)RPCService.this).poolArgs.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(RPCService.this.poolArgs, ThreadName.RPC_CLIENT.getName());
                RPCService.this.poolArgs.processor((TProcessor)RPCService.this.processor);
                RPCService.this.poolArgs.protocolFactory(RPCService.this.protocolFactory);
                this.poolServer = new TThreadPoolServer(RPCService.this.poolArgs);
                this.poolServer.setServerEventHandler((TServerEventHandler)new RPCServiceThriftHandler(RPCService.this.impl));
                this.poolServer.serve();
            }
            catch (TTransportException e) {
                throw new RPCServiceException(String.format("%s: failed to start %s, because ", "IoTDB", RPCService.this.getID().getName()), e);
            }
            catch (Exception e) {
                throw new RPCServiceException(String.format("%s: %s exit, because ", "IoTDB", RPCService.this.getID().getName()), e);
            }
            finally {
                this.close();
                if (this.threadStopLatch == null) {
                    logger.debug("Stop Count Down latch is null");
                } else {
                    logger.debug("Stop Count Down latch is {}", (Object)this.threadStopLatch.getCount());
                }
                if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
                    this.threadStopLatch.countDown();
                }
                logger.debug("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)RPCService.this.getID().getName());
            }
        }

        private synchronized void close() {
            if (this.poolServer != null) {
                this.poolServer.setShouldStop(true);
                this.poolServer.stop();
                this.poolServer = null;
            }
            if (this.serverTransport != null) {
                this.serverTransport.close();
                this.serverTransport = null;
            }
        }

        boolean isServing() {
            if (this.poolServer != null) {
                return this.poolServer.isServing();
            }
            return false;
        }
    }

    private static class RPCServiceHolder {
        private static final RPCService INSTANCE = new RPCService();

        private RPCServiceHolder() {
        }
    }
}

