/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesReaderByTimestamp
implements IReaderByTimestamp {
    private SeriesReader seriesReader;
    private BatchData batchData;

    public SeriesReaderByTimestamp(Path seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, TsFileFilter fileFilter) {
        this.seriesReader = new SeriesReader(seriesPath, allSensors, dataType, context, dataSource, (Filter)TimeFilter.gtEq((long)Long.MIN_VALUE), null, fileFilter);
    }

    public SeriesReaderByTimestamp(SeriesReader seriesReader) {
        this.seriesReader = seriesReader;
    }

    @Override
    public Object getValueInTimestamp(long timestamp) throws IOException {
        this.seriesReader.setTimeFilter(timestamp);
        if (!(this.batchData != null && this.batchData.getTimeByIndex(this.batchData.length() - 1) >= timestamp || this.hasNext(timestamp))) {
            return null;
        }
        return this.batchData.getValueInTimestamp(timestamp);
    }

    private boolean hasNext(long timestamp) throws IOException {
        if (this.readPageData(timestamp)) {
            return true;
        }
        if (this.readChunkData(timestamp)) {
            return true;
        }
        while (this.seriesReader.hasNextFile()) {
            Statistics statistics = this.seriesReader.currentFileStatistics();
            if (!this.satisfyTimeFilter(statistics)) {
                this.seriesReader.skipCurrentFile();
                continue;
            }
            if (!this.readChunkData(timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData(long timestamp) throws IOException {
        while (this.seriesReader.hasNextChunk()) {
            Statistics statistics = this.seriesReader.currentChunkStatistics();
            if (!this.satisfyTimeFilter(statistics)) {
                this.seriesReader.skipCurrentChunk();
                continue;
            }
            if (!this.readPageData(timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData(long timestamp) throws IOException {
        while (this.seriesReader.hasNextPage()) {
            if (!this.seriesReader.isPageOverlapped() && !this.satisfyTimeFilter(this.seriesReader.currentPageStatistics())) {
                this.seriesReader.skipCurrentPage();
                continue;
            }
            this.batchData = this.seriesReader.nextPage();
            if (this.isEmpty(this.batchData) || this.batchData.getTimeByIndex(this.batchData.length() - 1) < timestamp) continue;
            return true;
        }
        return false;
    }

    private boolean satisfyTimeFilter(Statistics statistics) {
        return this.seriesReader.getTimeFilter().satisfy(statistics);
    }

    private boolean isEmpty(BatchData batchData) {
        return batchData == null || !batchData.hasCurrent();
    }
}

