/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.cache.ChunkMetadataCache;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class DiskChunkMetadataLoader
implements IChunkMetadataLoader {
    private TsFileResource resource;
    private Path seriesPath;
    private QueryContext context;
    private Filter filter;

    public DiskChunkMetadataLoader(TsFileResource resource, Path seriesPath, QueryContext context, Filter filter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.filter = filter;
    }

    public List<ChunkMetadata> loadChunkMetadataList() throws IOException {
        List<ChunkMetadata> chunkMetadataList = ChunkMetadataCache.getInstance().get(this.resource.getPath(), this.seriesPath);
        DiskChunkMetadataLoader.setDiskChunkLoader(chunkMetadataList, this.resource, this.seriesPath, this.context);
        chunkMetadataList.removeIf(chunkMetaData -> this.filter != null && !this.filter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
        return chunkMetadataList;
    }

    public void setDiskChunkLoader(List<ChunkMetadata> chunkMetadataList) throws IOException {
        DiskChunkMetadataLoader.setDiskChunkLoader(chunkMetadataList, this.resource, this.seriesPath, this.context);
    }

    public static void setDiskChunkLoader(List<ChunkMetadata> chunkMetadataList, TsFileResource resource, Path seriesPath, QueryContext context) {
        List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), seriesPath.getFullPath());
        if (!pathModifications.isEmpty()) {
            QueryUtils.modifyChunkMetaData(chunkMetadataList, pathModifications);
        }
        for (ChunkMetadata data : chunkMetadataList) {
            data.setChunkLoader((IChunkLoader)new DiskChunkLoader(resource));
        }
    }
}

