/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort.adapter;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class ByTimestampReaderAdapter
implements IReaderByTimestamp {
    private IPointReader pointReader;
    private boolean hasCached;
    private TimeValuePair pair;

    public ByTimestampReaderAdapter(IPointReader pointReader) {
        this.pointReader = pointReader;
    }

    @Override
    public Object getValueInTimestamp(long timestamp) throws IOException {
        if (this.hasCached) {
            if (this.pair.getTimestamp() < timestamp) {
                this.hasCached = false;
            } else {
                if (this.pair.getTimestamp() == timestamp) {
                    this.hasCached = false;
                    return this.pair.getValue().getValue();
                }
                return null;
            }
        }
        while (this.pointReader.hasNextTimeValuePair()) {
            this.pair = this.pointReader.nextTimeValuePair();
            if (this.pair.getTimestamp() == timestamp) {
                return this.pair.getValue().getValue();
            }
            if (this.pair.getTimestamp() <= timestamp) continue;
            this.hasCached = true;
            return null;
        }
        return null;
    }
}

