/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.NonAlignEngineDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class RawDataQueryExecutor {
    protected List<Path> deduplicatedPaths;
    protected List<TSDataType> deduplicatedDataTypes;
    protected IExpression optimizedExpression;

    public RawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        this.deduplicatedPaths = queryPlan.getDeduplicatedPaths();
        this.deduplicatedDataTypes = queryPlan.getDeduplicatedDataTypes();
        this.optimizedExpression = queryPlan.getExpression();
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException, QueryProcessException {
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context, queryPlan);
        try {
            return new RawQueryDataSetWithoutValueFilter(this.deduplicatedPaths, this.deduplicatedDataTypes, readersOfSelectedSeries);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageEngineException(e.getMessage());
        }
        catch (IOException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public QueryDataSet executeNonAlign(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException, QueryProcessException {
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context, queryPlan);
        return new NonAlignEngineDataSet(this.deduplicatedPaths, this.deduplicatedDataTypes, readersOfSelectedSeries);
    }

    protected List<ManagedSeriesReader> initManagedSeriesReader(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException, QueryProcessException {
        Filter timeFilter = null;
        if (this.optimizedExpression != null) {
            timeFilter = ((GlobalTimeExpression)this.optimizedExpression).getFilter();
        }
        ArrayList<ManagedSeriesReader> readersOfSelectedSeries = new ArrayList<ManagedSeriesReader>();
        for (int i = 0; i < this.deduplicatedPaths.size(); ++i) {
            Path path = this.deduplicatedPaths.get(i);
            TSDataType dataType = this.deduplicatedDataTypes.get(i);
            QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter);
            timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
            SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, queryDataSource, timeFilter, null, null);
            readersOfSelectedSeries.add(reader);
        }
        return readersOfSelectedSeries;
    }

    public QueryDataSet executeWithValueFilter(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException, QueryProcessException {
        TimeGenerator timestampGenerator = this.getTimeGenerator(this.optimizedExpression, context, queryPlan);
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.optimizedExpression, this.deduplicatedPaths, (boolean)timestampGenerator.hasOrNode());
        ArrayList<IReaderByTimestamp> readersOfSelectedSeries = new ArrayList<IReaderByTimestamp>();
        for (int i = 0; i < this.deduplicatedPaths.size(); ++i) {
            if (((Boolean)cached.get(i)).booleanValue()) {
                readersOfSelectedSeries.add(null);
                continue;
            }
            Path path = this.deduplicatedPaths.get(i);
            IReaderByTimestamp seriesReaderByTimestamp = this.getReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), this.deduplicatedDataTypes.get(i), context);
            readersOfSelectedSeries.add(seriesReaderByTimestamp);
        }
        return new RawQueryDataSetWithValueFilter(this.deduplicatedPaths, this.deduplicatedDataTypes, timestampGenerator, readersOfSelectedSeries, cached);
    }

    protected IReaderByTimestamp getReaderByTimestamp(Path path, Set<String> allSensors, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, allSensors, dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null), null);
    }

    protected TimeGenerator getTimeGenerator(IExpression expression, QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(expression, context, queryPlan);
    }
}

