/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class FillQueryExecutor {
    private List<Path> selectedSeries;
    private List<TSDataType> dataTypes;
    private long queryTime;
    private Map<TSDataType, IFill> typeIFillMap;

    public FillQueryExecutor(List<Path> selectedSeries, List<TSDataType> dataTypes, long queryTime, Map<TSDataType, IFill> typeIFillMap) {
        this.selectedSeries = selectedSeries;
        this.queryTime = queryTime;
        this.typeIFillMap = typeIFillMap;
        this.dataTypes = dataTypes;
    }

    public QueryDataSet execute(QueryContext context, FillQueryPlan fillQueryPlan) throws StorageEngineException, QueryProcessException, IOException {
        RowRecord record = new RowRecord(this.queryTime);
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            IFill fill;
            TSDataType dataType;
            Path path;
            block6: {
                block5: {
                    path = this.selectedSeries.get(i);
                    dataType = this.dataTypes.get(i);
                    long defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    if (this.typeIFillMap.containsKey(dataType)) break block5;
                    switch (dataType) {
                        case INT32: 
                        case INT64: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BOOLEAN: 
                        case TEXT: {
                            fill = new PreviousFill(dataType, this.queryTime, defaultFillInterval);
                            break block6;
                        }
                        default: {
                            throw new UnsupportedDataTypeException("do not support datatype " + dataType);
                        }
                    }
                }
                fill = this.typeIFillMap.get(dataType).copy();
            }
            fill.configureFill(path, dataType, this.queryTime, fillQueryPlan.getAllMeasurementsInDevice(path.getDevice()), context);
            TimeValuePair timeValuePair = fill.getFillResult();
            if (timeValuePair == null || timeValuePair.getValue() == null) {
                record.addField(null);
                continue;
            }
            record.addField(timeValuePair.getValue().getValue(), dataType);
        }
        SingleDataSet dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
        dataSet.setRecord(record);
        return dataSet;
    }
}

