/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class GroupByWithValueFilterDataSet
extends GroupByEngineDataSet {
    private List<IReaderByTimestamp> allDataReaderList;
    private GroupByPlan groupByPlan;
    private TimeGenerator timestampGenerator;
    private long timestamp;
    private boolean hasCachedTimestamp;
    protected int timeStampFetchSize;

    public GroupByWithValueFilterDataSet() {
    }

    public GroupByWithValueFilterDataSet(QueryContext context, GroupByPlan groupByPlan) throws StorageEngineException, QueryProcessException {
        super(context, groupByPlan);
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
        this.initGroupBy(context, groupByPlan);
    }

    public GroupByWithValueFilterDataSet(long queryId, GroupByPlan groupByPlan) {
        super(new QueryContext(queryId), groupByPlan);
        this.allDataReaderList = new ArrayList<IReaderByTimestamp>();
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
    }

    protected void initGroupBy(QueryContext context, GroupByPlan groupByPlan) throws StorageEngineException, QueryProcessException {
        this.timestampGenerator = this.getTimeGenerator(groupByPlan.getExpression(), context, groupByPlan);
        this.allDataReaderList = new ArrayList<IReaderByTimestamp>();
        this.groupByPlan = groupByPlan;
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = (Path)this.paths.get(i);
            this.allDataReaderList.add(this.getReaderByTime(path, groupByPlan, (TSDataType)this.dataTypes.get(i), context, null));
        }
    }

    protected TimeGenerator getTimeGenerator(IExpression expression, QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(expression, context, queryPlan);
    }

    protected IReaderByTimestamp getReaderByTime(Path path, RawDataQueryPlan queryPlan, TSDataType dataType, QueryContext context, TsFileFilter fileFilter) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null), fileFilter);
    }

    @Override
    protected RowRecord nextWithoutConstraint() throws IOException {
        int i;
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByWithoutValueFilterDataSet.");
        }
        this.hasCachedTimeInterval = false;
        ArrayList<AggregateResult> aggregateResultList = new ArrayList<AggregateResult>();
        for (int i2 = 0; i2 < this.paths.size(); ++i2) {
            aggregateResultList.add(AggregateResultFactory.getAggrResultByName(this.groupByPlan.getDeduplicatedAggregations().get(i2), this.groupByPlan.getDeduplicatedDataTypes().get(i2)));
        }
        long[] timestampArray = new long[this.timeStampFetchSize];
        int timeArrayLength = 0;
        if (this.hasCachedTimestamp) {
            if (this.timestamp < this.curEndTime) {
                if (this.timestamp >= this.curStartTime) {
                    this.hasCachedTimestamp = false;
                    timestampArray[timeArrayLength++] = this.timestamp;
                }
            } else {
                return this.constructRowRecord(aggregateResultList);
            }
        }
        while (this.timestampGenerator.hasNext()) {
            timeArrayLength = this.constructTimeArrayForOneCal(timestampArray, timeArrayLength);
            for (i = 0; i < this.paths.size(); ++i) {
                ((AggregateResult)aggregateResultList.get(i)).updateResultUsingTimestamps(timestampArray, timeArrayLength, this.allDataReaderList.get(i));
            }
            timeArrayLength = 0;
            if (this.timestamp < this.curEndTime) continue;
            this.hasCachedTimestamp = true;
            break;
        }
        if (timeArrayLength > 0) {
            for (i = 0; i < this.paths.size(); ++i) {
                ((AggregateResult)aggregateResultList.get(i)).updateResultUsingTimestamps(timestampArray, timeArrayLength, this.allDataReaderList.get(i));
            }
        }
        return this.constructRowRecord(aggregateResultList);
    }

    private int constructTimeArrayForOneCal(long[] timestampArray, int timeArrayLength) throws IOException {
        for (int cnt = 1; cnt < this.timeStampFetchSize && this.timestampGenerator.hasNext(); ++cnt) {
            this.timestamp = this.timestampGenerator.next();
            if (this.timestamp >= this.curEndTime) {
                this.hasCachedTimestamp = true;
                break;
            }
            timestampArray[timeArrayLength++] = this.timestamp;
        }
        return timeArrayLength;
    }

    private RowRecord constructRowRecord(List<AggregateResult> aggregateResultList) {
        RowRecord record = this.leftCRightO ? new RowRecord(this.curStartTime) : new RowRecord(this.curEndTime - 1L);
        for (int i = 0; i < this.paths.size(); ++i) {
            AggregateResult aggregateResult = aggregateResultList.get(i);
            record.addField(aggregateResult.getResult(), aggregateResult.getResultDataType());
        }
        return record;
    }
}

