/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MinTimeAggrResult
extends AggregateResult {
    public MinTimeAggrResult() {
        super(TSDataType.INT64, AggregationType.MIN_TIME);
        this.reset();
    }

    @Override
    public Long getResult() {
        return this.hasResult() ? Long.valueOf(this.getLongValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasResult()) {
            return;
        }
        long time = statistics.getStartTime();
        this.setValue(time);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) throws IOException {
        this.updateResultFromPageData(dataInThisPage, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long bound) throws IOException {
        if (this.hasResult()) {
            return;
        }
        if (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < bound) {
            this.setLongValue(dataInThisPage.currentTime());
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        if (this.hasResult()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.setLongValue(timestamps[i]);
            return;
        }
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return this.hasResult();
    }

    @Override
    public void merge(AggregateResult another) {
        MinTimeAggrResult anotherMinTime = (MinTimeAggrResult)another;
        if (!this.hasResult() && anotherMinTime.hasResult()) {
            this.setLongValue(anotherMinTime.getResult());
            return;
        }
        if (this.hasResult() && anotherMinTime.hasResult() && this.getResult() > anotherMinTime.getResult()) {
            this.setLongValue(anotherMinTime.getResult());
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
    }
}

