/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MaxTimeAggrResult
extends AggregateResult {
    public MaxTimeAggrResult() {
        super(TSDataType.INT64, AggregationType.MAX_TIME);
        this.reset();
    }

    @Override
    public Long getResult() {
        return this.hasResult() ? Long.valueOf(this.getLongValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        long maxTimestamp = statistics.getEndTime();
        this.updateMaxTimeResult(maxTimestamp);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        int maxIndex = dataInThisPage.length() - 1;
        if (maxIndex < 0) {
            return;
        }
        long time = dataInThisPage.getTimeByIndex(maxIndex);
        this.updateMaxTimeResult(time);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long bound) {
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < bound) {
            this.updateMaxTimeResult(dataInThisPage.currentTime());
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        long time = -1L;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            time = timestamps[i];
        }
        if (time == -1L) {
            return;
        }
        this.updateMaxTimeResult(time);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        MaxTimeAggrResult anotherMaxTime = (MaxTimeAggrResult)another;
        if (anotherMaxTime.getResult() != null) {
            this.updateMaxTimeResult(anotherMaxTime.getResult());
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
    }

    private void updateMaxTimeResult(long value) {
        if (!this.hasResult() || value >= this.getLongValue()) {
            this.setLongValue(value);
        }
    }
}

