/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mqtt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mqtt.Message;
import org.apache.iotdb.db.mqtt.PayloadFormatter;

public class JSONPayloadFormatter
implements PayloadFormatter {
    private static final String JSON_KEY_DEVICE = "device";
    private static final String JSON_KEY_TIMESTAMP = "timestamp";
    private static final String JSON_KEY_TIMESTAMPS = "timestamps";
    private static final String JSON_KEY_MEASUREMENTS = "measurements";
    private static final String JSON_KEY_VALUES = "values";

    @Override
    public List<Message> format(ByteBuf payload) {
        if (payload == null) {
            return null;
        }
        String txt = payload.toString(StandardCharsets.UTF_8);
        JSONObject jsonObject = JSON.parseObject((String)txt);
        Object timestamp = jsonObject.get((Object)JSON_KEY_TIMESTAMP);
        if (timestamp != null) {
            return Lists.newArrayList((Object[])new Message[]{(Message)JSON.parseObject((String)txt, Message.class)});
        }
        String device = jsonObject.getString(JSON_KEY_DEVICE);
        JSONArray timestamps = jsonObject.getJSONArray(JSON_KEY_TIMESTAMPS);
        JSONArray measurements = jsonObject.getJSONArray(JSON_KEY_MEASUREMENTS);
        JSONArray values = jsonObject.getJSONArray(JSON_KEY_VALUES);
        ArrayList<Message> ret = new ArrayList<Message>();
        for (int i = 0; i < timestamps.size(); ++i) {
            Long ts = timestamps.getLong(i);
            Message message = new Message();
            message.setDevice(device);
            message.setTimestamp(ts);
            message.setMeasurements(measurements.toJavaList(String.class));
            message.setValues(((JSONArray)values.get(i)).toJavaList(String.class));
            ret.add(message);
        }
        return ret;
    }

    @Override
    public String getName() {
        return "json";
    }
}

