/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.Serializable;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;

public abstract class MNode
implements Serializable {
    private static final long serialVersionUID = -770028375899514063L;
    protected String name;
    protected MNode parent;
    protected String fullPath;

    public MNode(MNode parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public abstract boolean hasChild(String var1);

    public abstract void addChild(String var1, MNode var2);

    public abstract void deleteChild(String var1) throws DeleteFailedException;

    public abstract void deleteAliasChild(String var1) throws DeleteFailedException;

    public abstract MNode getChild(String var1);

    public abstract int getLeafCount();

    public abstract void addAlias(String var1, MNode var2);

    public String getFullPath() {
        if (this.fullPath != null) {
            return this.fullPath;
        }
        this.fullPath = this.concatFullPath();
        return this.fullPath;
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.name);
        MNode curr = this;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            builder.insert(0, '.').insert(0, curr.name);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public MNode getParent() {
        return this.parent;
    }

    public abstract Map<String, MNode> getChildren();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

