/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;

class MetaUtils {
    public static final String PATH_SEPARATOR = "\\.";

    private MetaUtils() {
    }

    public static String[] getNodeNames(String path) {
        String[] nodeNames;
        if (path.contains("\"") || path.contains("'")) {
            String[] measurementDeviceNode = path.trim().replace("'", "\"").split("\"");
            String measurement = measurementDeviceNode[1];
            String[] deviceNodeName = measurementDeviceNode[0].split(PATH_SEPARATOR);
            int nodeNumber = deviceNodeName.length + 1;
            nodeNames = new String[nodeNumber];
            System.arraycopy(deviceNodeName, 0, nodeNames, 0, nodeNumber - 1);
            nodeNames[nodeNumber - 1] = measurement;
        } else {
            nodeNames = path.split(PATH_SEPARATOR);
        }
        return nodeNames;
    }

    static String getNodeRegByIdx(int idx, String[] nodes) {
        return idx >= nodes.length ? "*" : nodes[idx];
    }

    public static String getStorageGroupNameByLevel(String path, int level) throws MetadataException {
        String[] nodeNames = MetaUtils.getNodeNames(path);
        if (nodeNames.length <= level || !nodeNames[0].equals("root")) {
            throw new IllegalPathException(path);
        }
        StringBuilder storageGroupName = new StringBuilder(nodeNames[0]);
        for (int i = 1; i <= level; ++i) {
            storageGroupName.append('.').append(nodeNames[i]);
        }
        return storageGroupName.toString();
    }
}

