/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.ActiveTimeSeriesCounter;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.ConfigAdjusterException;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MLogWriter;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.TagLogFile;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.utils.RandomDeleteCache;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.exception.cache.CacheException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MManager {
    private static final Logger logger = LoggerFactory.getLogger(MManager.class);
    private static final String TIME_SERIES_TREE_HEADER = "===  Timeseries Tree  ===\n\n";
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private String logFilePath;
    private MTree mtree;
    private MLogWriter logWriter;
    private TagLogFile tagLogFile;
    private boolean isRecovering;
    private RandomDeleteCache<String, MNode> mNodeCache;
    private Map<String, Map<String, Set<LeafMNode>>> tagIndex = new HashMap<String, Map<String, Set<LeafMNode>>>();
    private Map<String, Integer> seriesNumberInStorageGroups = new HashMap<String, Integer>();
    private long maxSeriesNumberAmongStorageGroup;
    private boolean initialized;
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    private MManager() {
        String schemaDir = this.config.getSchemaDir();
        File schemaFolder = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!schemaFolder.exists()) {
            if (schemaFolder.mkdirs()) {
                logger.info("create system folder {}", (Object)schemaFolder.getAbsolutePath());
            } else {
                logger.info("create system folder {} failed.", (Object)schemaFolder.getAbsolutePath());
            }
        }
        this.logFilePath = schemaDir + File.separator + "mlog.txt";
        this.isRecovering = true;
        int cacheSize = this.config.getmManagerCacheSize();
        this.mNodeCache = new RandomDeleteCache<String, MNode>(cacheSize){

            @Override
            public MNode loadObjectByKey(String key) throws CacheException {
                MManager.this.lock.readLock().lock();
                try {
                    MNode mNode = MManager.this.mtree.getNodeByPathWithStorageGroupCheck(key);
                    return mNode;
                }
                catch (MetadataException e) {
                    throw new CacheException((Throwable)e);
                }
                finally {
                    MManager.this.lock.readLock().unlock();
                }
            }
        };
    }

    public static MManager getInstance() {
        return MManagerHolder.INSTANCE;
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        File logFile = SystemFileFactory.INSTANCE.getFile(this.logFilePath);
        try {
            this.tagLogFile = new TagLogFile(this.config.getSchemaDir(), "tlog.txt");
            this.initFromLog(logFile);
            if (this.config.isEnableParameterAdapter()) {
                List<String> storageGroups = this.mtree.getAllStorageGroupNames();
                for (String sg : storageGroups) {
                    MNode node = this.mtree.getNodeByPath(sg);
                    this.seriesNumberInStorageGroups.put(sg, node.getLeafCount());
                }
                this.maxSeriesNumberAmongStorageGroup = this.seriesNumberInStorageGroups.values().stream().max(Integer::compareTo).orElse(0).intValue();
            }
            this.logWriter = new MLogWriter(this.config.getSchemaDir(), "mlog.txt");
            this.isRecovering = false;
        }
        catch (IOException | MetadataException e) {
            this.mtree = new MTree();
            logger.error("Cannot read MTree from file, using an empty new one", (Throwable)e);
        }
        this.initialized = true;
    }

    private void initFromLog(File logFile) throws IOException {
        this.mtree = new MTree();
        if (logFile.exists()) {
            try (FileReader fr = new FileReader(logFile);
                 BufferedReader br = new BufferedReader(fr);){
                String cmd;
                while ((cmd = br.readLine()) != null) {
                    try {
                        this.operation(cmd);
                    }
                    catch (Exception e) {
                        logger.error("Can not operate cmd {}", (Object)cmd, (Object)e);
                    }
                }
            }
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.mtree = new MTree();
            this.mNodeCache.clear();
            this.tagIndex.clear();
            this.seriesNumberInStorageGroups.clear();
            this.maxSeriesNumberAmongStorageGroup = 0L;
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            if (this.tagLogFile != null) {
                this.tagLogFile.close();
                this.tagLogFile = null;
            }
            this.initialized = false;
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void operation(String cmd) throws IOException, MetadataException {
        String[] args = cmd.trim().split(",", -1);
        switch (args[0]) {
            case "0": {
                HashMap<String, String> props = new HashMap<String, String>();
                if (!args[5].isEmpty()) {
                    String[] keyValues;
                    for (String keyValue : keyValues = args[5].split("&")) {
                        String[] kv = keyValue.split("=");
                        props.put(kv[0], kv[1]);
                    }
                }
                String alias = null;
                if (!args[6].isEmpty()) {
                    alias = args[6];
                }
                long offset = -1L;
                Map<String, String> tagMap = null;
                if (!args[7].isEmpty()) {
                    offset = Long.parseLong(args[7]);
                    tagMap = this.tagLogFile.readTag(this.config.getTagAttributeTotalSize(), offset);
                }
                CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new Path(args[1]), TSDataType.deserialize((short)Short.parseShort(args[2])), TSEncoding.deserialize((short)Short.parseShort(args[3])), CompressionType.deserialize((short)Short.parseShort(args[4])), props, tagMap, null, alias);
                this.createTimeseries(plan, offset);
                break;
            }
            case "1": {
                String failedTimeseries = this.deleteTimeseries(args[1]);
                if (failedTimeseries.isEmpty()) break;
                throw new DeleteFailedException(failedTimeseries);
            }
            case "2": {
                this.setStorageGroup(args[1]);
                break;
            }
            case "11": {
                ArrayList<String> storageGroups = new ArrayList<String>(Arrays.asList(args).subList(1, args.length));
                this.deleteStorageGroups(storageGroups);
                break;
            }
            case "10": {
                this.setTTL(args[1], Long.parseLong(args[2]));
                break;
            }
            case "12": {
                this.changeOffset(args[1], Long.parseLong(args[2]));
                break;
            }
            case "13": {
                this.changeAlias(args[1], args[2]);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)cmd);
            }
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws MetadataException {
        this.lock.writeLock().lock();
        try {
            String storageGroupName;
            String path = plan.getPath().getFullPath();
            SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
            try {
                storageGroupName = this.mtree.getStorageGroupName(path);
            }
            catch (StorageGroupNotSetException e) {
                if (!this.config.isAutoCreateSchemaEnabled()) {
                    throw e;
                }
                storageGroupName = MetaUtils.getStorageGroupNameByLevel(path, this.config.getDefaultStorageGroupLevel());
                this.setStorageGroup(storageGroupName);
            }
            IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(1);
            LeafMNode leafMNode = this.mtree.createTimeseries(path, plan.getDataType(), plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias());
            if (plan.getTags() != null) {
                for (Map.Entry<String, String> entry : plan.getTags().entrySet()) {
                    this.tagIndex.computeIfAbsent(entry.getKey(), k -> new HashMap()).computeIfAbsent(entry.getValue(), v -> new HashSet()).add(leafMNode);
                }
            }
            if (this.config.isEnableParameterAdapter()) {
                int size = this.seriesNumberInStorageGroups.get(storageGroupName);
                this.seriesNumberInStorageGroups.put(storageGroupName, size + 1);
                if ((long)(size + 1) > this.maxSeriesNumberAmongStorageGroup) {
                    this.maxSeriesNumberAmongStorageGroup = size + 1;
                }
            }
            if (!this.isRecovering) {
                if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                    offset = this.tagLogFile.write(plan.getTags(), plan.getAttributes());
                }
                this.logWriter.createTimeseries(plan, offset);
            }
            leafMNode.setOffset(offset);
        }
        catch (IOException | ConfigAdjusterException e) {
            throw new MetadataException(e.getMessage());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        this.createTimeseries(new CreateTimeSeriesPlan(new Path(path), dataType, encoding, compressor, props, null, null, null));
    }

    public String deleteTimeseries(String prefixPath) throws MetadataException {
        this.lock.writeLock().lock();
        if (this.isStorageGroup(prefixPath)) {
            if (this.config.isEnableParameterAdapter()) {
                int size = this.seriesNumberInStorageGroups.get(prefixPath);
                this.seriesNumberInStorageGroups.put(prefixPath, 0);
                if ((long)size == this.maxSeriesNumberAmongStorageGroup) {
                    this.seriesNumberInStorageGroups.values().stream().max(Integer::compareTo).ifPresent(val -> {
                        this.maxSeriesNumberAmongStorageGroup = val.intValue();
                    });
                }
            }
            this.mNodeCache.clear();
        }
        try {
            List<String> allTimeseries = this.mtree.getAllTimeseriesName(prefixPath);
            allTimeseries.removeIf(p -> p.startsWith("root.stats"));
            HashSet<String> failedNames = new HashSet<String>();
            for (String p2 : allTimeseries) {
                try {
                    String emptyStorageGroup = this.deleteOneTimeseriesAndUpdateStatistics(p2);
                    if (this.isRecovering) continue;
                    if (emptyStorageGroup != null) {
                        StorageEngine.getInstance().deleteAllDataFilesInOneStorageGroup(emptyStorageGroup);
                    }
                    this.logWriter.deleteTimeseries(p2);
                }
                catch (DeleteFailedException e) {
                    failedNames.add(e.getName());
                }
            }
            String string = String.join((CharSequence)",", failedNames);
            return string;
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void removeFromTagInvertedIndex(LeafMNode node) throws IOException {
        if (node.getOffset() < 0L) {
            return;
        }
        Map<String, String> tagMap = this.tagLogFile.readTag(this.config.getTagAttributeTotalSize(), node.getOffset());
        if (tagMap != null) {
            for (Map.Entry<String, String> entry : tagMap.entrySet()) {
                if (this.tagIndex.containsKey(entry.getKey()) && this.tagIndex.get(entry.getKey()).containsKey(entry.getValue())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Delete: TimeSeries %s is removed from tag inverted index, tag key is %s, tag value is %s, tlog offset is %d", node.getFullPath(), entry.getKey(), entry.getValue(), node.getOffset()));
                    }
                    this.tagIndex.get(entry.getKey()).get(entry.getValue()).remove(node);
                    if (!this.tagIndex.get(entry.getKey()).get(entry.getValue()).isEmpty()) continue;
                    this.tagIndex.get(entry.getKey()).remove(entry.getValue());
                    if (!this.tagIndex.get(entry.getKey()).isEmpty()) continue;
                    this.tagIndex.remove(entry.getKey());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Delete: TimeSeries %s's tag info has been removed from tag inverted index before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", node.getFullPath(), entry.getKey(), entry.getValue(), node.getOffset(), this.tagIndex.containsKey(entry.getKey())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deleteOneTimeseriesAndUpdateStatistics(String path) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            Pair<String, LeafMNode> pair = this.mtree.deleteTimeseriesAndReturnEmptyStorageGroup(path);
            this.removeFromTagInvertedIndex((LeafMNode)pair.right);
            String storageGroupName = (String)pair.left;
            this.mNodeCache.clear();
            try {
                IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(-1);
            }
            catch (ConfigAdjusterException e) {
                throw new MetadataException(e);
            }
            if (this.config.isEnableParameterAdapter()) {
                String storageGroup = this.getStorageGroupName(path);
                int size = this.seriesNumberInStorageGroups.get(storageGroup);
                this.seriesNumberInStorageGroups.put(storageGroup, size - 1);
                if ((long)size == this.maxSeriesNumberAmongStorageGroup) {
                    this.seriesNumberInStorageGroups.values().stream().max(Integer::compareTo).ifPresent(val -> {
                        this.maxSeriesNumberAmongStorageGroup = val.intValue();
                    });
                }
            }
            String string = storageGroupName;
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setStorageGroup(String storageGroup) throws MetadataException {
        this.lock.writeLock().lock();
        try {
            this.mtree.setStorageGroup(storageGroup);
            IoTDBConfigDynamicAdapter.getInstance().addOrDeleteStorageGroup(1);
            if (this.config.isEnableParameterAdapter()) {
                ActiveTimeSeriesCounter.getInstance().init(storageGroup);
                this.seriesNumberInStorageGroups.put(storageGroup, 0);
            }
            if (!this.isRecovering) {
                this.logWriter.setStorageGroup(storageGroup);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
        catch (ConfigAdjusterException e) {
            this.mtree.deleteStorageGroup(storageGroup);
            throw new MetadataException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteStorageGroups(List<String> storageGroups) throws MetadataException {
        this.lock.writeLock().lock();
        try {
            for (String storageGroup : storageGroups) {
                this.mNodeCache.clear();
                List<LeafMNode> leafMNodes = this.mtree.deleteStorageGroup(storageGroup);
                for (LeafMNode leafMNode : leafMNodes) {
                    this.removeFromTagInvertedIndex(leafMNode);
                }
                if (this.config.isEnableParameterAdapter()) {
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteStorageGroup(-1);
                    int size = this.seriesNumberInStorageGroups.get(storageGroup);
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(size * -1);
                    ActiveTimeSeriesCounter.getInstance().delete(storageGroup);
                    this.seriesNumberInStorageGroups.remove(storageGroup);
                    if ((long)size == this.maxSeriesNumberAmongStorageGroup) {
                        this.maxSeriesNumberAmongStorageGroup = this.seriesNumberInStorageGroups.values().stream().max(Integer::compareTo).orElse(0).intValue();
                    }
                }
                if (this.isRecovering) continue;
                this.logWriter.deleteStorageGroup(storageGroup);
            }
        }
        catch (ConfigAdjusterException e) {
            throw new MetadataException(e);
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean isStorageGroup(String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mtree.isStorageGroup(path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TSDataType getSeriesType(String path) throws MetadataException {
        this.lock.readLock().lock();
        try {
            if (path.equals("time")) {
                TSDataType tSDataType = TSDataType.INT64;
                return tSDataType;
            }
            TSDataType tSDataType = this.mtree.getSchema(path).getType();
            return tSDataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementSchema[] getSchemas(String deviceId, String[] measurements) throws MetadataException {
        this.lock.readLock().lock();
        try {
            MNode deviceNode = this.getNodeByPath(deviceId);
            MeasurementSchema[] measurementSchemas = new MeasurementSchema[measurements.length];
            for (int i = 0; i < measurementSchemas.length; ++i) {
                if (!deviceNode.hasChild(measurements[i])) {
                    throw new MetadataException(measurements[i] + " does not exist in " + deviceId);
                }
                measurementSchemas[i] = ((LeafMNode)deviceNode.getChild(measurements[i])).getSchema();
            }
            MeasurementSchema[] measurementSchemaArray = measurementSchemas;
            return measurementSchemaArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<String> getDevices(String prefixPath) throws MetadataException {
        this.lock.readLock().lock();
        try {
            Set<String> set = this.mtree.getDevices(prefixPath);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNodesList(String prefixPath, int nodeLevel) throws MetadataException {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mtree.getNodesList(prefixPath, nodeLevel);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getStorageGroupName(String path) throws MetadataException {
        this.lock.readLock().lock();
        try {
            String string = this.mtree.getStorageGroupName(path);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getAllStorageGroupNames() {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mtree.getAllStorageGroupNames();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<StorageGroupMNode> getAllStorageGroupNodes() {
        this.lock.readLock().lock();
        try {
            List<StorageGroupMNode> list = this.mtree.getAllStorageGroupNodes();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getAllTimeseriesName(String prefixPath) throws MetadataException {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mtree.getAllTimeseriesName(prefixPath);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Path> getAllTimeseriesPath(String prefixPath) throws MetadataException {
        this.lock.readLock().lock();
        try {
            List<Path> list = this.mtree.getAllTimeseriesPath(prefixPath);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getAllTimeseriesCount(String prefixPath) throws MetadataException {
        this.lock.readLock().lock();
        try {
            int n = this.mtree.getAllTimeseriesCount(prefixPath);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodesCountInGivenLevel(String prefixPath, int level) throws MetadataException {
        this.lock.readLock().lock();
        try {
            int n = this.mtree.getNodesCountInGivenLevel(prefixPath, level);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShowTimeSeriesResult> getAllTimeseriesSchema(ShowTimeSeriesPlan plan) throws MetadataException {
        this.lock.readLock().lock();
        try {
            String tagValue;
            if (!this.tagIndex.containsKey(plan.getKey())) {
                throw new MetadataException("The key " + plan.getKey() + " is not a tag.");
            }
            Map<String, Set<LeafMNode>> value2Node = this.tagIndex.get(plan.getKey());
            if (value2Node.isEmpty()) {
                throw new MetadataException("The key " + plan.getKey() + " is not a tag.");
            }
            TreeSet<LeafMNode> allMatchedNodes = new TreeSet<LeafMNode>(Comparator.comparing(MNode::getFullPath));
            if (plan.isContains()) {
                for (Map.Entry<String, Set<LeafMNode>> entry : value2Node.entrySet()) {
                    tagValue = entry.getKey();
                    if (!tagValue.contains(plan.getValue())) continue;
                    allMatchedNodes.addAll((Collection<LeafMNode>)entry.getValue());
                }
            } else {
                for (Map.Entry<String, Set<LeafMNode>> entry : value2Node.entrySet()) {
                    tagValue = entry.getKey();
                    if (!plan.getValue().equals(tagValue)) continue;
                    allMatchedNodes.addAll((Collection<LeafMNode>)entry.getValue());
                }
            }
            LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
            String[] prefixNodes = MetaUtils.getNodeNames(plan.getPath().getFullPath());
            int curOffset = -1;
            int count = 0;
            int limit = plan.getLimit();
            int offset = plan.getOffset();
            for (LeafMNode leaf : allMatchedNodes) {
                if (!this.match(leaf.getFullPath(), prefixNodes) || (limit != 0 || offset != 0) && (++curOffset < offset || count == limit)) continue;
                try {
                    Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leaf.getOffset());
                    ((Map)pair.left).putAll((Map)pair.right);
                    MeasurementSchema measurementSchema = leaf.getSchema();
                    res.add(new ShowTimeSeriesResult(leaf.getFullPath(), leaf.getAlias(), this.getStorageGroupName(leaf.getFullPath()), measurementSchema.getType().toString(), measurementSchema.getEncodingType().toString(), measurementSchema.getCompressor().toString(), (Map)pair.left));
                    if (limit == 0 && offset == 0) continue;
                    ++count;
                }
                catch (IOException e) {
                    throw new MetadataException("Something went wrong while deserialize tag info of " + leaf.getFullPath(), e);
                }
            }
            LinkedList<ShowTimeSeriesResult> linkedList = res;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean match(String fullPath, String[] prefixNodes) {
        String[] nodes = MetaUtils.getNodeNames(fullPath);
        if (nodes.length < prefixNodes.length) {
            return false;
        }
        for (int i = 0; i < prefixNodes.length; ++i) {
            if ("*".equals(prefixNodes[i]) || prefixNodes[i].equals(nodes[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShowTimeSeriesResult> showTimeseries(ShowTimeSeriesPlan plan) throws MetadataException {
        this.lock.readLock().lock();
        try {
            List<String[]> ans = this.mtree.getAllMeasurementSchema(plan);
            LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
            for (String[] ansString : ans) {
                long tagFileOffset = Long.parseLong(ansString[6]);
                try {
                    if (tagFileOffset < 0L) {
                        res.add(new ShowTimeSeriesResult(ansString[0], ansString[1], ansString[2], ansString[3], ansString[4], ansString[5], Collections.emptyMap()));
                        continue;
                    }
                    Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), tagFileOffset);
                    ((Map)pair.left).putAll((Map)pair.right);
                    res.add(new ShowTimeSeriesResult(ansString[0], ansString[1], ansString[2], ansString[3], ansString[4], ansString[5], (Map)pair.left));
                }
                catch (IOException e) {
                    throw new MetadataException("Something went wrong while deserialize tag info of " + ansString[0], e);
                }
            }
            LinkedList<ShowTimeSeriesResult> linkedList = res;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementSchema getSeriesSchema(String device, String measuremnet) throws MetadataException {
        this.lock.readLock().lock();
        try {
            InternalMNode node = (InternalMNode)this.mtree.getNodeByPath(device);
            MeasurementSchema measurementSchema = ((LeafMNode)node.getChild(measuremnet)).getSchema();
            return measurementSchema;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<String> getChildNodePathInNextLevel(String path) throws MetadataException {
        this.lock.readLock().lock();
        try {
            Set<String> set = this.mtree.getChildNodePathInNextLevel(path);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isPathExist(String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mtree.isPathExist(path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MNode getNodeByPath(String path) throws MetadataException {
        this.lock.readLock().lock();
        try {
            MNode mNode = this.mtree.getNodeByPath(path);
            return mNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StorageGroupMNode getStorageGroupNode(String path) throws MetadataException {
        this.lock.readLock().lock();
        try {
            StorageGroupMNode storageGroupMNode = this.mtree.getStorageGroupNode(path);
            return storageGroupMNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MNode getDeviceNodeWithAutoCreateAndReadLock(String path, boolean autoCreateSchema, int sgLevel) throws MetadataException {
        this.lock.readLock().lock();
        MNode node = null;
        try {
            MNode mNode = node = this.mNodeCache.get(path);
            return mNode;
        }
        catch (CacheException e) {
            if (!autoCreateSchema) {
                throw new PathNotExistException(path);
            }
        }
        finally {
            if (node != null) {
                ((InternalMNode)node).readLock();
            }
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            MNode e = node = this.mNodeCache.get(path);
            return e;
        }
        catch (CacheException e) {
            Object storageGroupName;
            boolean shouldSetStorageGroup = e.getCause() instanceof StorageGroupNotSetException;
            if (shouldSetStorageGroup) {
                storageGroupName = MetaUtils.getStorageGroupNameByLevel(path, sgLevel);
                this.setStorageGroup((String)storageGroupName);
            }
            node = this.mtree.getDeviceNodeWithAutoCreating(path, sgLevel);
            storageGroupName = node;
            return storageGroupName;
        }
        catch (StorageGroupAlreadySetException e) {
            MNode mNode = node = this.mtree.getDeviceNodeWithAutoCreating(path, sgLevel);
            return mNode;
        }
        finally {
            if (node != null) {
                ((InternalMNode)node).readLock();
            }
            this.lock.writeLock().unlock();
        }
    }

    public MNode getDeviceNodeWithAutoCreateAndReadLock(String path) throws MetadataException {
        return this.getDeviceNodeWithAutoCreateAndReadLock(path, this.config.isAutoCreateSchemaEnabled(), this.config.getDefaultStorageGroupLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MNode getChild(MNode parent, String child) {
        this.lock.readLock().lock();
        try {
            MNode mNode = parent.getChild(child);
            return mNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getMetadataInString() {
        this.lock.readLock().lock();
        try {
            String string = TIME_SERIES_TREE_HEADER + this.mtree.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMaxSeriesNumberAmongStorageGroup(long maxSeriesNumberAmongStorageGroup) {
        this.maxSeriesNumberAmongStorageGroup = maxSeriesNumberAmongStorageGroup;
    }

    public long getMaximalSeriesNumberAmongStorageGroups() {
        return this.maxSeriesNumberAmongStorageGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTL(String storageGroup, long dataTTL) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            this.getStorageGroupNode(storageGroup).setDataTTL(dataTTL);
            if (!this.isRecovering) {
                this.logWriter.setTTL(storageGroup, dataTTL);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeOffset(String path, long offset) throws MetadataException {
        this.lock.writeLock().lock();
        try {
            ((LeafMNode)this.mtree.getNodeByPath(path)).setOffset(offset);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAlias(String path, String alias) throws MetadataException {
        this.lock.writeLock().lock();
        try {
            LeafMNode leafMNode = (LeafMNode)this.mtree.getNodeByPath(path);
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            leafMNode.getParent().addAlias(alias, leafMNode);
            leafMNode.setAlias(alias);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, String fullPath) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            MNode mNode = this.mtree.getNodeByPath(fullPath);
            if (!(mNode instanceof LeafMNode)) {
                throw new PathNotExistException(fullPath);
            }
            LeafMNode leafMNode = (LeafMNode)mNode;
            if (alias != null && !alias.equals(leafMNode.getAlias())) {
                if (leafMNode.getParent().hasChild(alias)) {
                    throw new MetadataException("The alias already exists.");
                }
                if (leafMNode.getAlias() != null) {
                    leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
                }
                leafMNode.getParent().addAlias(alias, leafMNode);
                leafMNode.setAlias(alias);
                this.logWriter.changeAlias(fullPath, alias);
            }
            if (tagsMap == null && attributesMap == null) {
                return;
            }
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagLogFile.write(tagsMap, attributesMap);
                this.logWriter.changeOffset(fullPath, offset);
                leafMNode.setOffset(offset);
                if (tagsMap != null) {
                    for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                        this.tagIndex.computeIfAbsent(entry.getKey(), k -> new HashMap()).computeIfAbsent(entry.getValue(), v -> new HashSet()).add(leafMNode);
                    }
                }
                return;
            }
            Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leafMNode.getOffset());
            if (tagsMap != null) {
                for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    String beforeValue = (String)((Map)pair.left).get(key);
                    ((Map)pair.left).put(key, value);
                    if (beforeValue != null && !beforeValue.equals(value)) {
                        if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("Upsert: TimeSeries %s is removed from tag inverted index, tag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath(), key, beforeValue, leafMNode.getOffset()));
                            }
                            this.tagIndex.get(key).get(beforeValue).remove(leafMNode);
                            if (this.tagIndex.get(key).get(beforeValue).isEmpty()) {
                                this.tagIndex.get(key).remove(beforeValue);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Upsert: TimeSeries %s's tag info has been removed from tag inverted index before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath(), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
                        }
                    }
                    if (beforeValue != null && beforeValue.equals(value)) continue;
                    this.tagIndex.computeIfAbsent(key, k -> new HashMap()).computeIfAbsent(value, v -> new HashSet()).add(leafMNode);
                }
            }
            ((Map)pair.right).putAll(attributesMap);
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Map<String, String> attributesMap, String fullPath) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            MNode mNode = this.mtree.getNodeByPath(fullPath);
            if (!(mNode instanceof LeafMNode)) {
                throw new PathNotExistException(fullPath);
            }
            LeafMNode leafMNode = (LeafMNode)mNode;
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagLogFile.write(Collections.emptyMap(), attributesMap);
                this.logWriter.changeOffset(fullPath, offset);
                leafMNode.setOffset(offset);
                return;
            }
            Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leafMNode.getOffset());
            for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (((Map)pair.right).containsKey(key)) {
                    throw new MetadataException(String.format("TimeSeries [%s] already has the attribute [%s].", fullPath, key));
                }
                ((Map)pair.right).put(key, value);
            }
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTags(Map<String, String> tagsMap, String fullPath) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            MNode mNode = this.mtree.getNodeByPath(fullPath);
            if (!(mNode instanceof LeafMNode)) {
                throw new PathNotExistException(fullPath);
            }
            LeafMNode leafMNode = (LeafMNode)mNode;
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagLogFile.write(tagsMap, Collections.emptyMap());
                this.logWriter.changeOffset(fullPath, offset);
                leafMNode.setOffset(offset);
                for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                    this.tagIndex.computeIfAbsent(entry.getKey(), k -> new HashMap()).computeIfAbsent(entry.getValue(), v -> new HashSet()).add(leafMNode);
                }
                return;
            }
            Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leafMNode.getOffset());
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                String key2 = entry.getKey();
                String value2 = entry.getValue();
                if (((Map)pair.left).containsKey(key2)) {
                    throw new MetadataException(String.format("TimeSeries [%s] already has the tag [%s].", fullPath, key2));
                }
                ((Map)pair.left).put(key2, value2);
            }
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
            tagsMap.forEach((key, value) -> this.tagIndex.computeIfAbsent((String)key, k -> new HashMap()).computeIfAbsent(value, v -> new HashSet()).add(leafMNode));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTagsOrAttributes(Set<String> keySet, String fullPath) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            MNode mNode = this.mtree.getNodeByPath(fullPath);
            if (!(mNode instanceof LeafMNode)) {
                throw new PathNotExistException(fullPath);
            }
            LeafMNode leafMNode = (LeafMNode)mNode;
            if (leafMNode.getOffset() < 0L) {
                return;
            }
            Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leafMNode.getOffset());
            HashMap<String, String> deleteTag = new HashMap<String, String>();
            for (String string : keySet) {
                if (((Map)pair.left).containsKey(string)) {
                    deleteTag.put(string, (String)((Map)pair.left).remove(string));
                    continue;
                }
                ((Map)pair.right).remove(string);
            }
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
            for (Map.Entry entry : deleteTag.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(value)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Drop: TimeSeries %s is removed from tag inverted index, tag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath(), entry.getKey(), entry.getValue(), leafMNode.getOffset()));
                    }
                    this.tagIndex.get(key).get(value).remove(leafMNode);
                    if (!this.tagIndex.get(key).get(value).isEmpty()) continue;
                    this.tagIndex.get(key).remove(value);
                    if (!this.tagIndex.get(key).isEmpty()) continue;
                    this.tagIndex.remove(key);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Drop: TimeSeries %s's tag info has been removed from tag inverted index before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath(), key, value, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTagsOrAttributesValue(Map<String, String> alterMap, String fullPath) throws MetadataException, IOException {
        this.lock.writeLock().lock();
        try {
            String key;
            MNode mNode = this.mtree.getNodeByPath(fullPath);
            if (!(mNode instanceof LeafMNode)) {
                throw new PathNotExistException(fullPath);
            }
            LeafMNode leafMNode = (LeafMNode)mNode;
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
            }
            Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leafMNode.getOffset());
            HashMap<String, String> oldTagValue = new HashMap<String, String>();
            HashMap<String, String> newTagValue = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : alterMap.entrySet()) {
                key = entry.getKey();
                String value = entry.getValue();
                if (((Map)pair.left).containsKey(key)) {
                    oldTagValue.put(key, (String)((Map)pair.left).get(key));
                    newTagValue.put(key, value);
                    ((Map)pair.left).put(key, value);
                    continue;
                }
                if (((Map)pair.right).containsKey(key)) {
                    ((Map)pair.right).put(key, value);
                    continue;
                }
                throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, key));
            }
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
            for (Map.Entry<String, String> entry : oldTagValue.entrySet()) {
                key = entry.getKey();
                String beforeValue = entry.getValue();
                String currentValue = (String)newTagValue.get(key);
                if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Set: TimeSeries %s is removed from tag inverted index, tag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath(), entry.getKey(), beforeValue, leafMNode.getOffset()));
                    }
                    this.tagIndex.get(key).get(beforeValue).remove(leafMNode);
                } else if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Set: TimeSeries %s's tag info has been removed from tag inverted index before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath(), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
                }
                this.tagIndex.computeIfAbsent(key, k -> new HashMap()).computeIfAbsent(currentValue, k -> new HashSet()).add(leafMNode);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTagOrAttributeKey(String oldKey, String newKey, String fullPath) throws MetadataException, IOException {
        block12: {
            this.lock.writeLock().lock();
            try {
                MNode mNode = this.mtree.getNodeByPath(fullPath);
                if (!(mNode instanceof LeafMNode)) {
                    throw new PathNotExistException(fullPath);
                }
                LeafMNode leafMNode = (LeafMNode)mNode;
                if (leafMNode.getOffset() < 0L) {
                    throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey));
                }
                Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(this.config.getTagAttributeTotalSize(), leafMNode.getOffset());
                if (((Map)pair.left).containsKey(newKey) || ((Map)pair.right).containsKey(newKey)) {
                    throw new MetadataException(String.format("TimeSeries [%s] already has a tag/attribute named [%s].", fullPath, newKey));
                }
                if (((Map)pair.left).containsKey(oldKey)) {
                    String value = (String)((Map)pair.left).remove(oldKey);
                    ((Map)pair.left).put(newKey, value);
                    this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
                    if (this.tagIndex.containsKey(oldKey) && this.tagIndex.get(oldKey).containsKey(value)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Rename: TimeSeries %s is removed from tag inverted index, tag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath(), oldKey, value, leafMNode.getOffset()));
                        }
                        this.tagIndex.get(oldKey).get(value).remove(leafMNode);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Rename: TimeSeries %s's tag info has been removed from tag inverted index before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath(), oldKey, value, leafMNode.getOffset(), this.tagIndex.containsKey(oldKey)));
                    }
                    this.tagIndex.computeIfAbsent(newKey, k -> new HashMap()).computeIfAbsent(value, k -> new HashSet()).add(leafMNode);
                    break block12;
                }
                if (((Map)pair.right).containsKey(oldKey)) {
                    ((Map)pair.right).put(newKey, (String)((Map)pair.right).remove(oldKey));
                    this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
                    break block12;
                }
                throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, oldKey));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    boolean checkStorageGroupByPath(String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mtree.checkStorageGroupByPath(path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    List<String> getStorageGroupByPath(String path) throws MetadataException {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mtree.getStorageGroupByPath(path);
            return list;
        }
        catch (MetadataException e) {
            throw new MetadataException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void collectSeries(MNode startingNode, Collection<MeasurementSchema> timeseriesSchemas) {
        ArrayDeque<MNode> nodeDeque = new ArrayDeque<MNode>();
        nodeDeque.addLast(startingNode);
        while (!nodeDeque.isEmpty()) {
            MNode node = (MNode)nodeDeque.removeFirst();
            if (node instanceof LeafMNode) {
                MeasurementSchema nodeSchema = ((LeafMNode)node).getSchema();
                timeseriesSchemas.add(new MeasurementSchema(node.getFullPath(), nodeSchema.getType(), nodeSchema.getEncodingType(), nodeSchema.getCompressor()));
                continue;
            }
            if (node.getChildren().isEmpty()) continue;
            nodeDeque.addAll(node.getChildren().values());
        }
    }

    public void collectSeries(String startingPath, List<MeasurementSchema> timeseriesSchemas) {
        MNode mNode;
        try {
            mNode = this.getNodeByPath(startingPath);
        }
        catch (MetadataException e) {
            return;
        }
        this.collectSeries(mNode, timeseriesSchemas);
    }

    public Map<String, String> determineStorageGroup(String path) throws IllegalPathException {
        this.lock.readLock().lock();
        try {
            Map<String, String> map = this.mtree.determineStorageGroup(path);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class MManagerHolder {
        private static final MManager INSTANCE = new MManager();

        private MManagerHolder() {
        }
    }
}

