/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.ActiveTimeSeriesCounter;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.rescon.MemTablePool;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TsFileProcessor.class);
    private final String storageGroupName;
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final ConcurrentLinkedDeque<IMemTable> flushingMemTables = new ConcurrentLinkedDeque();
    private RestorableTsFileIOWriter writer;
    private TsFileResource tsFileResource;
    private long timeRangeId;
    private volatile boolean managedByFlushManager;
    private ReadWriteLock flushQueryLock = new ReentrantReadWriteLock();
    private volatile boolean shouldClose;
    private IMemTable workMemTable;
    private VersionController versionController;
    private StorageGroupProcessor.CloseTsFileCallBack closeTsFileCallback;
    private StorageGroupProcessor.UpdateEndTimeCallBack updateLatestFlushTimeCallback;
    private WriteLogNode logNode;
    private boolean sequence;
    private long totalMemTableSize;
    private static final String FLUSH_QUERY_WRITE_LOCKED = "{}: {} get flushQueryLock write lock";
    private static final String FLUSH_QUERY_WRITE_RELEASE = "{}: {} get flushQueryLock write lock released";

    TsFileProcessor(String storageGroupName, File tsfile, VersionController versionController, StorageGroupProcessor.CloseTsFileCallBack closeTsFileCallback, StorageGroupProcessor.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence) throws IOException {
        this.storageGroupName = storageGroupName;
        this.tsFileResource = new TsFileResource(tsfile, this);
        this.versionController = versionController;
        this.writer = new RestorableTsFileIOWriter(tsfile);
        this.closeTsFileCallback = closeTsFileCallback;
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        logger.info("create a new tsfile processor {}", (Object)tsfile.getAbsolutePath());
        this.tsFileResource.setHistoricalVersions(Collections.singleton(versionController.currVersion()));
    }

    public VersionController getVersionController() {
        return this.versionController;
    }

    public void setVersionController(VersionController versionController) {
        this.versionController = versionController;
    }

    public TsFileProcessor(String storageGroupName, TsFileResource tsFileResource, VersionController versionController, StorageGroupProcessor.CloseTsFileCallBack closeUnsealedTsFileProcessor, StorageGroupProcessor.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence, RestorableTsFileIOWriter writer) {
        this.storageGroupName = storageGroupName;
        this.tsFileResource = tsFileResource;
        this.versionController = versionController;
        this.writer = writer;
        this.closeTsFileCallback = closeUnsealedTsFileProcessor;
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        logger.info("reopen a tsfile processor {}", (Object)tsFileResource.getFile());
    }

    public void insert(InsertPlan insertPlan) throws WriteProcessException {
        if (this.workMemTable == null) {
            this.workMemTable = MemTablePool.getInstance().getAvailableMemTable(this);
        }
        this.workMemTable.insert(insertPlan);
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            try {
                this.getLogNode().write(insertPlan);
            }
            catch (Exception e) {
                throw new WriteProcessException(String.format("%s: %s write WAL failed", this.storageGroupName, this.tsFileResource.getFile().getAbsolutePath()), e);
            }
        }
        this.tsFileResource.updateStartTime(insertPlan.getDeviceId(), insertPlan.getTime());
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertPlan.getDeviceId(), insertPlan.getTime());
        }
    }

    public void insertTablet(InsertTabletPlan insertTabletPlan, int start, int end, TSStatus[] results) throws WriteProcessException {
        if (this.workMemTable == null) {
            this.workMemTable = MemTablePool.getInstance().getAvailableMemTable(this);
        }
        try {
            this.workMemTable.insertTablet(insertTabletPlan, start, end);
            if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
                insertTabletPlan.setStart(start);
                insertTabletPlan.setEnd(end);
                this.getLogNode().write(insertTabletPlan);
            }
        }
        catch (Exception e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            }
            throw new WriteProcessException(e);
        }
        for (int i = start; i < end; ++i) {
            results[i] = RpcUtils.SUCCESS_STATUS;
        }
        this.tsFileResource.updateStartTime(insertTabletPlan.getDeviceId(), insertTabletPlan.getTimes()[start]);
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertTabletPlan.getDeviceId(), insertTabletPlan.getTimes()[end - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataInMemory(Deletion deletion) {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        try {
            if (this.workMemTable != null) {
                this.workMemTable.delete(deletion.getDevice(), deletion.getMeasurement(), deletion.getTimestamp());
            }
            for (IMemTable memTable : this.flushingMemTables) {
                memTable.delete(deletion);
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
        }
    }

    public TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    boolean shouldFlush() {
        if (this.workMemTable == null) {
            return false;
        }
        if (this.workMemTable.memSize() >= this.getMemtableSizeThresholdBasedOnSeriesNum()) {
            logger.info("The memtable size {} of tsfile {} reaches the threshold", (Object)this.workMemTable.memSize(), (Object)this.tsFileResource.getFile().getAbsolutePath());
            return true;
        }
        if (this.workMemTable.reachTotalPointNumThreshold()) {
            logger.info("The avg series points num {} of tsfile {} reaches the threshold", (Object)(this.workMemTable.getTotalPointsNum() / (long)this.workMemTable.getSeriesNumber()), (Object)this.tsFileResource.getFile().getAbsolutePath());
            return true;
        }
        return false;
    }

    private long getMemtableSizeThresholdBasedOnSeriesNum() {
        if (!this.config.isEnableParameterAdapter()) {
            return this.config.getMemtableSizeThreshold();
        }
        long memTableSize = (long)((double)(this.config.getMemtableSizeThreshold() * (long)this.config.getMaxMemtableNumber() / (long)IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition() / 4L) * ActiveTimeSeriesCounter.getInstance().getActiveRatio(this.storageGroupName));
        return Math.max(memTableSize, this.config.getMemtableSizeThreshold());
    }

    public boolean shouldClose() {
        long fileSizeThreshold;
        long fileSize = this.tsFileResource.getFileSize();
        if (fileSize >= (fileSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getTsFileSizeThreshold())) {
            logger.info("{} fileSize {} >= fileSizeThreshold {}", new Object[]{this.tsFileResource.getPath(), fileSize, fileSizeThreshold});
        }
        return fileSize >= fileSizeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncClose() {
        logger.info("Sync close file: {}, will firstly async close it", (Object)this.tsFileResource.getFile().getAbsolutePath());
        if (this.shouldClose) {
            return;
        }
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            try {
                this.asyncClose();
                long startTime = System.currentTimeMillis();
                while (!this.flushingMemTables.isEmpty()) {
                    this.flushingMemTables.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s for waiting flushing one memtable; {} left (first: {}). FlushingManager info: {}", new Object[]{this.tsFileResource.getFile().getAbsolutePath(), (System.currentTimeMillis() - startTime) / 1000L, this.flushingMemTables.size(), this.flushingMemTables.getFirst(), FlushManager.getInstance()});
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait close interrupted", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
        logger.info("File {} is closed synchronously", (Object)this.tsFileResource.getFile().getAbsolutePath());
    }

    void asyncClose() {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        try {
            if (logger.isInfoEnabled()) {
                if (this.workMemTable != null) {
                    logger.info("{}: flush a working memtable in async close tsfile {}, memtable size: {}, tsfile size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getAbsolutePath(), this.workMemTable.memSize(), this.tsFileResource.getFileSize()});
                } else {
                    logger.info("{}: flush a NotifyFlushMemTable in async close tsfile {}, tsfile size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getAbsolutePath(), this.tsFileResource.getFileSize()});
                }
            }
            if (this.shouldClose) {
                return;
            }
            NotifyFlushMemTable tmpMemTable = this.workMemTable == null || this.workMemTable.memSize() == 0L ? new NotifyFlushMemTable() : this.workMemTable;
            try {
                this.addAMemtableIntoFlushingList(tmpMemTable);
                this.shouldClose = true;
                this.tsFileResource.setCloseFlag();
            }
            catch (Exception e) {
                logger.error("{}: {} async close failed, because", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFlush() throws IOException {
        IMemTable tmpMemTable;
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        try {
            IMemTable iMemTable = tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            if (logger.isDebugEnabled() && tmpMemTable.isSignalMemTable()) {
                logger.debug("{}: {} add a signal memtable into flushing memtable list when sync flush", (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
            this.addAMemtableIntoFlushingList(tmpMemTable);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.error(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
        }
        IMemTable iMemTable = tmpMemTable;
        synchronized (iMemTable) {
            try {
                long startWait = System.currentTimeMillis();
                while (this.flushingMemTables.contains(tmpMemTable)) {
                    tmpMemTable.wait(1000L);
                    if (System.currentTimeMillis() - startWait <= 60000L) continue;
                    logger.warn("has waited for synced flushing a memtable in {} for 60 seconds.", (Object)this.tsFileResource.getFile().getAbsolutePath());
                    startWait = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait flush finished meets error", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncFlush() {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        try {
            if (this.workMemTable == null) {
                return;
            }
            this.addAMemtableIntoFlushingList(this.workMemTable);
        }
        catch (Exception e) {
            logger.error("{}: {} add a memtable into flushing listfailed", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
        }
    }

    private void addAMemtableIntoFlushingList(IMemTable tobeFlushed) throws IOException {
        if (!(tobeFlushed.isSignalMemTable() || this.updateLatestFlushTimeCallback.call(this) && tobeFlushed.memSize() != 0L)) {
            logger.warn("This normal memtable is empty, skip it in flush. {}: {} Memetable info: {}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), tobeFlushed.getMemTableMap()});
            return;
        }
        this.flushingMemTables.addLast(tobeFlushed);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} Memtable (signal = {}) is added into the flushing Memtable, queue size = {}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), tobeFlushed.isSignalMemTable(), this.flushingMemTables.size()});
        }
        long cur = this.versionController.nextVersion();
        tobeFlushed.setVersion(cur);
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            this.getLogNode().notifyStartFlush();
        }
        if (!tobeFlushed.isSignalMemTable()) {
            this.totalMemTableSize += tobeFlushed.memSize();
        }
        this.workMemTable = null;
        FlushManager.getInstance().registerTsFileProcessor(this);
    }

    private void releaseFlushedMemTable(IMemTable memTable) {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        try {
            this.writer.makeMetadataVisible();
            if (!this.flushingMemTables.remove(memTable)) {
                logger.warn("{}: {} put the memtable (signal={}) out of flushingMemtables but it is not in the queue.", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), memTable.isSignalMemTable()});
            } else if (logger.isDebugEnabled()) {
                logger.debug("{}: {} memtable (signal={}) is removed from the queue. {} left.", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), memTable.isSignalMemTable(), this.flushingMemTables.size()});
            }
            memTable.release();
            MemTablePool.getInstance().putBack(memTable, this.storageGroupName);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} flush finished, remove a memtable from flushing list, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), this.flushingMemTables.size()});
            }
        }
        catch (Exception e) {
            logger.error("{}: {}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOneMemTable() {
        Object flushTask;
        IMemTable memTableToFlush = this.flushingMemTables.getFirst();
        if (logger.isInfoEnabled()) {
            logger.info("{}: {} starts to flush a memtable in a flush thread", (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        if (!memTableToFlush.isSignalMemTable()) {
            flushTask = new MemTableFlushTask(memTableToFlush, this.writer, this.storageGroupName);
            try {
                this.writer.mark();
                ((MemTableFlushTask)flushTask).syncFlushMemTable();
            }
            catch (Exception e) {
                logger.error("{}: {} meet error when flushing a memtable, change system mode to read-only", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                try {
                    logger.error("{}: {} IOTask meets error, truncate the corrupted data", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
                    this.writer.reset();
                }
                catch (IOException e1) {
                    logger.error("{}: {} Truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e1});
                }
                Thread.currentThread().interrupt();
            }
            if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
                this.getLogNode().notifyEndFlush();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} try get lock to release a memtable (signal={})", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), memTableToFlush.isSignalMemTable()});
        }
        flushTask = memTableToFlush;
        synchronized (flushTask) {
            this.releaseFlushedMemTable(memTableToFlush);
            memTableToFlush.notifyAll();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} released a memtable (signal={}), flushingMemtables size ={}", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), memTableToFlush.isSignalMemTable(), this.flushingMemTables.size()});
            }
        }
        if (this.shouldClose && this.flushingMemTables.isEmpty()) {
            try {
                this.writer.mark();
                try {
                    double compressionRatio = (double)this.totalMemTableSize / (double)this.writer.getPos();
                    if (logger.isDebugEnabled()) {
                        logger.debug("The compression ratio of tsfile {} is {}, totalMemTableSize: {}, the file size: {}", new Object[]{this.writer.getFile().getAbsolutePath(), compressionRatio, this.totalMemTableSize, this.writer.getPos()});
                    }
                    if (compressionRatio == 0.0 && !memTableToFlush.isSignalMemTable()) {
                        logger.error("{} The compression ratio of tsfile {} is 0, totalMemTableSize: {}, the file size: {}", new Object[]{this.storageGroupName, this.writer.getFile().getAbsolutePath(), this.totalMemTableSize, this.writer.getPos()});
                    }
                    CompressionRatio.getInstance().updateRatio(compressionRatio);
                }
                catch (IOException e) {
                    logger.error("{}: {} update compression ratio failed", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: {} flushingMemtables is empty and will close the file", (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
                }
                this.endFile();
            }
            catch (Exception e) {
                logger.error("{} meet error when flush FileMetadata to {}, change system mode to read-only", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getAbsolutePath(), e});
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                try {
                    this.writer.reset();
                }
                catch (IOException e1) {
                    logger.error("{}: {} truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e1});
                }
                logger.error("{}: {} marking or ending file meet error", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} try to get flushingMemtables lock.", (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
            ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
            synchronized (concurrentLinkedDeque) {
                this.flushingMemTables.notifyAll();
            }
        }
    }

    private void endFile() throws IOException, TsFileProcessorException {
        long closeStartTime = System.currentTimeMillis();
        this.tsFileResource.serialize();
        this.writer.endFile();
        this.tsFileResource.cleanCloseFlag();
        this.closeTsFileCallback.call(this);
        if (logger.isInfoEnabled()) {
            long closeEndTime = System.currentTimeMillis();
            logger.info("Storage group {} close the file {}, TsFile size is {}, time consumption of flushing metadata is {}ms", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getAbsoluteFile(), this.writer.getFile().length(), closeEndTime - closeStartTime});
        }
        this.writer = null;
    }

    public boolean isManagedByFlushManager() {
        return this.managedByFlushManager;
    }

    public void setManagedByFlushManager(boolean managedByFlushManager) {
        this.managedByFlushManager = managedByFlushManager;
    }

    WriteLogNode getLogNode() {
        if (this.logNode == null) {
            this.logNode = MultiFileLogNodeManager.getInstance().getNode(this.storageGroupName + "-" + this.tsFileResource.getFile().getName());
        }
        return this.logNode;
    }

    public void close() throws TsFileProcessorException {
        try {
            this.tsFileResource.close();
            MultiFileLogNodeManager.getInstance().deleteNode(this.storageGroupName + "-" + this.tsFileResource.getFile().getName());
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
    }

    public int getFlushingMemTableSize() {
        return this.flushingMemTables.size();
    }

    public long getWorkMemTableMemory() {
        return this.workMemTable.memSize();
    }

    RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<ReadOnlyMemChunk>, List<ChunkMetadata>> query(String deviceId, String measurementId, TSDataType dataType, TSEncoding encoding, Map<String, String> props, QueryContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} get flushQueryLock read lock", (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
        }
        this.flushQueryLock.readLock().lock();
        try {
            ReadOnlyMemChunk memChunk;
            ArrayList<ReadOnlyMemChunk> readOnlyMemChunks = new ArrayList<ReadOnlyMemChunk>();
            for (IMemTable flushingMemTable : this.flushingMemTables) {
                ReadOnlyMemChunk memChunk2;
                if (flushingMemTable.isSignalMemTable() || (memChunk2 = flushingMemTable.query(deviceId, measurementId, dataType, encoding, props, context.getQueryTimeLowerBound())) == null) continue;
                readOnlyMemChunks.add(memChunk2);
            }
            if (this.workMemTable != null && (memChunk = this.workMemTable.query(deviceId, measurementId, dataType, encoding, props, context.getQueryTimeLowerBound())) != null) {
                readOnlyMemChunks.add(memChunk);
            }
            ModificationFile modificationFile = this.tsFileResource.getModFile();
            List<Modification> modifications = context.getPathModifications(modificationFile, deviceId + '.' + measurementId);
            List chunkMetadataList = this.writer.getVisibleMetadataList(deviceId, measurementId, dataType);
            QueryUtils.modifyChunkMetaData(chunkMetadataList, modifications);
            chunkMetadataList.removeIf(context::chunkNotSatisfy);
            Pair pair = new Pair(readOnlyMemChunks, (Object)chunkMetadataList);
            return pair;
        }
        catch (Exception e) {
            logger.error("{}: {} get ReadOnlyMemChunk has error", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getName(), e});
        }
        finally {
            this.flushQueryLock.readLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} release flushQueryLock read lock", (Object)this.storageGroupName, (Object)this.tsFileResource.getFile().getName());
            }
        }
        return null;
    }

    public long getTimeRangeId() {
        return this.timeRangeId;
    }

    public void setTimeRangeId(long timeRangeId) {
        this.timeRangeId = timeRangeId;
    }
}

