/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.engine.merge.manage.MergeContext;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeLogger;
import org.apache.iotdb.db.engine.merge.task.MergeCallback;
import org.apache.iotdb.db.engine.merge.task.MergeFileTask;
import org.apache.iotdb.db.engine.merge.task.MergeMultiChunkTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.utils.MergeUtils;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTask
implements Callable<Void> {
    public static final String MERGE_SUFFIX = ".merge";
    private static final Logger logger = LoggerFactory.getLogger(MergeTask.class);
    MergeResource resource;
    String storageGroupSysDir;
    String storageGroupName;
    MergeLogger mergeLogger;
    MergeContext mergeContext = new MergeContext();
    private MergeCallback callback;
    int concurrentMergeSeriesNum;
    String taskName;
    boolean fullMerge;

    MergeTask(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, String storageGroupName) {
        this.resource = new MergeResource(seqFiles, unseqFiles);
        this.storageGroupSysDir = storageGroupSysDir;
        this.callback = callback;
        this.taskName = taskName;
        this.fullMerge = fullMerge;
        this.concurrentMergeSeriesNum = 1;
        this.storageGroupName = storageGroupName;
    }

    public MergeTask(MergeResource mergeResource, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, int concurrentMergeSeriesNum, String storageGroupName) {
        this.resource = mergeResource;
        this.storageGroupSysDir = storageGroupSysDir;
        this.callback = callback;
        this.taskName = taskName;
        this.fullMerge = fullMerge;
        this.concurrentMergeSeriesNum = concurrentMergeSeriesNum;
        this.storageGroupName = storageGroupName;
    }

    @Override
    public Void call() throws Exception {
        try {
            this.doMerge();
        }
        catch (Exception e) {
            logger.error("Runtime exception in merge {}", (Object)this.taskName, (Object)e);
            this.cleanUp(false);
            this.callback.call(Collections.emptyList(), Collections.emptyList(), new File(this.storageGroupSysDir, "merge.log"));
            throw e;
        }
        return null;
    }

    private void doMerge() throws IOException, MetadataException {
        if (logger.isInfoEnabled()) {
            logger.info("{} starts to merge {} seqFiles, {} unseqFiles", new Object[]{this.taskName, this.resource.getSeqFiles().size(), this.resource.getUnseqFiles().size()});
        }
        long startTime = System.currentTimeMillis();
        long totalFileSize = MergeUtils.collectFileSizes(this.resource.getSeqFiles(), this.resource.getUnseqFiles());
        this.mergeLogger = new MergeLogger(this.storageGroupSysDir);
        this.mergeLogger.logFiles(this.resource);
        Set<String> devices = MManager.getInstance().getDevices(this.storageGroupName);
        HashMap<Path, MeasurementSchema> measurementSchemaMap = new HashMap<Path, MeasurementSchema>();
        ArrayList<Path> unmergedSeries = new ArrayList<Path>();
        for (String device : devices) {
            InternalMNode deviceNode = (InternalMNode)MManager.getInstance().getNodeByPath(device);
            for (Map.Entry<String, MNode> entry : deviceNode.getChildren().entrySet()) {
                Path path = new Path(device, entry.getKey());
                measurementSchemaMap.put(path, ((LeafMNode)entry.getValue()).getSchema());
                unmergedSeries.add(path);
            }
        }
        this.resource.setMeasurementSchemaMap(measurementSchemaMap);
        this.mergeLogger.logMergeStart();
        MergeMultiChunkTask mergeChunkTask = new MergeMultiChunkTask(this.mergeContext, this.taskName, this.mergeLogger, this.resource, this.fullMerge, unmergedSeries, this.concurrentMergeSeriesNum);
        mergeChunkTask.mergeSeries();
        MergeFileTask mergeFileTask = new MergeFileTask(this.taskName, this.mergeContext, this.mergeLogger, this.resource, this.resource.getSeqFiles());
        mergeFileTask.mergeFiles();
        this.cleanUp(true);
        if (logger.isInfoEnabled()) {
            double elapsedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            double byteRate = (double)totalFileSize / elapsedTime / 1024.0 / 1024.0;
            double seriesRate = (double)unmergedSeries.size() / elapsedTime;
            double chunkRate = (double)this.mergeContext.getTotalChunkWritten() / elapsedTime;
            double fileRate = (double)(this.resource.getSeqFiles().size() + this.resource.getUnseqFiles().size()) / elapsedTime;
            double ptRate = (double)this.mergeContext.getTotalPointWritten() / elapsedTime;
            logger.info("{} ends after {}s, byteRate: {}MB/s, seriesRate {}/s, chunkRate: {}/s, fileRate: {}/s, ptRate: {}/s", new Object[]{this.taskName, elapsedTime, byteRate, seriesRate, chunkRate, fileRate, ptRate});
        }
    }

    void cleanUp(boolean executeCallback) throws IOException {
        logger.info("{} is cleaning up", (Object)this.taskName);
        this.resource.clear();
        this.mergeContext.clear();
        if (this.mergeLogger != null) {
            this.mergeLogger.close();
        }
        for (TsFileResource seqFile : this.resource.getSeqFiles()) {
            File mergeFile = new File(seqFile.getPath() + MERGE_SUFFIX);
            mergeFile.delete();
            seqFile.setMerging(false);
        }
        for (TsFileResource unseqFile : this.resource.getUnseqFiles()) {
            unseqFile.setMerging(false);
        }
        File logFile = new File(this.storageGroupSysDir, "merge.log");
        if (executeCallback) {
            this.callback.call(this.resource.getSeqFiles(), this.resource.getUnseqFiles(), logFile);
        } else {
            logFile.delete();
        }
    }
}

