/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.cost.statistic;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.cost.statistic.ConcurrentCircularArray;
import org.apache.iotdb.db.cost.statistic.MeasurementMBean;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Measurement
implements MeasurementMBean,
IService {
    private static Logger logger = LoggerFactory.getLogger(Measurement.class);
    private ConcurrentCircularArray[] operationLatenciesQueue;
    private final int queueSize;
    private long[] operationLatencies;
    private long[] operationCnt;
    private static final int[] BUCKET_IN_MS = new int[]{1, 4, 16, 64, 256, 1024, Integer.MAX_VALUE};
    private static final int BUCKET_SIZE = BUCKET_IN_MS.length;
    private long[][] operationHistogram;
    private ScheduledExecutorService service;
    private ScheduledFuture<?> displayFuture;
    private ScheduledFuture<?> consumeFuture;
    private ReentrantLock stateChangeLock = new ReentrantLock();
    public static final Measurement INSTANCE = AsyncMeasurementHolder.access$000();
    private boolean isEnableStat;
    private long displayIntervalInMs;
    private Map<String, Boolean> operationSwitch;
    private static final Logger LOGGER = LoggerFactory.getLogger(Measurement.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.db.cost.statistic", "type", this.getID().getJmxName());

    private Measurement() {
        IoTDBConfig tdbConfig = IoTDBDescriptor.getInstance().getConfig();
        this.isEnableStat = tdbConfig.isEnablePerformanceStat();
        this.displayIntervalInMs = tdbConfig.getPerformanceStatDisplayInterval();
        int memoryInKb = tdbConfig.getPerformanceStatMemoryInKB();
        this.queueSize = memoryInKb * 1000 / Operation.values().length / 8;
        this.operationLatenciesQueue = new ConcurrentCircularArray[Operation.values().length];
        this.operationLatencies = new long[Operation.values().length];
        this.operationCnt = new long[Operation.values().length];
        this.operationSwitch = new HashMap<String, Boolean>(Operation.values().length);
        for (Operation op : Operation.values()) {
            this.operationLatenciesQueue[op.ordinal()] = new ConcurrentCircularArray(this.queueSize);
            this.operationCnt[op.ordinal()] = 0L;
            this.operationLatencies[op.ordinal()] = 0L;
            this.operationSwitch.put(op.getName(), true);
        }
        this.operationHistogram = new long[Operation.values().length][BUCKET_SIZE];
        for (Operation operation : Operation.values()) {
            for (int i = 0; i < BUCKET_SIZE; ++i) {
                this.operationHistogram[operation.ordinal()][i] = 0L;
            }
        }
        logger.info("start measurement stats module...");
        this.service = IoTDBThreadPoolFactory.newScheduledThreadPool(2, ThreadName.TIME_COST_STATSTIC.getName());
    }

    public boolean addOperationLatency(Operation op, long startTime) {
        if (this.isEnableStat && this.operationSwitch.get(op.getName()).booleanValue()) {
            return this.operationLatenciesQueue[op.ordinal()].put(System.currentTimeMillis() - startTime);
        }
        return false;
    }

    @Override
    public void startStatistics() {
        this.stateChangeLock.lock();
        try {
            this.isEnableStat = true;
            if (this.consumeFuture != null && !this.consumeFuture.isCancelled()) {
                logger.info("The consuming task in measurement stat module is already running...");
            } else {
                this.consumeFuture = this.service.scheduleWithFixedDelay(new DisplayRunnable(), 20L, this.displayIntervalInMs, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            LOGGER.error("Find error when start performance statistic thread, because {}", (Throwable)e);
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    @Override
    public void startContinuousPrintStatistics() {
        this.stateChangeLock.lock();
        try {
            this.isEnableStat = true;
            if (this.displayFuture != null && !this.displayFuture.isCancelled()) {
                logger.info("The display task in measurement stat module is already running...");
            } else {
                this.displayFuture = this.service.scheduleWithFixedDelay(new DisplayRunnable(), 20L, this.displayIntervalInMs, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            LOGGER.error("Find error when start performance statistic thread, because {}", (Throwable)e);
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    @Override
    public void startPrintStatisticsOnce() {
        this.showMeasurements();
    }

    @Override
    public void stopPrintStatistic() {
        this.stateChangeLock.lock();
        try {
            this.displayFuture = this.cancelFuture(this.displayFuture);
        }
        catch (Exception e) {
            LOGGER.error("Find error when stop display thread, because {}", (Throwable)e);
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    @Override
    public void stopStatistic() {
        this.stateChangeLock.lock();
        try {
            this.isEnableStat = false;
            this.displayFuture = this.cancelFuture(this.displayFuture);
            this.consumeFuture = this.cancelFuture(this.consumeFuture);
        }
        catch (Exception e) {
            LOGGER.error("Find error when stop display and consuming threads, because {}", (Throwable)e);
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    @Override
    public void clearStatisticalState() {
        for (Operation op : Operation.values()) {
            this.operationLatenciesQueue[op.ordinal()].clear();
            this.operationCnt[op.ordinal()] = 0L;
            this.operationLatencies[op.ordinal()] = 0L;
            for (int i = 0; i < BUCKET_SIZE; ++i) {
                this.operationHistogram[op.ordinal()][i] = 0L;
            }
        }
    }

    @Override
    public boolean changeOperationSwitch(String operationName, Boolean operationState) {
        if (this.operationSwitch.containsKey(operationName)) {
            this.operationSwitch.put(operationName, operationState);
            return true;
        }
        return false;
    }

    @Override
    public void start() throws StartupException {
        logger.info("start the consuming task in the measurement stats module...");
        this.clearStatisticalState();
        if (this.service.isShutdown()) {
            this.service = IoTDBThreadPoolFactory.newScheduledThreadPool(2, ThreadName.TIME_COST_STATSTIC.getName());
        }
        this.isEnableStat = IoTDBDescriptor.getInstance().getConfig().isEnablePerformanceStat();
        if (this.isEnableStat) {
            this.consumeFuture = this.service.schedule(new QueueConsumerThread(), 0L, TimeUnit.MILLISECONDS);
        }
        try {
            JMXService.registerMBean(INSTANCE, this.mbeanName);
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        logger.info("stop measurement stats module...");
        JMXService.deregisterMBean(this.mbeanName);
        if (this.service == null || this.service.isShutdown()) {
            return;
        }
        this.service.shutdownNow();
        try {
            this.consumeFuture = this.cancelFuture(this.consumeFuture);
            this.displayFuture = this.cancelFuture(this.displayFuture);
            this.service.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Performance statistic service could not be shutdown, {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private ScheduledFuture<?> cancelFuture(ScheduledFuture<?> future) {
        if (future != null) {
            future.cancel(true);
        }
        return null;
    }

    @Override
    public ServiceType getID() {
        return ServiceType.PERFORMANCE_STATISTIC_SERVICE;
    }

    @Override
    public boolean isEnableStat() {
        return this.isEnableStat;
    }

    @Override
    public long getDisplayIntervalInMs() {
        return this.displayIntervalInMs;
    }

    @Override
    public void setDisplayIntervalInMs(long displayIntervalInMs) {
        this.displayIntervalInMs = displayIntervalInMs;
    }

    @Override
    public Map<String, Boolean> getOperationSwitch() {
        return this.operationSwitch;
    }

    private void showMeasurements() {
        Date date = new Date();
        LOGGER.info("====================================={} Measurement (ms)======================================", (Object)date);
        String head = String.format("%-45s%-25s%-25s%-25s", "OPERATION", "COUNT", "TOTAL_TIME", "AVG_TIME");
        LOGGER.info(head);
        for (Operation operation : Operation.values()) {
            if (!this.operationSwitch.get(operation.getName()).booleanValue()) continue;
            long cnt = this.operationCnt[operation.ordinal()];
            long totalInMs = this.operationLatencies[operation.ordinal()];
            String avg = String.format("%.4f", (double)totalInMs / ((double)cnt + 1.0E-9));
            String item = String.format("%-45s%-25s%-25s%-25s", operation.name, cnt + "", totalInMs + "", avg);
            LOGGER.info(item);
        }
        LOGGER.info("==========================================OPERATION HISTOGRAM====================================================");
        StringBuilder histogramHead = new StringBuilder(String.format("%-45s", "OPERATION"));
        for (int i = 0; i < BUCKET_SIZE; ++i) {
            histogramHead.append(String.format("%-8s", BUCKET_IN_MS[i] + "ms"));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(histogramHead.toString());
        }
        for (Operation operation : Operation.values()) {
            if (!this.operationSwitch.get(operation.getName()).booleanValue()) continue;
            StringBuilder item = new StringBuilder(String.format("%-45s", operation.getName()));
            long cnt = this.operationCnt[operation.ordinal()];
            for (int i = 0; i < BUCKET_SIZE; ++i) {
                String avg = String.format("%.2f", (double)this.operationHistogram[operation.ordinal()][i] / ((double)cnt + 1.0E-9) * 100.0);
                item.append(String.format("%-8s", avg + "%"));
            }
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info(item.toString());
        }
        LOGGER.info("=================================================================================================================");
    }

    public long[] getOperationLatencies() {
        return this.operationLatencies;
    }

    public long[] getOperationCnt() {
        return this.operationCnt;
    }

    class QueueConsumerThread
    extends WrappedRunnable {
        QueueConsumerThread() {
        }

        @Override
        public void runMayThrow() {
            this.consumer();
        }

        private void consumer() {
            while (Measurement.this.isEnableStat) {
                boolean allEmpty = true;
                for (Operation op : Operation.values()) {
                    if (!((Boolean)Measurement.this.operationSwitch.get(op.getName())).booleanValue()) continue;
                    int idx = op.ordinal();
                    ConcurrentCircularArray queue = Measurement.this.operationLatenciesQueue[idx];
                    if (!queue.hasData()) continue;
                    long time = queue.take();
                    long[] lArray = Measurement.this.operationLatencies;
                    int n = idx;
                    lArray[n] = lArray[n] + time;
                    long[] lArray2 = Measurement.this.operationCnt;
                    int n2 = idx;
                    lArray2[n2] = lArray2[n2] + 1L;
                    long[] lArray3 = Measurement.this.operationHistogram[idx];
                    int n3 = this.calIndex(time);
                    lArray3[n3] = lArray3[n3] + 1L;
                    allEmpty = false;
                }
                if (!allEmpty) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }

        private int calIndex(long x) {
            for (int i = 0; i < BUCKET_SIZE; ++i) {
                if ((long)BUCKET_IN_MS[i] < x) continue;
                return i;
            }
            return BUCKET_SIZE - 1;
        }
    }

    class DisplayRunnable
    extends WrappedRunnable {
        DisplayRunnable() {
        }

        @Override
        public void runMayThrow() {
            Measurement.this.showMeasurements();
        }
    }

    private static class AsyncMeasurementHolder {
        private static final Measurement MEASUREMENT = new Measurement();

        private AsyncMeasurementHolder() {
        }

        static /* synthetic */ Measurement access$000() {
            return MEASUREMENT;
        }
    }
}

