/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryManager.class);
    private List<String> sequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
    private List<String> unsequenceFileFolders;
    private DirectoryStrategy sequenceStrategy;
    private DirectoryStrategy unsequenceStrategy;

    private DirectoryManager() {
        int i;
        for (i = 0; i < this.sequenceFileFolders.size(); ++i) {
            this.sequenceFileFolders.set(i, this.sequenceFileFolders.get(i) + File.separator + "sequence");
        }
        this.mkDataDirs(this.sequenceFileFolders);
        this.unsequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        for (i = 0; i < this.unsequenceFileFolders.size(); ++i) {
            this.unsequenceFileFolders.set(i, this.unsequenceFileFolders.get(i) + File.separator + "unsequence");
        }
        this.mkDataDirs(this.unsequenceFileFolders);
        String strategyName = "";
        try {
            strategyName = IoTDBDescriptor.getInstance().getConfig().getMultiDirStrategyClassName();
            Class<?> clazz = Class.forName(strategyName);
            this.sequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.sequenceStrategy.setFolders(this.sequenceFileFolders);
            this.unsequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.unsequenceStrategy.setFolders(this.unsequenceFileFolders);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All disks of folders are full.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Can't find strategy {} for mult-directories.", (Object)strategyName, (Object)e);
        }
    }

    public void updateFileFolders() throws LoadConfigurationException {
        try {
            ArrayList<String> sequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
            this.mkDataDirs(sequenceFileFolders);
            ArrayList<String> unsequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
            this.mkDataDirs(unsequenceFileFolders);
            this.sequenceStrategy.setFolders(sequenceFileFolders);
            this.unsequenceStrategy.setFolders(unsequenceFileFolders);
            this.sequenceFileFolders = sequenceFileFolders;
            this.unsequenceFileFolders = unsequenceFileFolders;
            logger.info("Success to update file folders.");
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Fail to update file folders, use previous folders.", (Throwable)e);
            throw new LoadConfigurationException("Fail to update file folders because all disks of folders are full, use previous folders.");
        }
    }

    public void updateDirectoryStrategy() throws LoadConfigurationException {
        String strategyName = "";
        try {
            strategyName = IoTDBDescriptor.getInstance().getConfig().getMultiDirStrategyClassName();
            Class<?> clazz = Class.forName(strategyName);
            this.sequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.sequenceStrategy.setFolders(this.sequenceFileFolders);
            this.unsequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.unsequenceStrategy.setFolders(this.unsequenceFileFolders);
            logger.info("Success to update directory strategy.");
        }
        catch (Exception e) {
            logger.error("Fail to update directory strategy {}, use previous strategy", (Object)strategyName, (Object)e);
            throw new LoadConfigurationException(String.format("Fail to update directory strategy because can't find strategy %s for mult-directories, use previous strategy", strategyName));
        }
    }

    public static DirectoryManager getInstance() {
        return DirectoriesHolder.INSTANCE;
    }

    private void mkDataDirs(List<String> folders) {
        for (String folder : folders) {
            File file = FSFactoryProducer.getFSFactory().getFile(folder);
            if (file.mkdirs()) {
                logger.info("folder {} doesn't exist, create it", (Object)file.getPath());
                continue;
            }
            logger.info("create folder {} failed. Is the folder existed: {}", (Object)file.getPath(), (Object)file.exists());
        }
    }

    public String getNextFolderForSequenceFile() throws DiskSpaceInsufficientException {
        return this.getSequenceFileFolder(this.getNextFolderIndexForSequenceFile());
    }

    public int getNextFolderIndexForSequenceFile() throws DiskSpaceInsufficientException {
        return this.sequenceStrategy.nextFolderIndex();
    }

    public String getSequenceFileFolder(int index) {
        return this.sequenceFileFolders.get(index);
    }

    public List<String> getAllSequenceFileFolders() {
        return new ArrayList<String>(this.sequenceFileFolders);
    }

    public String getWALFolder() {
        return IoTDBDescriptor.getInstance().getConfig().getWalFolder();
    }

    public String getNextFolderForUnSequenceFile() throws DiskSpaceInsufficientException {
        return this.getUnSequenceFileFolder(this.getNextFolderIndexForUnSequenceFile());
    }

    public int getNextFolderIndexForUnSequenceFile() throws DiskSpaceInsufficientException {
        return this.unsequenceStrategy.nextFolderIndex();
    }

    public String getUnSequenceFileFolder(int index) {
        return this.unsequenceFileFolders.get(index);
    }

    public int getUnSequenceFileFolderIndex(String folder) {
        return this.unsequenceFileFolders.indexOf(folder);
    }

    public List<String> getAllUnSequenceFileFolders() {
        return new ArrayList<String>(this.unsequenceFileFolders);
    }

    private static class DirectoriesHolder {
        private static final DirectoryManager INSTANCE = new DirectoryManager();

        private DirectoriesHolder() {
        }
    }
}

