/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.adapter;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.conf.adapter.IDynamicAdapter;
import org.apache.iotdb.db.exception.ConfigAdjusterException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.rescon.PrimitiveArrayPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigDynamicAdapter
implements IDynamicAdapter {
    public static final String CREATE_STORAGE_GROUP = "create storage group";
    public static final String ADD_TIMESERIES = "add timeseries";
    static final int MEM_TABLE_AVERAGE_QUEUE_LEN = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigDynamicAdapter.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long TIMESERIES_METADATA_SIZE_IN_BYTE = 2048L;
    private static final double WAL_MEMORY_RATIO = 0.1;
    public static final int MEMTABLE_NUM_FOR_EACH_PARTITION = 4;
    private static long allocateMemoryForWrite = CONFIG.getAllocateMemoryForWrite();
    private static long CHUNK_METADATA_SIZE_IN_BYTE = 1536L;
    private long staticMemory;
    private int totalStorageGroup;
    private int totalTimeseries;
    private int maxMemTableNum = 5;
    private long currentMemTableSize;
    private boolean initialized = false;

    private IoTDBConfigDynamicAdapter() {
    }

    public static void setChunkMetadataSizeInByte(long chunkMetadataSizeInByte) {
        CHUNK_METADATA_SIZE_IN_BYTE = chunkMetadataSizeInByte;
    }

    public static IoTDBConfigDynamicAdapter getInstance() {
        return IoTDBConfigAdapterHolder.INSTANCE;
    }

    @Override
    public synchronized boolean tryToAdaptParameters() {
        if (!CONFIG.isEnableParameterAdapter()) {
            return true;
        }
        boolean canAdjust = true;
        double ratio = CompressionRatio.getInstance().getRatio();
        long memtableSizeInByte = this.calcMemTableSize(ratio);
        long memTableSizeFloorThreshold = this.getMemTableSizeFloorThreshold();
        long tsFileSizeThreshold = CONFIG.getTsFileSizeThreshold();
        if (memtableSizeInByte < memTableSizeFloorThreshold) {
            if (LOGGER.isDebugEnabled() && this.initialized) {
                LOGGER.debug("memtableSizeInByte {} is smaller than memTableSizeFloorThreshold {}", (Object)memtableSizeInByte, (Object)memTableSizeFloorThreshold);
            }
            if ((long)((double)(tsFileSizeThreshold = this.calcTsFileSizeThreshold(memTableSizeFloorThreshold, ratio)) * ratio) < memTableSizeFloorThreshold) {
                canAdjust = false;
            } else {
                memtableSizeInByte = Math.max(memTableSizeFloorThreshold, memTableSizeFloorThreshold + ((long)((double)tsFileSizeThreshold * ratio) - memTableSizeFloorThreshold >> 1));
            }
        }
        if (canAdjust) {
            CONFIG.setMaxMemtableNumber(this.maxMemTableNum);
            CONFIG.setWalBufferSize((int)Math.min(2.147483647E9, (double)allocateMemoryForWrite * 0.1 / (double)this.maxMemTableNum));
            CONFIG.setTsFileSizeThreshold(tsFileSizeThreshold);
            CONFIG.setMemtableSizeThreshold(memtableSizeInByte);
            if (LOGGER.isDebugEnabled() && this.initialized) {
                LOGGER.debug("After adjusting, max memTable num is {}, tsFile threshold is {}, memtableSize is {}, memTableSizeFloorThreshold is {}, storage group = {}, total timeseries = {}, the max number of timeseries among storage groups = {}", new Object[]{this.maxMemTableNum, tsFileSizeThreshold, memtableSizeInByte, memTableSizeFloorThreshold, this.totalStorageGroup, this.totalTimeseries, MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups()});
            }
            this.currentMemTableSize = memtableSizeInByte;
        }
        if (!this.initialized) {
            CONFIG.setMaxMemtableNumber(this.maxMemTableNum);
            return true;
        }
        return canAdjust;
    }

    private long calcMemTableSize(double ratio) {
        double a = this.maxMemTableNum;
        double b = (double)allocateMemoryForWrite * 0.9 - (double)this.staticMemory;
        int magnification = b > 2.147483647E9 ? 1024 : 1;
        double c = (double)CONFIG.getTsFileSizeThreshold() * (double)this.maxMemTableNum * (double)CHUNK_METADATA_SIZE_IN_BYTE * (double)MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups() * ratio / (double)magnification / (double)magnification;
        double tempValue = (b /= (double)magnification) * b - 4.0 * a * c;
        double memTableSize = (b + Math.sqrt(tempValue)) / (2.0 * a);
        return tempValue < 0.0 ? -1L : (long)(memTableSize * (double)magnification);
    }

    private long calcTsFileSizeThreshold(long memTableSize, double ratio) {
        return (long)(((double)allocateMemoryForWrite * 0.9 - (double)((long)this.maxMemTableNum * memTableSize) - (double)this.staticMemory) * (double)memTableSize / (ratio * (double)this.maxMemTableNum * (double)CHUNK_METADATA_SIZE_IN_BYTE * (double)MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups()));
    }

    private long getMemTableSizeFloorThreshold() {
        return MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups() * (long)PrimitiveArrayPool.ARRAY_SIZE * 8L * 2L;
    }

    @Override
    public void addOrDeleteStorageGroup(int diff) throws ConfigAdjusterException {
        this.totalStorageGroup += diff;
        this.maxMemTableNum += 4 * IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition() * diff + diff;
        if (!CONFIG.isEnableParameterAdapter()) {
            CONFIG.setMaxMemtableNumber(this.maxMemTableNum);
            return;
        }
        if (!this.tryToAdaptParameters()) {
            this.totalStorageGroup -= diff;
            this.maxMemTableNum -= 4 * IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition() * diff + diff;
            throw new ConfigAdjusterException(CREATE_STORAGE_GROUP);
        }
    }

    @Override
    public void addOrDeleteTimeSeries(int diff) throws ConfigAdjusterException {
        if (!CONFIG.isEnableParameterAdapter()) {
            return;
        }
        this.totalTimeseries += diff;
        this.staticMemory += (long)diff * 2048L;
        if (!this.tryToAdaptParameters()) {
            this.totalTimeseries -= diff;
            this.staticMemory -= (long)diff * 2048L;
            throw new ConfigAdjusterException(ADD_TIMESERIES);
        }
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    long getCurrentMemTableSize() {
        return this.currentMemTableSize;
    }

    public int getTotalTimeseries() {
        return this.totalTimeseries;
    }

    public int getTotalStorageGroup() {
        return this.totalStorageGroup;
    }

    public void reset() {
        this.totalTimeseries = 0;
        this.staticMemory = 0L;
        this.maxMemTableNum = 5;
        allocateMemoryForWrite = CONFIG.getAllocateMemoryForWrite();
        this.initialized = false;
    }

    private static class IoTDBConfigAdapterHolder {
        private static final IoTDBConfigDynamicAdapter INSTANCE = new IoTDBConfigDynamicAdapter();

        private IoTDBConfigAdapterHolder() {
        }
    }
}

