/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.adapter;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.adapter.IActiveTimeSeriesCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveTimeSeriesCounter
implements IActiveTimeSeriesCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveTimeSeriesCounter.class);
    private static Map<String, HyperLogLog> storageGroupHllMap = new ConcurrentHashMap<String, HyperLogLog>();
    private static Map<String, Double> activeRatioMap = new ConcurrentHashMap<String, Double>();
    private static Map<String, Long> activeTimeSeriesNumMap = new ConcurrentHashMap<String, Long>();
    static final int LOG2M = 13;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public void init(String storageGroup) {
        storageGroupHllMap.put(storageGroup, new HyperLogLog(13));
        activeRatioMap.put(storageGroup, 0.0);
        activeTimeSeriesNumMap.put(storageGroup, 0L);
    }

    @Override
    public void offer(String storageGroup, String device, String measurement) {
        String path = device + '.' + measurement;
        try {
            HyperLogLog log = storageGroupHllMap.get(storageGroup);
            if (log != null) {
                log.offer((Object)path);
            } else {
                LOGGER.warn("Unknown SG {} is calling HyperLogLog.offer(). It can be ignored the sg is deleted recently", (Object)storageGroup);
            }
        }
        catch (Exception e) {
            LOGGER.error("Storage group {} registers active time series {} failed", new Object[]{storageGroup, path, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateActiveRatio(String storageGroup) {
        this.lock.writeLock().lock();
        try {
            HyperLogLog log = storageGroupHllMap.get(storageGroup);
            if (log == null) {
                LOGGER.warn("Unknown SG {} is calling updateActiveRatio. It can be ignored the sg is deleted recently", (Object)storageGroup);
                return;
            }
            long activeTimeSeriesNum = storageGroupHllMap.get(storageGroup).cardinality();
            if (activeTimeSeriesNum != activeTimeSeriesNumMap.get(storageGroup)) {
                activeTimeSeriesNumMap.put(storageGroup, activeTimeSeriesNum);
                double totalActiveTsNum = 0.0;
                LOGGER.debug("{}: updating active ratio", (Object)Thread.currentThread().getName());
                Iterator<Object> iterator = activeTimeSeriesNumMap.values().iterator();
                while (iterator.hasNext()) {
                    double d = iterator.next().longValue();
                    totalActiveTsNum += d;
                }
                for (Map.Entry entry : activeTimeSeriesNumMap.entrySet()) {
                    double activeRatio = 0.0;
                    if (totalActiveTsNum > 0.0) {
                        activeRatio = (double)((Long)entry.getValue()).longValue() / totalActiveTsNum;
                    }
                    activeRatioMap.put((String)entry.getKey(), activeRatio);
                    LOGGER.debug("{}: storage group {} has an active ratio: {}", new Object[]{Thread.currentThread().getName(), entry.getKey(), activeRatio});
                }
            }
            storageGroupHllMap.put(storageGroup, new HyperLogLog(13));
        }
        catch (Exception e) {
            LOGGER.error("Update {} active ratio failed", (Object)storageGroup, (Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getActiveRatio(String storageGroup) {
        double ratio;
        this.lock.writeLock().lock();
        try {
            ratio = activeRatioMap.get(storageGroup);
        }
        catch (Exception e) {
            ratio = 0.0;
            LOGGER.error("Get active ratio failed", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return ratio;
    }

    @Override
    public void delete(String storageGroup) {
        storageGroupHllMap.remove(storageGroup);
        activeRatioMap.remove(storageGroup);
        activeTimeSeriesNumMap.remove(storageGroup);
    }

    public static ActiveTimeSeriesCounter getInstance() {
        return ActiveTimeSeriesCounterHolder.INSTANCE;
    }

    public static void clear() {
        storageGroupHllMap = new ConcurrentHashMap<String, HyperLogLog>();
        activeRatioMap = new ConcurrentHashMap<String, Double>();
        activeTimeSeriesNumMap = new ConcurrentHashMap<String, Long>();
    }

    private static class ActiveTimeSeriesCounterHolder {
        private static final ActiveTimeSeriesCounter INSTANCE = new ActiveTimeSeriesCounter();

        private ActiveTimeSeriesCounterHolder() {
        }
    }
}

