/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.time.ZoneId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.merge.selector.MergeFileStrategy;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    static final String CONFIG_NAME = "iotdb-engine.properties";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "MaxDiskUsableSpaceFirstStrategy";
    private static final String ID_MATCHER = "([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+)";
    private static final String NODE_MATCHER = "[.]([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+)";
    private static final String NODE_WITH_QUOTATION_MARK_MATCHER = "[.][\"|']([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+)([.]([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+))*[\"|']";
    public static final Pattern PATH_PATTERN = Pattern.compile("root([.]([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+))+([.][\"|']([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+)([.]([a-zA-Z0-9/@#$%&{}\\[\\]\\-+\\u2E80-\\u9FFF_]+))*[\"|'])?");
    private int metricsPort = 8181;
    private boolean enableMetricService = false;
    private boolean enableMQTTService = false;
    private String mqttHost = "0.0.0.0";
    private int mqttPort = 1883;
    private int mqttHandlerPoolSize = 1;
    private String mqttPayloadFormatter = "json";
    private int mqttMaxMessageSize = 0x100000;
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private int rpcPort = 6667;
    private int rpcMaxConcurrentClientNum = 65535;
    private long allocateMemoryForWrite = Runtime.getRuntime().maxMemory() * 6L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private boolean enableParameterAdapter = false;
    private boolean enableWal = true;
    private volatile boolean readOnly = false;
    private int flushWalThreshold = 10000;
    private String timestampPrecision = "ms";
    private long forceWalPeriodInMs = 10L;
    private int walBufferSize = 0x1000000;
    private String baseDir = "data";
    private String systemDir = "data" + File.separator + "system";
    private String schemaDir = "data" + File.separator + "system" + File.separator + "schema";
    private String syncDir = "data" + File.separator + "system" + File.separator + "sync";
    private String queryDir = "data" + File.separator + "query";
    private String[] dataDirs = new String[]{"data" + File.separator + "data"};
    private String multiDirStrategyClassName = null;
    private String walFolder = "data" + File.separator + "wal";
    private int maxMemtableNumber = 20;
    private int batchSize = 100000;
    private int concurrentFlushThread = Runtime.getRuntime().availableProcessors();
    private int concurrentQueryThread = Runtime.getRuntime().availableProcessors();
    private ZoneId zoneID = ZoneId.systemDefault();
    private long tsFileSizeThreshold = 0x20000000L;
    private long memtableSizeThreshold = 0x8000000L;
    private int avgSeriesPointNumberThreshold = 500000;
    private boolean metaDataCacheEnable = true;
    private long allocateMemoryForTimeSeriesMetaDataCache = this.allocateMemoryForRead * 10L / 39L;
    private long allocateMemoryForChunkMetaDataCache = this.allocateMemoryForRead * 5L / 39L;
    private long allocateMemoryForChunkCache = this.allocateMemoryForRead * 5L / 39L;
    private int backLoopPeriodSec = 5;
    private boolean enableStatMonitor = false;
    private int statMonitorDetectFreqSec = 600;
    private int statMonitorRetainIntervalSec = 600;
    private int mManagerCacheSize = 400000;
    private boolean enableExternalSort = true;
    private int externalSortThreshold = 60;
    private boolean isSyncEnable = true;
    private int syncServerPort = 5555;
    private String languageVersion = "EN";
    private String ipWhiteList = "0.0.0.0/0";
    private long cacheFileReaderClearPeriod = 100000L;
    private String rpcImplClassName = TSServiceImpl.class.getName();
    private boolean enablePerformanceStat = false;
    private long performanceStatDisplayInterval = 60000L;
    private int performanceStatMemoryInKB = 20;
    private boolean chunkBufferPoolEnable = false;
    private boolean enableWatermark = false;
    private String watermarkSecretKey = "QWERTYUIOP*&=";
    private String watermarkBitString = "11001010010101";
    private String watermarkMethod = "GroupBasedLSBMethod(embed_row_cycle=5,embed_lsb_num=5)";
    private boolean enableAutoCreateSchema = true;
    private TSDataType booleanStringInferType = TSDataType.BOOLEAN;
    private TSDataType integerStringInferType = TSDataType.FLOAT;
    private TSDataType floatingStringInferType = TSDataType.FLOAT;
    private TSDataType nanStringInferType = TSDataType.DOUBLE;
    private int defaultStorageGroupLevel = 1;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.RLE;
    private TSEncoding defaultInt64Encoding = TSEncoding.RLE;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private long mergeMemoryBudget = (long)((double)Runtime.getRuntime().maxMemory() * 0.2);
    private int upgradeThreadNum = 1;
    private int mergeThreadNum = 1;
    private int mergeChunkSubThreadNum = 4;
    private long mergeFileSelectionTimeBudget = 30000L;
    private boolean continueMergeAfterReboot = true;
    private long mergeIntervalSec = 7200L;
    private boolean forceFullMerge = false;
    private int chunkMergePointThreshold = 20480;
    private MergeFileStrategy mergeFileStrategy = MergeFileStrategy.MAX_SERIES_NUM;
    private FSType systemFileStorageFs = FSType.LOCAL;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "principal";
    private int concurrentWritingTimePartition = 1;
    private int defaultFillInterval = -1;
    private long defaultTTL = Long.MAX_VALUE;
    private int primitiveArraySize = 64;
    private boolean enablePartition = false;
    private long partitionInterval = 604800L;
    private int thriftServerAwaitTimeForStopService = 60;
    private int queryCacheSizeInMetric = 50;
    private int tagAttributeTotalSize = 700;
    private boolean enablePartialInsert = true;
    private String openIdProviderUrl = null;
    private String authorizerProvider = "org.apache.iotdb.db.auth.authorizer.LocalFileAuthorizer";
    private long startUpNanosecond = System.nanoTime();

    public int getConcurrentWritingTimePartition() {
        return this.concurrentWritingTimePartition;
    }

    void setConcurrentWritingTimePartition(int concurrentWritingTimePartition) {
        this.concurrentWritingTimePartition = concurrentWritingTimePartition;
    }

    public int getDefaultFillInterval() {
        return this.defaultFillInterval;
    }

    public void setDefaultFillInterval(int defaultFillInterval) {
        this.defaultFillInterval = defaultFillInterval;
    }

    public boolean isEnablePartition() {
        return this.enablePartition;
    }

    public void setEnablePartition(boolean enablePartition) {
        this.enablePartition = enablePartition;
    }

    public long getPartitionInterval() {
        return this.partitionInterval;
    }

    public void setPartitionInterval(long partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public ZoneId getZoneID() {
        return this.zoneID;
    }

    void setZoneID(ZoneId zoneID) {
        this.zoneID = zoneID;
    }

    void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        this.baseDir = this.addHomeDir(this.baseDir);
        this.systemDir = this.addHomeDir(this.systemDir);
        this.schemaDir = this.addHomeDir(this.schemaDir);
        this.syncDir = this.addHomeDir(this.syncDir);
        this.walFolder = this.addHomeDir(this.walFolder);
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            this.queryDir = hdfsDir + File.separatorChar + this.queryDir;
            for (int i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = hdfsDir + File.separatorChar + this.dataDirs[i];
            }
        } else {
            this.queryDir = this.addHomeDir(this.queryDir);
            for (int i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = this.addHomeDir(this.dataDirs[i]);
            }
        }
    }

    void reloadDataDirs(String[] dataDirs) throws LoadConfigurationException {
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = hdfsDir + File.separatorChar + dataDirs[i];
            }
        } else {
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = this.addHomeDir(dataDirs[i]);
            }
        }
        this.dataDirs = dataDirs;
        DirectoryManager.getInstance().updateFileFolders();
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("IOTDB_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    private void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy");
        }
    }

    private String getHdfsDir() {
        String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
        String hdfsDir = "hdfs://";
        hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
        return hdfsDir;
    }

    public String[] getDataDirs() {
        return this.dataDirs;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    public boolean isEnableMetricService() {
        return this.enableMetricService;
    }

    public void setEnableMetricService(boolean enableMetricService) {
        this.enableMetricService = enableMetricService;
    }

    void setDataDirs(String[] dataDirs) {
        this.dataDirs = dataDirs;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!(timestampPrecision.equals("ms") || timestampPrecision.equals("us") || timestampPrecision.equals("ns"))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: " + timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public boolean isEnableWal() {
        return this.enableWal;
    }

    public void setEnableWal(boolean enableWal) {
        this.enableWal = enableWal;
    }

    public int getFlushWalThreshold() {
        return this.flushWalThreshold;
    }

    public void setFlushWalThreshold(int flushWalThreshold) {
        this.flushWalThreshold = flushWalThreshold;
    }

    public long getForceWalPeriodInMs() {
        return this.forceWalPeriodInMs;
    }

    public void setForceWalPeriodInMs(long forceWalPeriodInMs) {
        this.forceWalPeriodInMs = forceWalPeriodInMs;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getWalFolder() {
        return this.walFolder;
    }

    void setWalFolder(String walFolder) {
        this.walFolder = walFolder;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getConcurrentFlushThread() {
        return this.concurrentFlushThread;
    }

    void setConcurrentFlushThread(int concurrentFlushThread) {
        this.concurrentFlushThread = concurrentFlushThread;
    }

    public int getConcurrentQueryThread() {
        return this.concurrentQueryThread;
    }

    void setConcurrentQueryThread(int concurrentQueryThread) {
        this.concurrentQueryThread = concurrentQueryThread;
    }

    public long getTsFileSizeThreshold() {
        return this.tsFileSizeThreshold;
    }

    public void setTsFileSizeThreshold(long tsFileSizeThreshold) {
        this.tsFileSizeThreshold = tsFileSizeThreshold;
    }

    public int getBackLoopPeriodSec() {
        return this.backLoopPeriodSec;
    }

    void setBackLoopPeriodSec(int backLoopPeriodSec) {
        this.backLoopPeriodSec = backLoopPeriodSec;
    }

    public boolean isEnableStatMonitor() {
        return this.enableStatMonitor;
    }

    public void setEnableStatMonitor(boolean enableStatMonitor) {
        this.enableStatMonitor = enableStatMonitor;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getStatMonitorDetectFreqSec() {
        return this.statMonitorDetectFreqSec;
    }

    void setStatMonitorDetectFreqSec(int statMonitorDetectFreqSec) {
        this.statMonitorDetectFreqSec = statMonitorDetectFreqSec;
    }

    public int getStatMonitorRetainIntervalSec() {
        return this.statMonitorRetainIntervalSec;
    }

    void setStatMonitorRetainIntervalSec(int statMonitorRetainIntervalSec) {
        this.statMonitorRetainIntervalSec = statMonitorRetainIntervalSec;
    }

    public int getmManagerCacheSize() {
        return this.mManagerCacheSize;
    }

    void setmManagerCacheSize(int mManagerCacheSize) {
        this.mManagerCacheSize = mManagerCacheSize;
    }

    public boolean isSyncEnable() {
        return this.isSyncEnable;
    }

    void setSyncEnable(boolean syncEnable) {
        this.isSyncEnable = syncEnable;
    }

    public int getSyncServerPort() {
        return this.syncServerPort;
    }

    void setSyncServerPort(int syncServerPort) {
        this.syncServerPort = syncServerPort;
    }

    String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    public void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getMergeMemoryBudget() {
        return this.mergeMemoryBudget;
    }

    void setMergeMemoryBudget(long mergeMemoryBudget) {
        this.mergeMemoryBudget = mergeMemoryBudget;
    }

    public int getMergeThreadNum() {
        return this.mergeThreadNum;
    }

    void setMergeThreadNum(int mergeThreadNum) {
        this.mergeThreadNum = mergeThreadNum;
    }

    public boolean isContinueMergeAfterReboot() {
        return this.continueMergeAfterReboot;
    }

    void setContinueMergeAfterReboot(boolean continueMergeAfterReboot) {
        this.continueMergeAfterReboot = continueMergeAfterReboot;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public boolean isEnableParameterAdapter() {
        return this.enableParameterAdapter;
    }

    public void setEnableParameterAdapter(boolean enableParameterAdapter) {
        this.enableParameterAdapter = enableParameterAdapter;
    }

    public long getAllocateMemoryForWrite() {
        return this.allocateMemoryForWrite;
    }

    public void setAllocateMemoryForWrite(long allocateMemoryForWrite) {
        this.allocateMemoryForWrite = allocateMemoryForWrite;
    }

    long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
    }

    public boolean isEnableExternalSort() {
        return this.enableExternalSort;
    }

    void setEnableExternalSort(boolean enableExternalSort) {
        this.enableExternalSort = enableExternalSort;
    }

    public int getExternalSortThreshold() {
        return this.externalSortThreshold;
    }

    void setExternalSortThreshold(int externalSortThreshold) {
        this.externalSortThreshold = externalSortThreshold;
    }

    public boolean isEnablePerformanceStat() {
        return this.enablePerformanceStat;
    }

    public void setEnablePerformanceStat(boolean enablePerformanceStat) {
        this.enablePerformanceStat = enablePerformanceStat;
    }

    public long getPerformanceStatDisplayInterval() {
        return this.performanceStatDisplayInterval;
    }

    void setPerformanceStatDisplayInterval(long performanceStatDisplayInterval) {
        this.performanceStatDisplayInterval = performanceStatDisplayInterval;
    }

    public int getPerformanceStatMemoryInKB() {
        return this.performanceStatMemoryInKB;
    }

    void setPerformanceStatMemoryInKB(int performanceStatMemoryInKB) {
        this.performanceStatMemoryInKB = performanceStatMemoryInKB;
    }

    public boolean isEnablePartialInsert() {
        return this.enablePartialInsert;
    }

    public void setEnablePartialInsert(boolean enablePartialInsert) {
        this.enablePartialInsert = enablePartialInsert;
    }

    public boolean isForceFullMerge() {
        return this.forceFullMerge;
    }

    void setForceFullMerge(boolean forceFullMerge) {
        this.forceFullMerge = forceFullMerge;
    }

    public int getChunkMergePointThreshold() {
        return this.chunkMergePointThreshold;
    }

    public void setChunkMergePointThreshold(int chunkMergePointThreshold) {
        this.chunkMergePointThreshold = chunkMergePointThreshold;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }

    public int getAvgSeriesPointNumberThreshold() {
        return this.avgSeriesPointNumberThreshold;
    }

    public void setAvgSeriesPointNumberThreshold(int avgSeriesPointNumberThreshold) {
        this.avgSeriesPointNumberThreshold = avgSeriesPointNumberThreshold;
    }

    public MergeFileStrategy getMergeFileStrategy() {
        return this.mergeFileStrategy;
    }

    public void setMergeFileStrategy(MergeFileStrategy mergeFileStrategy) {
        this.mergeFileStrategy = mergeFileStrategy;
    }

    public int getMergeChunkSubThreadNum() {
        return this.mergeChunkSubThreadNum;
    }

    void setMergeChunkSubThreadNum(int mergeChunkSubThreadNum) {
        this.mergeChunkSubThreadNum = mergeChunkSubThreadNum;
    }

    public long getMergeFileSelectionTimeBudget() {
        return this.mergeFileSelectionTimeBudget;
    }

    void setMergeFileSelectionTimeBudget(long mergeFileSelectionTimeBudget) {
        this.mergeFileSelectionTimeBudget = mergeFileSelectionTimeBudget;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public long getAllocateMemoryForTimeSeriesMetaDataCache() {
        return this.allocateMemoryForTimeSeriesMetaDataCache;
    }

    public void setAllocateMemoryForTimeSeriesMetaDataCache(long allocateMemoryForTimeSeriesMetaDataCache) {
        this.allocateMemoryForTimeSeriesMetaDataCache = allocateMemoryForTimeSeriesMetaDataCache;
    }

    public long getAllocateMemoryForChunkMetaDataCache() {
        return this.allocateMemoryForChunkMetaDataCache;
    }

    public void setAllocateMemoryForChunkMetaDataCache(long allocateMemoryForChunkMetaDataCache) {
        this.allocateMemoryForChunkMetaDataCache = allocateMemoryForChunkMetaDataCache;
    }

    public long getAllocateMemoryForChunkCache() {
        return this.allocateMemoryForChunkCache;
    }

    public void setAllocateMemoryForChunkCache(long allocateMemoryForChunkCache) {
        this.allocateMemoryForChunkCache = allocateMemoryForChunkCache;
    }

    public boolean isEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public String getWatermarkSecretKey() {
        return this.watermarkSecretKey;
    }

    public void setWatermarkSecretKey(String watermarkSecretKey) {
        this.watermarkSecretKey = watermarkSecretKey;
    }

    public String getWatermarkBitString() {
        return this.watermarkBitString;
    }

    public void setWatermarkBitString(String watermarkBitString) {
        this.watermarkBitString = watermarkBitString;
    }

    String getWatermarkMethod() {
        return this.watermarkMethod;
    }

    public void setWatermarkMethod(String watermarkMethod) {
        this.watermarkMethod = watermarkMethod;
    }

    public String getWatermarkMethodName() {
        return this.watermarkMethod.split("\\(")[0];
    }

    public int getWatermarkParamMarkRate() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_row_cycle", "5"));
    }

    public int getWatermarkParamMaxRightBit() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_lsb_num", "5"));
    }

    private String getWatermarkParamValue(String key, String defaultValue) {
        String res = this.getWatermarkParamValue(key);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    private String getWatermarkParamValue(String key) {
        String pattern = key + "=(\\w*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.watermarkMethod);
        if (m.find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public TSDataType getBooleanStringInferType() {
        return this.booleanStringInferType;
    }

    public void setBooleanStringInferType(TSDataType booleanStringInferType) {
        this.booleanStringInferType = booleanStringInferType;
    }

    public TSDataType getIntegerStringInferType() {
        return this.integerStringInferType;
    }

    public void setIntegerStringInferType(TSDataType integerStringInferType) {
        this.integerStringInferType = integerStringInferType;
    }

    public TSDataType getFloatingStringInferType() {
        return this.floatingStringInferType;
    }

    public void setFloatingStringInferType(TSDataType floatingNumberStringInferType) {
        this.floatingStringInferType = floatingNumberStringInferType;
    }

    public TSDataType getNanStringInferType() {
        return this.nanStringInferType;
    }

    public void setNanStringInferType(TSDataType nanStringInferType) {
        if (nanStringInferType != TSDataType.DOUBLE && nanStringInferType != TSDataType.FLOAT && nanStringInferType != TSDataType.TEXT) {
            throw new IllegalArgumentException("Config Property nan_string_infer_type can only be FLOAT, DOUBLE or TEXT but is " + nanStringInferType);
        }
        this.nanStringInferType = nanStringInferType;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    void setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(String systemFileStorageFs) {
        this.systemFileStorageFs = FSType.valueOf((String)systemFileStorageFs);
    }

    FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    String getCoreSitePath() {
        return this.coreSitePath;
    }

    void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    String getRawHDFSIp() {
        return this.hdfsIp;
    }

    void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    String getHdfsPort() {
        return this.hdfsPort;
    }

    void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getUpgradeThreadNum() {
        return this.upgradeThreadNum;
    }

    void setUpgradeThreadNum(int upgradeThreadNum) {
        this.upgradeThreadNum = upgradeThreadNum;
    }

    String getDfsNameServices() {
        return this.dfsNameServices;
    }

    void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    String getRawDfsHaNamenodes() {
        return this.dfsHaNamenodes;
    }

    void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    boolean isUseKerberos() {
        return this.useKerberos;
    }

    void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public int getQueryCacheSizeInMetric() {
        return this.queryCacheSizeInMetric;
    }

    public void setQueryCacheSizeInMetric(int queryCacheSizeInMetric) {
        this.queryCacheSizeInMetric = queryCacheSizeInMetric;
    }

    public boolean isEnableMQTTService() {
        return this.enableMQTTService;
    }

    public void setEnableMQTTService(boolean enableMQTTService) {
        this.enableMQTTService = enableMQTTService;
    }

    public String getMqttHost() {
        return this.mqttHost;
    }

    public void setMqttHost(String mqttHost) {
        this.mqttHost = mqttHost;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttHandlerPoolSize() {
        return this.mqttHandlerPoolSize;
    }

    public void setMqttHandlerPoolSize(int mqttHandlerPoolSize) {
        this.mqttHandlerPoolSize = mqttHandlerPoolSize;
    }

    public String getMqttPayloadFormatter() {
        return this.mqttPayloadFormatter;
    }

    public void setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.mqttPayloadFormatter = mqttPayloadFormatter;
    }

    public int getMqttMaxMessageSize() {
        return this.mqttMaxMessageSize;
    }

    public void setMqttMaxMessageSize(int mqttMaxMessageSize) {
        this.mqttMaxMessageSize = mqttMaxMessageSize;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    public void setPrimitiveArraySize(int primitiveArraySize) {
        this.primitiveArraySize = primitiveArraySize;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }
}

