/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.Authorizator;
import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.MQTTConnection;
import io.moquette.broker.NettyUtils;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.Session;
import io.moquette.broker.SessionRegistry;
import io.moquette.broker.Utils;
import io.moquette.broker.subscriptions.ISubscriptionsDirectory;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.interception.BrokerInterceptor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PostOffice {
    private static final Logger LOG = LoggerFactory.getLogger(PostOffice.class);
    private final Authorizator authorizator;
    private final ISubscriptionsDirectory subscriptions;
    private final IRetainedRepository retainedRepository;
    private SessionRegistry sessionRegistry;
    private BrokerInterceptor interceptor;

    PostOffice(ISubscriptionsDirectory subscriptions, IRetainedRepository retainedRepository, SessionRegistry sessionRegistry, BrokerInterceptor interceptor, Authorizator authorizator) {
        this.authorizator = authorizator;
        this.subscriptions = subscriptions;
        this.retainedRepository = retainedRepository;
        this.sessionRegistry = sessionRegistry;
        this.interceptor = interceptor;
    }

    public void init(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void fireWill(Session.Will will) {
        this.publish2Subscribers(will.payload, new Topic(will.topic), will.qos);
    }

    public void subscribeClientToTopics(MqttSubscribeMessage msg, String clientID, String username, MQTTConnection mqttConnection) {
        int messageID = Utils.messageId((MqttMessage)msg);
        List<MqttTopicSubscription> ackTopics = this.authorizator.verifyTopicsReadAccess(clientID, username, msg);
        MqttSubAckMessage ackMessage = this.doAckMessageFromValidateFilters(ackTopics, messageID);
        List<Subscription> newSubscriptions = ackTopics.stream().filter(req -> req.qualityOfService() != MqttQoS.FAILURE).map(req -> {
            Topic topic = new Topic(req.topicName());
            return new Subscription(clientID, topic, req.qualityOfService());
        }).collect(Collectors.toList());
        for (Subscription subscription : newSubscriptions) {
            this.subscriptions.add(subscription);
        }
        Session session = this.sessionRegistry.retrieve(clientID);
        session.addSubscriptions(newSubscriptions);
        mqttConnection.sendSubAckMessage(messageID, ackMessage);
        this.publishRetainedMessagesForSubscriptions(clientID, newSubscriptions);
        for (Subscription subscription : newSubscriptions) {
            this.interceptor.notifyTopicSubscribed(subscription, username);
        }
    }

    private void publishRetainedMessagesForSubscriptions(String clientID, List<Subscription> newSubscriptions) {
        Session targetSession = this.sessionRegistry.retrieve(clientID);
        for (Subscription subscription : newSubscriptions) {
            String topicFilter = subscription.getTopicFilter().toString();
            List<RetainedMessage> retainedMsgs = this.retainedRepository.retainedOnTopic(topicFilter);
            if (retainedMsgs.isEmpty()) continue;
            for (RetainedMessage retainedMsg : retainedMsgs) {
                MqttQoS retainedQos = retainedMsg.qosLevel();
                MqttQoS qos = PostOffice.lowerQosToTheSubscriptionDesired(subscription, retainedQos);
                ByteBuf payloadBuf = Unpooled.wrappedBuffer((byte[])retainedMsg.getPayload());
                targetSession.sendRetainedPublishOnSessionAtQos(retainedMsg.getTopic(), qos, payloadBuf);
            }
        }
    }

    private MqttSubAckMessage doAckMessageFromValidateFilters(List<MqttTopicSubscription> topicFilters, int messageId) {
        ArrayList<Integer> grantedQoSLevels = new ArrayList<Integer>();
        for (MqttTopicSubscription req : topicFilters) {
            grantedQoSLevels.add(req.qualityOfService().value());
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttSubAckPayload payload = new MqttSubAckPayload(grantedQoSLevels);
        return new MqttSubAckMessage(fixedHeader, MqttMessageIdVariableHeader.from((int)messageId), payload);
    }

    public void unsubscribe(List<String> topics, MQTTConnection mqttConnection, int messageId) {
        String clientID = mqttConnection.getClientId();
        for (String t : topics) {
            Topic topic = new Topic(t);
            boolean validTopic = topic.isValid();
            if (!validTopic) {
                mqttConnection.dropConnection();
                LOG.warn("Topic filter is not valid. CId={}, topics: {}, offending topic filter: {}", new Object[]{clientID, topics, topic});
                return;
            }
            LOG.trace("Removing subscription. CId={}, topic={}", (Object)clientID, (Object)topic);
            this.subscriptions.removeSubscription(topic, clientID);
            String username = NettyUtils.userName(mqttConnection.channel);
            this.interceptor.notifyTopicUnsubscribed(topic.toString(), clientID, username);
        }
        mqttConnection.sendUnsubAckMessage(topics, clientID, messageId);
    }

    void receivedPublishQos0(Topic topic, String username, String clientID, ByteBuf payload, boolean retain, MqttPublishMessage msg) {
        if (!this.authorizator.canWrite(topic, username, clientID)) {
            LOG.error("MQTT client: {} is not authorized to publish on topic: {}", (Object)clientID, (Object)topic);
            return;
        }
        this.publish2Subscribers(payload, topic, MqttQoS.AT_MOST_ONCE);
        if (retain) {
            this.retainedRepository.cleanRetained(topic);
        }
        this.interceptor.notifyTopicPublished(msg, clientID, username);
    }

    void receivedPublishQos1(MQTTConnection connection, Topic topic, String username, ByteBuf payload, int messageID, boolean retain, MqttPublishMessage msg) {
        topic.getTokens();
        if (!topic.isValid()) {
            LOG.warn("Invalid topic format, force close the connection");
            connection.dropConnection();
            return;
        }
        String clientId = connection.getClientId();
        if (!this.authorizator.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client: {} is not authorized to publish on topic: {}", (Object)clientId, (Object)topic);
            return;
        }
        this.publish2Subscribers(payload, topic, MqttQoS.AT_LEAST_ONCE);
        connection.sendPubAck(messageID);
        if (retain) {
            if (!payload.isReadable()) {
                this.retainedRepository.cleanRetained(topic);
            } else {
                this.retainedRepository.retain(topic, msg);
            }
        }
        this.interceptor.notifyTopicPublished(msg, clientId, username);
    }

    private void publish2Subscribers(ByteBuf origPayload, Topic topic, MqttQoS publishingQos) {
        Set<Subscription> topicMatchingSubscriptions = this.subscriptions.matchQosSharpening(topic);
        for (Subscription sub : topicMatchingSubscriptions) {
            boolean isSessionPresent;
            MqttQoS qos = PostOffice.lowerQosToTheSubscriptionDesired(sub, publishingQos);
            Session targetSession = this.sessionRegistry.retrieve(sub.getClientId());
            boolean bl = isSessionPresent = targetSession != null;
            if (isSessionPresent) {
                LOG.debug("Sending PUBLISH message to active subscriber CId: {}, topicFilter: {}, qos: {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos});
                ByteBuf payload = origPayload.retainedDuplicate();
                targetSession.sendPublishOnSessionAtQos(topic, qos, payload);
                continue;
            }
            LOG.debug("PUBLISH to not yet present session. CId: {}, topicFilter: {}, qos: {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos});
        }
    }

    void receivedPublishQos2(MQTTConnection connection, MqttPublishMessage mqttPublishMessage, String username) {
        LOG.trace("Processing PUBREL message on connection: {}", (Object)connection);
        Topic topic = new Topic(mqttPublishMessage.variableHeader().topicName());
        ByteBuf payload = mqttPublishMessage.payload();
        String clientId = connection.getClientId();
        if (!this.authorizator.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client is not authorized to publish on topic. CId={}, topic: {}", (Object)clientId, (Object)topic);
            return;
        }
        this.publish2Subscribers(payload, topic, MqttQoS.EXACTLY_ONCE);
        boolean retained = mqttPublishMessage.fixedHeader().isRetain();
        if (retained) {
            if (!payload.isReadable()) {
                this.retainedRepository.cleanRetained(topic);
            } else {
                this.retainedRepository.retain(topic, mqttPublishMessage);
            }
        }
        String clientID = connection.getClientId();
        this.interceptor.notifyTopicPublished(mqttPublishMessage, clientID, username);
    }

    static MqttQoS lowerQosToTheSubscriptionDesired(Subscription sub, MqttQoS qos) {
        if (qos.value() > sub.getRequestedQos().value()) {
            qos = sub.getRequestedQos();
        }
        return qos;
    }

    public void internalPublish(MqttPublishMessage msg) {
        MqttQoS qos = msg.fixedHeader().qosLevel();
        Topic topic = new Topic(msg.variableHeader().topicName());
        ByteBuf payload = msg.payload();
        LOG.info("Sending internal PUBLISH message Topic={}, qos={}", (Object)topic, (Object)qos);
        this.publish2Subscribers(payload, topic, qos);
        if (!msg.fixedHeader().isRetain()) {
            return;
        }
        if (qos == MqttQoS.AT_MOST_ONCE || msg.payload().readableBytes() == 0) {
            this.retainedRepository.cleanRetained(topic);
            return;
        }
        this.retainedRepository.retain(topic, msg);
    }

    void dispatchConnection(MqttConnectMessage msg) {
        this.interceptor.notifyClientConnected(msg);
    }

    void dispatchDisconnection(String clientId, String userName) {
        this.interceptor.notifyClientDisconnected(clientId, userName);
    }

    void dispatchConnectionLost(String clientId, String userName) {
        this.interceptor.notifyClientConnectionLost(clientId, userName);
    }
}

