/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.ICompressor;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.page.PageWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkWriterImpl
implements IChunkWriter {
    private static final Logger logger = LoggerFactory.getLogger(ChunkWriterImpl.class);
    private MeasurementSchema measurementSchema;
    private ICompressor compressor;
    private PublicBAOS pageBuffer;
    private int numOfPages;
    private PageWriter pageWriter;
    private final long pageSizeThreshold;
    private final int maxNumberOfPointsInPage;
    private int valueCountInOnePageForNextCheck;
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 1500;
    private Statistics<?> statistics;

    public ChunkWriterImpl(MeasurementSchema schema) {
        this.measurementSchema = schema;
        this.compressor = ICompressor.getCompressor(schema.getCompressor());
        this.pageBuffer = new PublicBAOS();
        this.pageSizeThreshold = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.maxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        this.valueCountInOnePageForNextCheck = 1500;
        this.statistics = Statistics.getStatsByType(this.measurementSchema.getType());
        this.pageWriter = new PageWriter(this.measurementSchema);
        this.pageWriter.setTimeEncoder(this.measurementSchema.getTimeEncoder());
        this.pageWriter.setValueEncoder(this.measurementSchema.getValueEncoder());
    }

    @Override
    public void write(long time, long value) {
        this.pageWriter.write(time, value);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, int value) {
        this.pageWriter.write(time, value);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, boolean value) {
        this.pageWriter.write(time, value);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, float value) {
        this.pageWriter.write(time, value);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, double value) {
        this.pageWriter.write(time, value);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, Binary value) {
        this.pageWriter.write(time, value);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, int[] values, int batchSize) {
        this.pageWriter.write(timestamps, values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, long[] values, int batchSize) {
        this.pageWriter.write(timestamps, values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, boolean[] values, int batchSize) {
        this.pageWriter.write(timestamps, values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, float[] values, int batchSize) {
        this.pageWriter.write(timestamps, values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, double[] values, int batchSize) {
        this.pageWriter.write(timestamps, values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, Binary[] values, int batchSize) {
        this.pageWriter.write(timestamps, values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    private void checkPageSizeAndMayOpenANewPage() {
        if (this.pageWriter.getPointNumber() == (long)this.maxNumberOfPointsInPage) {
            logger.debug("current line count reaches the upper bound, write page {}", (Object)this.measurementSchema);
            this.writePageToPageBuffer();
        } else if (this.pageWriter.getPointNumber() >= (long)this.valueCountInOnePageForNextCheck) {
            long currentPageSize = this.pageWriter.estimateMaxMemSize();
            if (currentPageSize > this.pageSizeThreshold) {
                logger.debug("enough size, write page {}, pageSizeThreshold:{}, currentPateSize:{}, valueCountInOnePage:{}", new Object[]{this.measurementSchema.getMeasurementId(), this.pageSizeThreshold, currentPageSize, this.pageWriter.getPointNumber()});
                this.writePageToPageBuffer();
                this.valueCountInOnePageForNextCheck = 1500;
            } else {
                this.valueCountInOnePageForNextCheck = (int)((float)this.pageSizeThreshold / (float)currentPageSize * (float)this.pageWriter.getPointNumber());
            }
        }
    }

    private void writePageToPageBuffer() {
        try {
            this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer);
            ++this.numOfPages;
            this.statistics.mergeStatistics(this.pageWriter.getStatistics());
        }
        catch (IOException e) {
            logger.error("meet error in pageWriter.writePageHeaderAndDataIntoBuff,ignore this page:", (Throwable)e);
        }
        finally {
            this.pageWriter.reset(this.measurementSchema);
        }
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.sealCurrentPage();
        this.writeAllPagesOfChunkToTsFile(tsfileWriter, this.statistics);
        this.pageBuffer.reset();
        this.statistics = Statistics.getStatsByType(this.measurementSchema.getType());
    }

    @Override
    public long estimateMaxSeriesMemSize() {
        return this.pageWriter.estimateMaxMemSize() + this.estimateMaxPageMemSize();
    }

    @Override
    public long getCurrentChunkSize() {
        if (this.pageBuffer.size() == 0) {
            return 0L;
        }
        return (long)ChunkHeader.getSerializedSize(this.measurementSchema.getMeasurementId()) + (long)this.pageBuffer.size();
    }

    @Override
    public void sealCurrentPage() {
        if (this.pageWriter.getPointNumber() > 0L) {
            this.writePageToPageBuffer();
        }
    }

    @Override
    public int getNumOfPages() {
        return this.numOfPages;
    }

    @Override
    public TSDataType getDataType() {
        return this.measurementSchema.getType();
    }

    public void writePageHeaderAndDataIntoBuff(ByteBuffer data, PageHeader header) throws PageException {
        ++this.numOfPages;
        try {
            logger.debug("start to flush a page header into buffer, buffer position {} ", (Object)this.pageBuffer.size());
            header.serializeTo(this.pageBuffer);
            logger.debug("finish to flush a page header {} of {} into buffer, buffer position {} ", new Object[]{header, this.measurementSchema.getMeasurementId(), this.pageBuffer.size()});
            this.statistics.mergeStatistics(header.getStatistics());
        }
        catch (IOException e) {
            throw new PageException("IO Exception in writeDataPageHeader,ignore this page", e);
        }
        try (WritableByteChannel channel = Channels.newChannel(this.pageBuffer);){
            channel.write(data);
        }
        catch (IOException e) {
            throw new PageException(e);
        }
    }

    public void writeAllPagesOfChunkToTsFile(TsFileIOWriter writer, Statistics<?> statistics) throws IOException {
        if (statistics.getCount() == 0L) {
            return;
        }
        writer.startFlushChunk(this.measurementSchema, this.compressor.getType(), this.measurementSchema.getType(), this.measurementSchema.getEncodingType(), statistics, this.pageBuffer.size(), this.numOfPages);
        long dataOffset = writer.getPos();
        writer.writeBytesToStream(this.pageBuffer);
        long dataSize = writer.getPos() - dataOffset;
        if (dataSize != (long)this.pageBuffer.size()) {
            throw new IOException("Bytes written is inconsistent with the size of data: " + dataSize + " != " + this.pageBuffer.size());
        }
        writer.endCurrentChunk();
    }

    private long estimateMaxPageMemSize() {
        return this.pageBuffer.size() + PageHeader.calculatePageHeaderSizeWithoutStatistics() + this.pageWriter.getStatistics().getSerializedSize();
    }
}

