/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.metadata;

import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsDigestV1 {
    private ByteBuffer[] statistics;

    public static TsDigestV1 deserializeFrom(ByteBuffer buffer) {
        TsDigestV1 digest = new TsDigestV1();
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            digest.statistics = new ByteBuffer[StatisticType.getTotalTypeNum()];
            for (int i = 0; i < size; ++i) {
                ByteBuffer value;
                short n = ReadWriteIOUtils.readShort(buffer);
                digest.statistics[n] = value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
            }
        }
        return digest;
    }

    public ByteBuffer[] getStatistics() {
        return this.statistics;
    }

    public static enum StatisticType {
        MIN_VALUE,
        MAX_VALUE,
        FIRST_VALUE,
        LAST_VALUE,
        SUM_VALUE;


        public static int getTotalTypeNum() {
            return StatisticType.values().length;
        }
    }
}

