/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.ChunkGroupMetaDataV1;

public class TsDeviceMetadataV1 {
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private List<ChunkGroupMetaDataV1> chunkGroupMetadataList = new ArrayList<ChunkGroupMetaDataV1>();

    public static TsDeviceMetadataV1 deserializeFrom(ByteBuffer buffer) {
        TsDeviceMetadataV1 deviceMetadata = new TsDeviceMetadataV1();
        deviceMetadata.startTime = ReadWriteIOUtils.readLong(buffer);
        deviceMetadata.endTime = ReadWriteIOUtils.readLong(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            ArrayList<ChunkGroupMetaDataV1> chunkGroupMetaDataList = new ArrayList<ChunkGroupMetaDataV1>();
            for (int i = 0; i < size; ++i) {
                chunkGroupMetaDataList.add(ChunkGroupMetaDataV1.deserializeFrom(buffer));
            }
            deviceMetadata.chunkGroupMetadataList = chunkGroupMetaDataList;
        }
        return deviceMetadata;
    }

    public List<ChunkGroupMetaDataV1> getChunkGroupMetaDataList() {
        return Collections.unmodifiableList(this.chunkGroupMetadataList);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

