/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;

public class LocalTsFileInput
implements TsFileInput {
    private FileChannel channel;

    public LocalTsFileInput(Path file) throws IOException {
        this.channel = FileChannel.open(file, StandardOpenOption.READ);
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public TsFileInput position(long newPosition) throws IOException {
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.channel.read(dst, position);
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileChannel wrapAsFileChannel() throws IOException {
        return this.channel;
    }

    @Override
    public InputStream wrapAsInputStream() throws IOException {
        return Channels.newInputStream(this.channel);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public int readInt() throws IOException {
        throw new UnsupportedOperationException();
    }
}

