/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;

public class TsFileTimeGenerator
extends TimeGenerator {
    private IChunkLoader chunkLoader;
    private IMetadataQuerier metadataQuerier;

    public TsFileTimeGenerator(IExpression iexpression, IChunkLoader chunkLoader, IMetadataQuerier metadataQuerier) throws IOException {
        this.chunkLoader = chunkLoader;
        this.metadataQuerier = metadataQuerier;
        super.constructNode(iexpression);
    }

    @Override
    protected IBatchReader generateNewBatchReader(SingleSeriesExpression expression) throws IOException {
        List<ChunkMetadata> chunkMetadataList = this.metadataQuerier.getChunkMetaDataList(expression.getSeriesPath());
        return new FileSeriesReader(this.chunkLoader, chunkMetadataList, expression.getFilter());
    }
}

