/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.util.ArrayList;
import java.util.List;

public class TimeColumn {
    private static final int capacityThreshold = 1000;
    private int capacity = 16;
    private int readCurListIndex;
    private int readCurArrayIndex;
    private int writeCurListIndex;
    private int writeCurArrayIndex;
    private int count;
    private List<long[]> timeRet;

    public TimeColumn() {
        this.readCurListIndex = 0;
        this.readCurArrayIndex = 0;
        this.writeCurListIndex = 0;
        this.writeCurArrayIndex = 0;
        this.timeRet = new ArrayList<long[]>();
        this.timeRet.add(new long[this.capacity]);
        this.count = 0;
    }

    public TimeColumn(List<long[]> timeRet, int count, int capacity) {
        this.count = count;
        this.readCurListIndex = 0;
        this.readCurArrayIndex = 0;
        this.capacity = capacity;
        this.writeCurListIndex = count / capacity;
        this.writeCurArrayIndex = count % capacity;
        this.timeRet = timeRet;
    }

    public void add(long time) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = time;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public boolean hasCurrent() {
        if (this.readCurListIndex == this.writeCurListIndex) {
            return this.readCurArrayIndex < this.writeCurArrayIndex;
        }
        return this.readCurListIndex < this.writeCurListIndex && this.readCurArrayIndex < this.capacity;
    }

    public long currentTime() {
        return this.timeRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void next() {
        ++this.readCurArrayIndex;
        if (this.readCurArrayIndex == this.capacity) {
            this.readCurArrayIndex = 0;
            ++this.readCurListIndex;
        }
    }

    public int size() {
        return this.count;
    }
}

