/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.exception.write.UnknownColumnTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.BinaryStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.BooleanStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.DoubleStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.FloatStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.LongStatistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Statistics<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Statistics.class);
    protected boolean isEmpty = true;
    private long count = 0L;
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;

    public static Statistics getStatsByType(TSDataType type) {
        switch (type) {
            case INT32: {
                return new IntegerStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case TEXT: {
                return new BinaryStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
        }
        throw new UnknownColumnTypeException(type.toString());
    }

    public abstract TSDataType getType();

    public int getSerializedSize() {
        return 24 + this.getStatsSize();
    }

    public abstract int getStatsSize();

    public int serialize(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.count, outputStream);
        byteLen += ReadWriteIOUtils.write(this.startTime, outputStream);
        byteLen += ReadWriteIOUtils.write(this.endTime, outputStream);
        return byteLen += this.serializeStats(outputStream);
    }

    abstract int serializeStats(OutputStream var1) throws IOException;

    abstract void deserialize(InputStream var1) throws IOException;

    abstract void deserialize(ByteBuffer var1);

    public abstract void setMinMaxFromBytes(byte[] var1, byte[] var2);

    public abstract T getMinValue();

    public abstract T getMaxValue();

    public abstract T getFirstValue();

    public abstract T getLastValue();

    public abstract double getSumValue();

    public abstract byte[] getMinValueBytes();

    public abstract byte[] getMaxValueBytes();

    public abstract byte[] getFirstValueBytes();

    public abstract byte[] getLastValueBytes();

    public abstract byte[] getSumValueBytes();

    public abstract ByteBuffer getMinValueBuffer();

    public abstract ByteBuffer getMaxValueBuffer();

    public abstract ByteBuffer getFirstValueBuffer();

    public abstract ByteBuffer getLastValueBuffer();

    public abstract ByteBuffer getSumValueBuffer();

    public void mergeStatistics(Statistics stats) {
        if (this.getClass() == stats.getClass()) {
            if (stats.startTime < this.startTime) {
                this.startTime = stats.startTime;
            }
            if (stats.endTime > this.endTime) {
                this.endTime = stats.endTime;
            }
            this.count += stats.count;
        } else {
            String thisClass = this.getClass().toString();
            String statsClass = stats.getClass().toString();
            LOG.warn("Statistics classes mismatched,no merge: {} v.s. {}", (Object)thisClass, (Object)statsClass);
            throw new StatisticsClassException(this.getClass(), stats.getClass());
        }
        this.mergeStatisticsValue(stats);
        this.isEmpty = false;
    }

    public void update(long time, boolean value) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
        this.updateStats(value);
    }

    public void update(long time, int value) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
        this.updateStats(value);
    }

    public void update(long time, long value) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
        this.updateStats(value);
    }

    public void update(long time, float value) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
        this.updateStats(value);
    }

    public void update(long time, double value) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
        this.updateStats(value);
    }

    public void update(long time, Binary value) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
        this.updateStats(value);
    }

    public void update(long[] time, boolean[] values, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += (long)batchSize;
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, int[] values, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += (long)batchSize;
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, long[] values, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += (long)batchSize;
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, float[] values, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += (long)batchSize;
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, double[] values, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += (long)batchSize;
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, Binary[] values, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += (long)batchSize;
        this.updateStats(values, batchSize);
    }

    protected abstract void mergeStatisticsValue(Statistics var1);

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(boolean[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(int[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(long[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(float[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(double[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(Binary[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long min, long max) {
        throw new UnsupportedOperationException();
    }

    public static Statistics deserialize(InputStream inputStream, TSDataType dataType) throws IOException {
        Statistics statistics = Statistics.getStatsByType(dataType);
        statistics.setCount(ReadWriteIOUtils.readLong(inputStream));
        statistics.setStartTime(ReadWriteIOUtils.readLong(inputStream));
        statistics.setEndTime(ReadWriteIOUtils.readLong(inputStream));
        statistics.deserialize(inputStream);
        statistics.isEmpty = false;
        return statistics;
    }

    public static Statistics deserialize(ByteBuffer buffer, TSDataType dataType) {
        Statistics statistics = Statistics.getStatsByType(dataType);
        statistics.setCount(ReadWriteIOUtils.readLong(buffer));
        statistics.setStartTime(ReadWriteIOUtils.readLong(buffer));
        statistics.setEndTime(ReadWriteIOUtils.readLong(buffer));
        statistics.deserialize(buffer);
        statistics.isEmpty = false;
        return statistics;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getCount() {
        return this.count;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public abstract long calculateRamSize();

    public String toString() {
        return "startTime: " + this.startTime + " endTime: " + this.endTime + " count: " + this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }
}

