/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum TSDataType {
    BOOLEAN,
    INT32,
    INT64,
    FLOAT,
    DOUBLE,
    TEXT;


    public static TSDataType deserialize(short i) {
        if (i >= 6) {
            throw new IllegalArgumentException("Invalid input: " + i);
        }
        switch (i) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INT32;
            }
            case 2: {
                return INT64;
            }
            case 3: {
                return FLOAT;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return TEXT;
            }
        }
        return TEXT;
    }

    public static TSDataType deserializeFrom(ByteBuffer buffer) {
        return TSDataType.deserialize(buffer.getShort());
    }

    public static int getSerializedSize() {
        return 2;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.putShort(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.writeShort(this.serialize());
    }

    public short serialize() {
        switch (this) {
            case BOOLEAN: {
                return 0;
            }
            case INT32: {
                return 1;
            }
            case INT64: {
                return 2;
            }
            case FLOAT: {
                return 3;
            }
            case DOUBLE: {
                return 4;
            }
            case TEXT: {
                return 5;
            }
        }
        return -1;
    }
}

